/*
 * Decompiled with CFR 0.152.
 */
package aws.smithy.kotlin.runtime.testing;

import java.io.IOException;
import java.io.InputStream;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.random.Random;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000b\n\u0002\b\t\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0004\u0018\u0000 \u00142\u00020\u0001:\u0001\u0014B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u000e\u001a\u00020\u000fH\u0016J \u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u000f2\u0006\u0010\u0013\u001a\u00020\u000fH\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0007\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\n\u001a\u00020\u0003X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\t\"\u0004\b\f\u0010\r\u00a8\u0006\u0015"}, d2={"Laws/smithy/kotlin/runtime/testing/RandomInputStream;", "Ljava/io/InputStream;", "lengthInBytes", "", "binaryData", "", "(JZ)V", "bytesRead", "getBytesRead", "()J", "remainingBytes", "getRemainingBytes", "setRemainingBytes", "(J)V", "read", "", "b", "", "off", "len", "Companion", "testing"})
public final class RandomInputStream
extends InputStream {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final long lengthInBytes;
    private final boolean binaryData;
    private long remainingBytes;
    private static final int MIN_CHAR_CODE = 32;
    private static final int MAX_CHAR_CODE = 125;

    public RandomInputStream(long lengthInBytes, boolean binaryData) {
        this.lengthInBytes = lengthInBytes;
        this.binaryData = binaryData;
        this.remainingBytes = this.lengthInBytes;
    }

    public /* synthetic */ RandomInputStream(long l, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            bl = false;
        }
        this(l, bl);
    }

    protected final long getRemainingBytes() {
        return this.remainingBytes;
    }

    protected final void setRemainingBytes(long l) {
        this.remainingBytes = l;
    }

    public final long getBytesRead() {
        return this.lengthInBytes - this.remainingBytes;
    }

    @Override
    public int read(@NotNull byte[] b, int off, int len) throws IOException {
        Intrinsics.checkNotNullParameter((Object)b, (String)"b");
        if (this.remainingBytes <= 0L) {
            return -1;
        }
        int bytesToRead = len;
        if ((long)bytesToRead > this.remainingBytes) {
            bytesToRead = (int)this.remainingBytes;
        }
        this.remainingBytes -= (long)bytesToRead;
        if (this.binaryData) {
            int endExclusive = off + bytesToRead;
            Random.Default.nextBytes(b, off, endExclusive);
        } else {
            int n = bytesToRead;
            for (int i = 0; i < n; ++i) {
                b[off + i] = (byte)Random.Default.nextInt(32, 126);
            }
        }
        return bytesToRead;
    }

    @Override
    public int read() throws IOException {
        if (this.remainingBytes <= 0L) {
            return -1;
        }
        long l = this.remainingBytes;
        this.remainingBytes = l + -1L;
        return this.binaryData ? Random.Default.nextInt() : Random.Default.nextInt(32, 126);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Laws/smithy/kotlin/runtime/testing/RandomInputStream$Companion;", "", "()V", "MAX_CHAR_CODE", "", "MIN_CHAR_CODE", "testing"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

