/*
 * Decompiled with CFR 0.152.
 */
package aws.smithy.kotlin.runtime.telemetry.otel;

import aws.smithy.kotlin.runtime.collections.AttributeKey;
import aws.smithy.kotlin.runtime.collections.Attributes;
import aws.smithy.kotlin.runtime.telemetry.otel.AttributeUtilsKt;
import aws.smithy.kotlin.runtime.telemetry.otel.OtelSpanContextImpl;
import aws.smithy.kotlin.runtime.telemetry.otel.OtelTracerProviderKt;
import aws.smithy.kotlin.runtime.telemetry.trace.SpanStatus;
import aws.smithy.kotlin.runtime.telemetry.trace.TraceSpan;
import io.opentelemetry.api.trace.Span;
import io.opentelemetry.api.trace.SpanContext;
import io.opentelemetry.context.Scope;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\f\u001a\u00020\rH\u0016J\u0018\u0010\u000e\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u0010\u0010\u0013\u001a\u00020\r2\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J.\u0010\u0014\u001a\u00020\r\"\b\b\u0000\u0010\u0015*\u00020\u00162\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u0002H\u00150\u00182\u0006\u0010\u0019\u001a\u0002H\u0015H\u0096\u0002\u00a2\u0006\u0002\u0010\u001aJ\u0010\u0010\u001b\u001a\u00020\r2\u0006\u0010\u001c\u001a\u00020\u001dH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\u00020\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u0016\u0010\t\u001a\n \u000b*\u0004\u0018\u00010\n0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Laws/smithy/kotlin/runtime/telemetry/otel/OtelTraceSpanImpl;", "Laws/smithy/kotlin/runtime/telemetry/trace/TraceSpan;", "otelSpan", "Lio/opentelemetry/api/trace/Span;", "(Lio/opentelemetry/api/trace/Span;)V", "spanContext", "Laws/smithy/kotlin/runtime/telemetry/trace/SpanContext;", "getSpanContext", "()Laws/smithy/kotlin/runtime/telemetry/trace/SpanContext;", "spanScope", "Lio/opentelemetry/context/Scope;", "kotlin.jvm.PlatformType", "close", "", "emitEvent", "name", "", "attributes", "Laws/smithy/kotlin/runtime/collections/Attributes;", "mergeAttributes", "set", "T", "", "key", "Laws/smithy/kotlin/runtime/collections/AttributeKey;", "value", "(Laws/smithy/kotlin/runtime/collections/AttributeKey;Ljava/lang/Object;)V", "setStatus", "status", "Laws/smithy/kotlin/runtime/telemetry/trace/SpanStatus;", "telemetry-provider-otel"})
public final class OtelTraceSpanImpl
implements TraceSpan {
    @NotNull
    private final Span otelSpan;
    private final Scope spanScope;

    public OtelTraceSpanImpl(@NotNull Span otelSpan) {
        Intrinsics.checkNotNullParameter((Object)otelSpan, (String)"otelSpan");
        this.otelSpan = otelSpan;
        this.spanScope = this.otelSpan.makeCurrent();
    }

    @NotNull
    public aws.smithy.kotlin.runtime.telemetry.trace.SpanContext getSpanContext() {
        SpanContext spanContext = this.otelSpan.getSpanContext();
        Intrinsics.checkNotNullExpressionValue((Object)spanContext, (String)"getSpanContext(...)");
        return new OtelSpanContextImpl(spanContext);
    }

    public <T> void set(@NotNull AttributeKey<T> key, @NotNull T value) {
        block0: {
            Intrinsics.checkNotNullParameter(key, (String)"key");
            Intrinsics.checkNotNullParameter(value, (String)"value");
            io.opentelemetry.api.common.AttributeKey<T> attributeKey = AttributeUtilsKt.otelAttrKeyOrNull(key, value);
            if (attributeKey == null) break block0;
            io.opentelemetry.api.common.AttributeKey<T> otelKey = attributeKey;
            boolean bl = false;
            this.otelSpan.setAttribute(otelKey, value);
        }
    }

    public void mergeAttributes(@NotNull Attributes attributes) {
        Intrinsics.checkNotNullParameter((Object)attributes, (String)"attributes");
        this.otelSpan.setAllAttributes(AttributeUtilsKt.toOtelAttributes(attributes));
    }

    public void emitEvent(@NotNull String name, @NotNull Attributes attributes) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)attributes, (String)"attributes");
        boolean bl = attributes.isEmpty();
        if (bl) {
            this.otelSpan.addEvent(name);
        } else if (!bl) {
            this.otelSpan.addEvent(name, AttributeUtilsKt.toOtelAttributes(attributes));
        }
    }

    public void setStatus(@NotNull SpanStatus status) {
        Intrinsics.checkNotNullParameter((Object)status, (String)"status");
        this.otelSpan.setStatus(OtelTracerProviderKt.access$toOtelStatus(status));
    }

    public void close() {
        this.otelSpan.end();
        this.spanScope.close();
    }
}

