/*
 * Decompiled with CFR 0.152.
 */
package aws.smithy.kotlin.runtime.telemetry.otel;

import aws.smithy.kotlin.runtime.ExperimentalApi;
import aws.smithy.kotlin.runtime.telemetry.GlobalTelemetryProvider;
import aws.smithy.kotlin.runtime.telemetry.TelemetryProvider;
import aws.smithy.kotlin.runtime.telemetry.context.ContextManager;
import aws.smithy.kotlin.runtime.telemetry.logging.LoggerProvider;
import aws.smithy.kotlin.runtime.telemetry.metrics.MeterProvider;
import aws.smithy.kotlin.runtime.telemetry.otel.OtelContextManager;
import aws.smithy.kotlin.runtime.telemetry.otel.OtelMeterProvider;
import aws.smithy.kotlin.runtime.telemetry.otel.OtelTracerProvider;
import aws.smithy.kotlin.runtime.telemetry.trace.TracerProvider;
import io.opentelemetry.api.OpenTelemetry;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@ExperimentalApi
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0007\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\r\u001a\u00020\u000eX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0011\u001a\u00020\u0012X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006\u0015"}, d2={"Laws/smithy/kotlin/runtime/telemetry/otel/OpenTelemetryProvider;", "Laws/smithy/kotlin/runtime/telemetry/TelemetryProvider;", "otel", "Lio/opentelemetry/api/OpenTelemetry;", "loggerProvider", "Laws/smithy/kotlin/runtime/telemetry/logging/LoggerProvider;", "(Lio/opentelemetry/api/OpenTelemetry;Laws/smithy/kotlin/runtime/telemetry/logging/LoggerProvider;)V", "contextManager", "Laws/smithy/kotlin/runtime/telemetry/context/ContextManager;", "getContextManager", "()Laws/smithy/kotlin/runtime/telemetry/context/ContextManager;", "getLoggerProvider", "()Laws/smithy/kotlin/runtime/telemetry/logging/LoggerProvider;", "meterProvider", "Laws/smithy/kotlin/runtime/telemetry/metrics/MeterProvider;", "getMeterProvider", "()Laws/smithy/kotlin/runtime/telemetry/metrics/MeterProvider;", "tracerProvider", "Laws/smithy/kotlin/runtime/telemetry/trace/TracerProvider;", "getTracerProvider", "()Laws/smithy/kotlin/runtime/telemetry/trace/TracerProvider;", "telemetry-provider-otel"})
public final class OpenTelemetryProvider
implements TelemetryProvider {
    @NotNull
    private final OpenTelemetry otel;
    @NotNull
    private final LoggerProvider loggerProvider;
    @NotNull
    private final TracerProvider tracerProvider;
    @NotNull
    private final MeterProvider meterProvider;
    @NotNull
    private final ContextManager contextManager;

    public OpenTelemetryProvider(@NotNull OpenTelemetry otel, @NotNull LoggerProvider loggerProvider) {
        Intrinsics.checkNotNullParameter((Object)otel, (String)"otel");
        Intrinsics.checkNotNullParameter((Object)loggerProvider, (String)"loggerProvider");
        this.otel = otel;
        this.loggerProvider = loggerProvider;
        this.tracerProvider = new OtelTracerProvider(this.otel);
        this.meterProvider = new OtelMeterProvider(this.otel);
        this.contextManager = OtelContextManager.INSTANCE;
    }

    public /* synthetic */ OpenTelemetryProvider(OpenTelemetry openTelemetry, LoggerProvider loggerProvider, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            loggerProvider = GlobalTelemetryProvider.INSTANCE.getInstance().getLoggerProvider();
        }
        this(openTelemetry, loggerProvider);
    }

    @NotNull
    public LoggerProvider getLoggerProvider() {
        return this.loggerProvider;
    }

    @NotNull
    public TracerProvider getTracerProvider() {
        return this.tracerProvider;
    }

    @NotNull
    public MeterProvider getMeterProvider() {
        return this.meterProvider;
    }

    @NotNull
    public ContextManager getContextManager() {
        return this.contextManager;
    }
}

