/*
 * Decompiled with CFR 0.152.
 */
package aws.smithy.kotlin.runtime.serde.xml;

import aws.smithy.kotlin.runtime.serde.DeserializationException;
import aws.smithy.kotlin.runtime.serde.Deserializer;
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor;
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor;
import aws.smithy.kotlin.runtime.serde.xml.FieldLocation;
import aws.smithy.kotlin.runtime.serde.xml.XmlDeserializerKt;
import aws.smithy.kotlin.runtime.serde.xml.XmlStreamReader;
import aws.smithy.kotlin.runtime.serde.xml.XmlStructDeserializer;
import aws.smithy.kotlin.runtime.serde.xml.XmlToken;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000p\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0005\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0001\n\u0000\n\u0002\u0010\n\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B-\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u000e\b\u0002\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u00a2\u0006\u0002\u0010\u000bJ\b\u0010\u000e\u001a\u00020\rH\u0016J\b\u0010\u000f\u001a\u00020\u0010H\u0016J\b\u0010\u0011\u001a\u00020\u0012H\u0016J\b\u0010\u0013\u001a\u00020\u0014H\u0016J\b\u0010\u0015\u001a\u00020\u0016H\u0016J\b\u0010\u0017\u001a\u00020\u0018H\u0016J\n\u0010\u0019\u001a\u0004\u0018\u00010\u001aH\u0016J\b\u0010\u001b\u001a\u00020\u001cH\u0016J\b\u0010\u001d\u001a\u00020\u001eH\u0016J'\u0010\u001f\u001a\u0002H \"\u0004\b\u0000\u0010 2\u0012\u0010!\u001a\u000e\u0012\u0004\u0012\u00020\u001e\u0012\u0004\u0012\u0002H 0\"H\u0002\u00a2\u0006\u0002\u0010#J\u000f\u0010$\u001a\u0004\u0018\u00010\u0016H\u0016\u00a2\u0006\u0002\u0010%J\b\u0010&\u001a\u00020\rH\u0002J\b\u0010'\u001a\u00020(H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006)"}, d2={"Laws/smithy/kotlin/runtime/serde/xml/XmlStructDeserializer;", "Laws/smithy/kotlin/runtime/serde/Deserializer$FieldIterator;", "objDescriptor", "Laws/smithy/kotlin/runtime/serde/SdkObjectDescriptor;", "reader", "Laws/smithy/kotlin/runtime/serde/xml/XmlStreamReader;", "parentToken", "Laws/smithy/kotlin/runtime/serde/xml/XmlToken$BeginElement;", "parsedFieldLocations", "", "Laws/smithy/kotlin/runtime/serde/xml/FieldLocation;", "(Laws/smithy/kotlin/runtime/serde/SdkObjectDescriptor;Laws/smithy/kotlin/runtime/serde/xml/XmlStreamReader;Laws/smithy/kotlin/runtime/serde/xml/XmlToken$BeginElement;Ljava/util/List;)V", "reentryFlag", "", "deserializeBoolean", "deserializeByte", "", "deserializeDouble", "", "deserializeFloat", "", "deserializeInt", "", "deserializeLong", "", "deserializeNull", "", "deserializeShort", "", "deserializeString", "", "deserializeValue", "T", "transform", "Lkotlin/Function1;", "(Lkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "findNextFieldIndex", "()Ljava/lang/Integer;", "inNestedMode", "skipValue", "", "serde-xml"})
public final class XmlStructDeserializer
implements Deserializer.FieldIterator {
    @NotNull
    private final SdkObjectDescriptor objDescriptor;
    @NotNull
    private final XmlStreamReader reader;
    @NotNull
    private final XmlToken.BeginElement parentToken;
    @NotNull
    private final List<FieldLocation> parsedFieldLocations;
    private boolean reentryFlag;

    public XmlStructDeserializer(@NotNull SdkObjectDescriptor objDescriptor, @NotNull XmlStreamReader reader, @NotNull XmlToken.BeginElement parentToken, @NotNull List<FieldLocation> parsedFieldLocations) {
        Intrinsics.checkNotNullParameter((Object)objDescriptor, (String)"objDescriptor");
        Intrinsics.checkNotNullParameter((Object)reader, (String)"reader");
        Intrinsics.checkNotNullParameter((Object)parentToken, (String)"parentToken");
        Intrinsics.checkNotNullParameter(parsedFieldLocations, (String)"parsedFieldLocations");
        this.objDescriptor = objDescriptor;
        this.reader = reader;
        this.parentToken = parentToken;
        this.parsedFieldLocations = parsedFieldLocations;
    }

    public /* synthetic */ XmlStructDeserializer(SdkObjectDescriptor sdkObjectDescriptor, XmlStreamReader xmlStreamReader, XmlToken.BeginElement beginElement, List list, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            list = new ArrayList();
        }
        this(sdkObjectDescriptor, xmlStreamReader, beginElement, list);
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public Integer findNextFieldIndex() {
        Integer n;
        if (this.inNestedMode()) {
            this.parsedFieldLocations.clear();
        }
        if (this.parsedFieldLocations.isEmpty()) {
            Collection destination$iv$iv;
            XmlToken token;
            XmlToken xmlToken = token = this.reader.nextToken();
            if (xmlToken == null ? true : xmlToken instanceof XmlToken.EndDocument) {
                return null;
            }
            if (token instanceof XmlToken.EndElement) {
                return this.findNextFieldIndex();
            }
            if (token instanceof XmlToken.BeginElement) {
                void $this$mapNotNullTo$iv$iv;
                void $this$filterTo$iv$iv;
                XmlToken xmlToken2 = XmlStreamReader.DefaultImpls.peek$default(this.reader, 0, 1, null);
                if (xmlToken2 == null) {
                    return null;
                }
                XmlToken nextToken = xmlToken2;
                List objectFields = this.objDescriptor.getFields();
                Iterable $this$filter$iv = objectFields;
                boolean $i$f$filter = false;
                Iterable iterable = $this$filter$iv;
                Iterable destination$iv$iv2 = new ArrayList();
                boolean $i$f$filterTo = false;
                for (Object element$iv$iv : $this$filterTo$iv$iv) {
                    SdkFieldDescriptor field2 = (SdkFieldDescriptor)element$iv$iv;
                    boolean bl = false;
                    if (!XmlDeserializerKt.access$fieldTokenMatcher(this.objDescriptor, field2, (XmlToken.BeginElement)token)) continue;
                    destination$iv$iv2.add(element$iv$iv);
                }
                List memberFields = (List)destination$iv$iv2;
                Iterable $this$mapNotNull$iv = memberFields;
                boolean $i$f$mapNotNull = false;
                destination$iv$iv2 = $this$mapNotNull$iv;
                destination$iv$iv = new ArrayList();
                boolean $i$f$mapNotNullTo = false;
                void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                boolean $i$f$forEach = false;
                Iterator iterator = $this$forEach$iv$iv$iv.iterator();
                while (iterator.hasNext()) {
                    FieldLocation it$iv$iv;
                    Object element$iv$iv$iv;
                    Object element$iv$iv = element$iv$iv$iv = iterator.next();
                    boolean bl = false;
                    SdkFieldDescriptor it = (SdkFieldDescriptor)element$iv$iv;
                    boolean bl2 = false;
                    if (XmlDeserializerKt.access$findFieldLocation(it, (XmlToken.BeginElement)token, nextToken) == null) continue;
                    boolean bl3 = false;
                    destination$iv$iv.add(it$iv$iv);
                }
            } else {
                return this.findNextFieldIndex();
            }
            List matchingFields = (List)destination$iv$iv;
            List matchedFieldLocations = matchingFields;
            Iterable $this$sortedBy$iv = matchedFieldLocations;
            boolean $i$f$sortedBy = false;
            this.parsedFieldLocations.addAll(CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

                public final int compare(T a, T b) {
                    FieldLocation it = (FieldLocation)a;
                    boolean bl = false;
                    Comparable comparable = Boolean.valueOf(it instanceof FieldLocation.Text);
                    it = (FieldLocation)b;
                    Comparable comparable2 = comparable;
                    bl = false;
                    return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Boolean.valueOf(it instanceof FieldLocation.Text));
                }
            }));
        }
        FieldLocation fieldLocation = (FieldLocation)CollectionsKt.firstOrNull(this.parsedFieldLocations);
        return fieldLocation == null ? Integer.valueOf(-1) : (n = Integer.valueOf(fieldLocation.getFieldIndex()));
    }

    /*
     * WARNING - void declaration
     */
    private final <T> T deserializeValue(Function1<? super String, ? extends T> transform) {
        Object object;
        this.reentryFlag = false;
        if (this.parsedFieldLocations.isEmpty()) {
            throw new DeserializationException("matchedFields is empty, was findNextFieldIndex() called?");
        }
        FieldLocation nextField = (FieldLocation)CollectionsKt.removeFirst(this.parsedFieldLocations);
        if (nextField instanceof FieldLocation.Text) {
            String string;
            XmlToken peekToken = XmlStreamReader.DefaultImpls.peek$default(this.reader, 0, 1, null);
            if (peekToken instanceof XmlToken.Text) {
                XmlStreamReader $this$takeNextAs$iv = this.reader;
                boolean $i$f$takeNextAs = false;
                XmlToken xmlToken = $this$takeNextAs$iv.nextToken();
                if (xmlToken == null) {
                    throw new DeserializationException("Expected " + Reflection.getOrCreateKotlinClass(XmlToken.Text.class) + " but instead found null");
                }
                XmlToken token$iv = xmlToken;
                boolean $i$f$requireToken = false;
                if (!Intrinsics.areEqual((Object)Reflection.getOrCreateKotlinClass(token$iv.getClass()), (Object)Reflection.getOrCreateKotlinClass(XmlToken.Text.class))) {
                    throw new DeserializationException("expected " + Reflection.getOrCreateKotlinClass(XmlToken.Text.class) + "; found " + Reflection.getOrCreateKotlinClass(token$iv.getClass()) + " (" + token$iv + ')');
                }
                string = ((XmlToken.Text)((XmlToken)((XmlToken.Text)token$iv))).getValue();
                if (string == null) {
                    string = "";
                }
            } else if (peekToken instanceof XmlToken.EndElement) {
                string = "";
            } else {
                throw new DeserializationException(Intrinsics.stringPlus((String)"Unexpected token ", (Object)peekToken));
            }
            String value = string;
            object = transform.invoke((Object)value);
        } else if (nextField instanceof FieldLocation.Attribute) {
            void $this$mapNotNullTo$iv$iv;
            void $this$mapNotNull$iv;
            Iterable peekToken = ((FieldLocation.Attribute)nextField).getNames();
            Function1<? super String, ? extends T> function1 = transform;
            boolean $i$f$mapNotNull = false;
            void $this$takeNextAs$iv = $this$mapNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv$iv$iv.iterator();
            while (iterator.hasNext()) {
                String it$iv$iv;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator.next();
                boolean bl = false;
                XmlToken.QualifiedName it = (XmlToken.QualifiedName)element$iv$iv;
                boolean bl2 = false;
                if (this.parentToken.getAttributes().get(it) == null) continue;
                boolean bl3 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            String string = (String)CollectionsKt.firstOrNull((List)((List)destination$iv$iv));
            if (string == null) {
                throw new DeserializationException("Expected attrib value " + CollectionsKt.first((Iterable)((FieldLocation.Attribute)nextField).getNames()) + " not found in " + this.parentToken.getName());
            }
            object = function1.invoke((Object)string);
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return (T)object;
    }

    public void skipValue() {
        this.reader.skipNext();
    }

    public byte deserializeByte() {
        return ((Number)this.deserializeValue(deserializeByte.1.INSTANCE)).byteValue();
    }

    public int deserializeInt() {
        return ((Number)this.deserializeValue(deserializeInt.1.INSTANCE)).intValue();
    }

    public short deserializeShort() {
        return ((Number)this.deserializeValue(deserializeShort.1.INSTANCE)).shortValue();
    }

    public long deserializeLong() {
        return ((Number)this.deserializeValue(deserializeLong.1.INSTANCE)).longValue();
    }

    public float deserializeFloat() {
        return ((Number)this.deserializeValue(deserializeFloat.1.INSTANCE)).floatValue();
    }

    public double deserializeDouble() {
        return ((Number)this.deserializeValue(deserializeDouble.1.INSTANCE)).doubleValue();
    }

    @NotNull
    public String deserializeString() {
        return (String)this.deserializeValue(deserializeString.1.INSTANCE);
    }

    public boolean deserializeBoolean() {
        return (Boolean)this.deserializeValue(deserializeBoolean.1.INSTANCE);
    }

    @Nullable
    public Void deserializeNull() {
        XmlStreamReader $this$takeNextAs$iv = this.reader;
        boolean $i$f$takeNextAs = false;
        XmlToken xmlToken = $this$takeNextAs$iv.nextToken();
        if (xmlToken == null) {
            throw new DeserializationException("Expected " + Reflection.getOrCreateKotlinClass(XmlToken.EndElement.class) + " but instead found null");
        }
        XmlToken token$iv = xmlToken;
        boolean $i$f$requireToken = false;
        if (!Intrinsics.areEqual((Object)Reflection.getOrCreateKotlinClass(token$iv.getClass()), (Object)Reflection.getOrCreateKotlinClass(XmlToken.EndElement.class))) {
            throw new DeserializationException("expected " + Reflection.getOrCreateKotlinClass(XmlToken.EndElement.class) + "; found " + Reflection.getOrCreateKotlinClass(token$iv.getClass()) + " (" + token$iv + ')');
        }
        XmlToken cfr_ignored_0 = (XmlToken.EndElement)token$iv;
        return null;
    }

    private final boolean inNestedMode() {
        boolean bl;
        boolean bl2 = this.reentryFlag;
        if (bl2) {
            bl = true;
        } else if (!bl2) {
            this.reentryFlag = true;
            bl = false;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return bl;
    }
}

