/*
 * Decompiled with CFR 0.152.
 */
package aws.smithy.kotlin.runtime.serde.xml;

import aws.smithy.kotlin.runtime.serde.DeserializationException;
import aws.smithy.kotlin.runtime.serde.xml.SubTreeReader;
import aws.smithy.kotlin.runtime.serde.xml.TerminalReader;
import aws.smithy.kotlin.runtime.serde.xml.XmlStreamReader;
import aws.smithy.kotlin.runtime.serde.xml.XmlStreamReaderXmlPull;
import aws.smithy.kotlin.runtime.serde.xml.XmlStreamReaderXmlPullKt;
import aws.smithy.kotlin.runtime.serde.xml.XmlToken;
import aws.smithy.kotlin.runtime.serde.xml.XmlTokenKt;
import aws.smithy.kotlin.runtime.util.StackKt;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;
import org.xmlpull.v1.XmlPullParserFactory;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010!\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0000\u0018\u0000 \"2\u00020\u0001:\u0001\"B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u0013\u001a\u00020\nH\u0002J\u0012\u0010\u0014\u001a\u0004\u0018\u00010\b2\u0006\u0010\u0015\u001a\u00020\u0005H\u0002J\n\u0010\u0016\u001a\u0004\u0018\u00010\bH\u0016J\u0012\u0010\u0017\u001a\u0004\u0018\u00010\b2\u0006\u0010\u0015\u001a\u00020\u0005H\u0016J\b\u0010\u0018\u001a\u00020\u0019H\u0016J\u0010\u0010\u001a\u001a\u00020\u00012\u0006\u0010\u001b\u001a\u00020\u001cH\u0016J\b\u0010\u001d\u001a\u00020\u0012H\u0016J\u0019\u0010\u001e\u001a\u00020\u00192\u0006\u0010\u001f\u001a\u00020\b2\u0006\u0010 \u001a\u00020\u0005H\u0082\u0010J\u000e\u0010\f\u001a\u0004\u0018\u00010\b*\u00020\u0003H\u0002J\f\u0010!\u001a\u00020\b*\u00020\u0003H\u0002R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\u00020\n8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\u000bR\u0016\u0010\f\u001a\u0004\u0018\u00010\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\b0\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00120\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Laws/smithy/kotlin/runtime/serde/xml/XmlStreamReaderXmlPull;", "Laws/smithy/kotlin/runtime/serde/xml/XmlStreamReader;", "parser", "Lorg/xmlpull/v1/XmlPullParser;", "minimumDepth", "", "(Lorg/xmlpull/v1/XmlPullParser;I)V", "_lastToken", "Laws/smithy/kotlin/runtime/serde/xml/XmlToken;", "isGeneralParseMode", "", "()Z", "lastToken", "getLastToken", "()Laws/smithy/kotlin/runtime/serde/xml/XmlToken;", "peekStack", "", "subTokenStack", "", "hasNext", "internalPeek", "index", "nextToken", "peek", "skipNext", "", "subTreeReader", "subtreeStartDepth", "Laws/smithy/kotlin/runtime/serde/xml/XmlStreamReader$SubtreeStartDepth;", "toString", "traverseNode", "st", "startDepth", "takeNextValidToken", "Companion", "serde-xml"})
public final class XmlStreamReaderXmlPull
implements XmlStreamReader {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final XmlPullParser parser;
    private final int minimumDepth;
    @NotNull
    private final List<XmlToken> peekStack;
    @Nullable
    private XmlToken _lastToken;
    @NotNull
    private final List<String> subTokenStack;

    public XmlStreamReaderXmlPull(@NotNull XmlPullParser parser, int minimumDepth) {
        Intrinsics.checkNotNullParameter((Object)parser, (String)"parser");
        this.parser = parser;
        this.minimumDepth = minimumDepth;
        Object[] objectArray = new XmlToken[]{this.takeNextValidToken(this.parser)};
        this.peekStack = CollectionsKt.mutableListOf((Object[])objectArray);
        this._lastToken = this.lastToken(this.parser);
        this.subTokenStack = new ArrayList();
    }

    public /* synthetic */ XmlStreamReaderXmlPull(XmlPullParser xmlPullParser, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            n = xmlPullParser.getDepth();
        }
        this(xmlPullParser, n);
    }

    @Override
    @Nullable
    public XmlToken getLastToken() {
        return this._lastToken;
    }

    @Override
    @NotNull
    public XmlStreamReader subTreeReader(@NotNull XmlStreamReader.SubtreeStartDepth subtreeStartDepth) {
        Integer n;
        Intrinsics.checkNotNullParameter((Object)((Object)subtreeStartDepth), (String)"subtreeStartDepth");
        XmlStreamReaderXmlPull currentReader = this;
        XmlToken previousToken = this.getLastToken();
        XmlToken nextToken = this.internalPeek(1);
        if (XmlTokenKt.terminates(nextToken, previousToken)) {
            this._lastToken = this.nextToken();
            return new TerminalReader(currentReader);
        }
        switch (WhenMappings.$EnumSwitchMapping$0[subtreeStartDepth.ordinal()]) {
            case 1: {
                XmlToken xmlToken = this._lastToken;
                if (xmlToken == null) {
                    n = null;
                    break;
                }
                int n2 = xmlToken.getDepth();
                n = n2 + 1;
                break;
            }
            case 2: {
                XmlToken xmlToken = this._lastToken;
                if (xmlToken == null) {
                    n = null;
                    break;
                }
                n = xmlToken.getDepth();
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        Integer n3 = n;
        if (n3 == null) {
            throw new DeserializationException(Intrinsics.stringPlus((String)"Unable to determine last node depth in ", (Object)this));
        }
        int subTreeDepth = n3;
        return new SubTreeReader(this, subtreeStartDepth, subTreeDepth);
    }

    @Override
    @Nullable
    public XmlToken nextToken() {
        XmlToken xmlToken;
        XmlToken xmlToken2;
        if (!this.hasNext()) {
            return null;
        }
        boolean bl = this.peekStack.isEmpty();
        if (bl) {
            xmlToken2 = this.takeNextValidToken(this.parser);
        } else if (!bl) {
            xmlToken2 = this.peekStack.remove(0);
        } else {
            throw new NoWhenBranchMatchedException();
        }
        XmlToken token = xmlToken = xmlToken2;
        boolean bl2 = false;
        this._lastToken = token;
        return xmlToken;
    }

    @Override
    public void skipNext() {
        if (XmlTokenKt.isTerminal$default(this.internalPeek(1), 0, 1, null)) {
            return;
        }
        XmlToken xmlToken = this.nextToken();
        if (xmlToken == null) {
            throw new IllegalStateException("nextToken() unexpectedly returned null".toString());
        }
        this.traverseNode(xmlToken, this.parser.getDepth());
    }

    @Override
    @Nullable
    public XmlToken peek(int index) {
        XmlToken peekState = this.internalPeek(index);
        return XmlTokenKt.isTerminal(peekState, this.minimumDepth) ? null : peekState;
    }

    private final XmlToken internalPeek(int index) {
        while (this.peekStack.size() < index && !Intrinsics.areEqual((Object)this.lastToken(this.parser), (Object)XmlToken.EndDocument.INSTANCE)) {
            StackKt.push(this.peekStack, (Object)this.takeNextValidToken(this.parser));
        }
        return this.peekStack.size() >= index ? this.peekStack.get(index - 1) : null;
    }

    private final boolean hasNext() {
        XmlToken lastToken2 = this.lastToken(this.parser);
        XmlToken xmlToken = this.internalPeek(1);
        if (xmlToken == null) {
            return false;
        }
        XmlToken nextToken = xmlToken;
        return XmlTokenKt.isNotTerminal$default(lastToken2, 0, 1, null) && XmlTokenKt.isNotTerminal(nextToken, this.minimumDepth);
    }

    private final void traverseNode(XmlToken st, int startDepth) {
        XmlStreamReaderXmlPull xmlStreamReaderXmlPull = this;
        XmlToken xmlToken = st;
        int n = startDepth;
        while (true) {
            XmlToken next;
            XmlStreamReaderXmlPull xmlStreamReaderXmlPull2 = xmlStreamReaderXmlPull;
            XmlToken xmlToken2 = xmlToken;
            int n2 = n;
            if (Intrinsics.areEqual((Object)xmlToken2, (Object)XmlToken.EndDocument.INSTANCE)) {
                return;
            }
            if (xmlToken2 instanceof XmlToken.EndElement && xmlStreamReaderXmlPull2.parser.getDepth() == n2) {
                return;
            }
            if (xmlStreamReaderXmlPull2.nextToken() == null) {
                return;
            }
            if (!(xmlStreamReaderXmlPull2.parser.getDepth() >= n2)) {
                boolean bl = false;
                String string = "Traversal depth " + xmlStreamReaderXmlPull2.parser.getDepth() + " exceeded start node depth " + n2;
                throw new IllegalArgumentException(string.toString());
            }
            xmlStreamReaderXmlPull = xmlStreamReaderXmlPull2;
            xmlToken = next;
            n = n2;
        }
    }

    @NotNull
    public String toString() {
        return "XmlStreamReader(last: " + this.getLastToken() + ')';
    }

    private final XmlToken takeNextValidToken(XmlPullParser $this$takeNextValidToken) {
        try {
            do {
                $this$takeNextValidToken.next();
            } while (this.lastToken($this$takeNextValidToken) == null);
            XmlToken xmlToken = this.lastToken($this$takeNextValidToken);
            if (xmlToken == null) {
                throw new DeserializationException((Throwable)new IllegalStateException("Unexpectedly unable to get next token"));
            }
            return xmlToken;
        }
        catch (XmlPullParserException e) {
            throw new DeserializationException((Throwable)e);
        }
    }

    private final boolean isGeneralParseMode() {
        return this.subTokenStack.isEmpty();
    }

    /*
     * WARNING - void declaration
     */
    private final XmlToken lastToken(XmlPullParser $this$lastToken) {
        XmlToken xmlToken;
        switch ($this$lastToken.getEventType()) {
            case 0: {
                xmlToken = null;
                break;
            }
            case 1: {
                xmlToken = XmlToken.EndDocument.INSTANCE;
                break;
            }
            case 2: {
                xmlToken = new XmlToken.BeginElement($this$lastToken.getDepth(), XmlStreamReaderXmlPullKt.access$qualifiedName($this$lastToken), XmlStreamReaderXmlPullKt.access$attributes($this$lastToken), XmlStreamReaderXmlPullKt.access$currDeclaredNamespaces($this$lastToken));
                break;
            }
            case 3: {
                void var3_5;
                if (this.isGeneralParseMode()) {
                    xmlToken = new XmlToken.EndElement($this$lastToken.getDepth(), XmlStreamReaderXmlPullKt.access$qualifiedName(this.parser));
                    break;
                }
                String textValue2 = CollectionsKt.joinToString$default((Iterable)this.subTokenStack, (CharSequence)"", null, null, (int)0, null, (Function1)lastToken.textValue.1.INSTANCE, (int)30, null);
                XmlToken.Text textToken = new XmlToken.Text($this$lastToken.getDepth(), textValue2);
                this.subTokenStack.clear();
                this.peekStack.add(0, textToken);
                xmlToken = (XmlToken)var3_5;
                break;
            }
            case 4: 
            case 5: 
            case 10: {
                XmlToken.Text text;
                CharSequence charSequence = this.parser.getText();
                if (charSequence == null || StringsKt.isBlank((CharSequence)charSequence)) {
                    text = null;
                } else if (this.isGeneralParseMode()) {
                    text = new XmlToken.Text($this$lastToken.getDepth(), $this$lastToken.getText());
                } else {
                    charSequence = this.parser.getText();
                    Intrinsics.checkNotNullExpressionValue((Object)charSequence, (String)"parser.text");
                    StackKt.push(this.subTokenStack, (Object)charSequence);
                    text = null;
                }
                xmlToken = text;
                break;
            }
            case 6: {
                String string = this.parser.getText();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"parser.text");
                if (!StringsKt.isBlank((CharSequence)string)) {
                    string = this.parser.getText();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"parser.text");
                    StackKt.push(this.subTokenStack, (Object)string);
                }
                xmlToken = null;
                break;
            }
            default: {
                xmlToken = null;
            }
        }
        return xmlToken;
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\b\b\u0002\u0010\u0007\u001a\u00020\b\u00a8\u0006\t"}, d2={"Laws/smithy/kotlin/runtime/serde/xml/XmlStreamReaderXmlPull$Companion;", "", "()V", "xmlPullParserFactory", "Lorg/xmlpull/v1/XmlPullParser;", "payload", "", "charset", "Ljava/nio/charset/Charset;", "serde-xml"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final XmlPullParser xmlPullParserFactory(@NotNull byte[] payload, @NotNull Charset charset) {
            Intrinsics.checkNotNullParameter((Object)payload, (String)"payload");
            Intrinsics.checkNotNullParameter((Object)charset, (String)"charset");
            XmlPullParserFactory factory = XmlPullParserFactory.newInstance((String)"org.xmlpull.mxp1.MXParser", null);
            XmlPullParser parser = factory.newPullParser();
            parser.setFeature("http://xmlpull.org/v1/doc/features.html#process-namespaces", true);
            parser.setInput((InputStream)new ByteArrayInputStream(payload), charset.toString());
            Intrinsics.checkNotNullExpressionValue((Object)parser, (String)"parser");
            return parser;
        }

        public static /* synthetic */ XmlPullParser xmlPullParserFactory$default(Companion companion, byte[] byArray, Charset charset, int n, Object object) {
            if ((n & 2) != 0) {
                charset = Charsets.UTF_8;
            }
            return companion.xmlPullParserFactory(byArray, charset);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 6, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[XmlStreamReader.SubtreeStartDepth.values().length];
            nArray[XmlStreamReader.SubtreeStartDepth.CHILD.ordinal()] = 1;
            nArray[XmlStreamReader.SubtreeStartDepth.CURRENT.ordinal()] = 2;
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

