/*
 * Decompiled with CFR 0.152.
 */
package aws.smithy.kotlin.runtime.serde.xml;

import aws.smithy.kotlin.runtime.serde.xml.XmlStreamWriter;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.xmlpull.v1.XmlPullParserFactory;
import org.xmlpull.v1.XmlSerializer;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\r\u0018\u0000 \u001f2\u00020\u0001:\u0001\u001fB\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J$\u0010\r\u001a\u00020\u00012\u0006\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u000f2\b\u0010\u0011\u001a\u0004\u0018\u00010\u000fH\u0016J\b\u0010\u0012\u001a\u00020\u0013H\u0016J\u001a\u0010\u0014\u001a\u00020\u00012\u0006\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0011\u001a\u0004\u0018\u00010\u000fH\u0016J\u001a\u0010\u0015\u001a\u00020\u00132\u0006\u0010\u0016\u001a\u00020\u000f2\b\u0010\u0017\u001a\u0004\u0018\u00010\u000fH\u0016J!\u0010\u0018\u001a\u00020\u00132\b\u0010\u0019\u001a\u0004\u0018\u00010\u000f2\b\u0010\u001a\u001a\u0004\u0018\u00010\u0003H\u0016\u00a2\u0006\u0002\u0010\u001bJ\u001a\u0010\u001c\u001a\u00020\u00012\u0006\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0011\u001a\u0004\u0018\u00010\u000fH\u0016J\u0010\u0010\u001d\u001a\u00020\u00012\u0006\u0010\u001d\u001a\u00020\u000fH\u0016J\b\u0010\u001e\u001a\u00020\u000fH\u0016R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\u00020\n8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Laws/smithy/kotlin/runtime/serde/xml/XmlPullSerializer;", "Laws/smithy/kotlin/runtime/serde/xml/XmlStreamWriter;", "pretty", "", "serializer", "Lorg/xmlpull/v1/XmlSerializer;", "(ZLorg/xmlpull/v1/XmlSerializer;)V", "buffer", "Ljava/io/ByteArrayOutputStream;", "bytes", "", "getBytes", "()[B", "attribute", "name", "", "value", "namespace", "endDocument", "", "endTag", "namespacePrefix", "uri", "prefix", "startDocument", "encoding", "standalone", "(Ljava/lang/String;Ljava/lang/Boolean;)V", "startTag", "text", "toString", "Companion", "serde-xml"})
public final class XmlPullSerializer
implements XmlStreamWriter {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final XmlSerializer serializer;
    @NotNull
    private final ByteArrayOutputStream buffer;

    public XmlPullSerializer(boolean pretty, @NotNull XmlSerializer serializer) {
        Intrinsics.checkNotNullParameter((Object)serializer, (String)"serializer");
        this.serializer = serializer;
        this.buffer = new ByteArrayOutputStream();
        this.serializer.setOutput((OutputStream)this.buffer, StandardCharsets.UTF_8.name());
        if (pretty) {
            this.serializer.setProperty("http://xmlpull.org/v1/doc/properties.html#serializer-indentation", (Object)StringsKt.repeat((CharSequence)" ", (int)4));
            this.serializer.setProperty("http://xmlpull.org/v1/doc/properties.html#serializer-line-separator", (Object)"\n");
        } else {
            this.serializer.setProperty("http://xmlpull.org/v1/doc/properties.html#serializer-indentation", null);
            this.serializer.setProperty("http://xmlpull.org/v1/doc/properties.html#serializer-line-separator", null);
        }
    }

    public /* synthetic */ XmlPullSerializer(boolean bl, XmlSerializer xmlSerializer, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            xmlSerializer = XmlPullSerializer.Companion.xmlSerializerFactory();
        }
        this(bl, xmlSerializer);
    }

    @Override
    public void startDocument(@Nullable String encoding, @Nullable Boolean standalone) {
        this.serializer.startDocument(encoding, standalone);
    }

    @Override
    public void endDocument() {
        this.serializer.endDocument();
    }

    @Override
    @NotNull
    public XmlStreamWriter startTag(@NotNull String name, @Nullable String namespace) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        this.serializer.startTag(namespace, name);
        return this;
    }

    @Override
    @NotNull
    public XmlStreamWriter attribute(@NotNull String name, @Nullable String value, @Nullable String namespace) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        this.serializer.attribute(namespace, name, value);
        return this;
    }

    @Override
    @NotNull
    public XmlStreamWriter endTag(@NotNull String name, @Nullable String namespace) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        this.serializer.endTag(namespace, name);
        return this;
    }

    @Override
    @NotNull
    public XmlStreamWriter text(@NotNull String text) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        CharSequence $this$forEach$iv = text;
        boolean $i$f$forEach = false;
        CharSequence charSequence = $this$forEach$iv;
        for (int i = 0; i < charSequence.length(); ++i) {
            char element$iv = charSequence.charAt(i);
            char character = element$iv;
            boolean bl = false;
            char c = character;
            if (c == '\n') {
                this.serializer.entityRef("#xA");
                continue;
            }
            if (c == '\r') {
                this.serializer.entityRef("#xD");
                continue;
            }
            if (c == '\u0085') {
                this.serializer.entityRef("#x85");
                continue;
            }
            if (c == '\u2028') {
                this.serializer.entityRef("#x2028");
                continue;
            }
            this.serializer.text(String.valueOf(character));
        }
        return this;
    }

    @Override
    public void namespacePrefix(@NotNull String uri, @Nullable String prefix) {
        Intrinsics.checkNotNullParameter((Object)uri, (String)"uri");
        String string = prefix;
        if (string == null) {
            string = "";
        }
        this.serializer.setPrefix(string, uri);
    }

    @NotNull
    public String toString() {
        return new String(this.getBytes(), Charsets.UTF_8);
    }

    @Override
    @NotNull
    public byte[] getBytes() {
        this.serializer.endDocument();
        this.serializer.flush();
        byte[] byArray = this.buffer.toByteArray();
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"buffer.toByteArray()");
        return byArray;
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0002\u00a8\u0006\u0005"}, d2={"Laws/smithy/kotlin/runtime/serde/xml/XmlPullSerializer$Companion;", "", "()V", "xmlSerializerFactory", "Lorg/xmlpull/v1/XmlSerializer;", "serde-xml"})
    public static final class Companion {
        private Companion() {
        }

        private final XmlSerializer xmlSerializerFactory() {
            XmlPullParserFactory factory = XmlPullParserFactory.newInstance((String)"org.xmlpull.mxp1_serializer.MXSerializer", null);
            XmlSerializer xmlSerializer = factory.newSerializer();
            Intrinsics.checkNotNullExpressionValue((Object)xmlSerializer, (String)"factory.newSerializer()");
            return xmlSerializer;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

