/*
 * Decompiled with CFR 0.152.
 */
package aws.smithy.kotlin.runtime.serde.xml;

import aws.smithy.kotlin.runtime.serde.DeserializationException;
import aws.smithy.kotlin.runtime.serde.PrimitiveDeserializer;
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor;
import aws.smithy.kotlin.runtime.serde.xml.XmlFieldTraitsKt;
import aws.smithy.kotlin.runtime.serde.xml.XmlPrimitiveDeserializer;
import aws.smithy.kotlin.runtime.serde.xml.XmlStreamReader;
import aws.smithy.kotlin.runtime.serde.xml.XmlStreamReaderXmlPullKt;
import aws.smithy.kotlin.runtime.serde.xml.XmlToken;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0005\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0001\n\u0000\n\u0002\u0010\n\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u0017\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006B\u0015\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\tJ\b\u0010\n\u001a\u00020\u000bH\u0016J\b\u0010\f\u001a\u00020\rH\u0016J\b\u0010\u000e\u001a\u00020\u000fH\u0016J\b\u0010\u0010\u001a\u00020\u0011H\u0016J\b\u0010\u0012\u001a\u00020\u0013H\u0016J\b\u0010\u0014\u001a\u00020\u0015H\u0016J\n\u0010\u0016\u001a\u0004\u0018\u00010\u0017H\u0016J\b\u0010\u0018\u001a\u00020\u0019H\u0016J\b\u0010\u001a\u001a\u00020\u001bH\u0016J'\u0010\u001c\u001a\u0002H\u001d\"\u0004\b\u0000\u0010\u001d2\u0012\u0010\u001e\u001a\u000e\u0012\u0004\u0012\u00020\u001b\u0012\u0004\u0012\u0002H\u001d0\u001fH\u0002\u00a2\u0006\u0002\u0010 R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Laws/smithy/kotlin/runtime/serde/xml/XmlPrimitiveDeserializer;", "Laws/smithy/kotlin/runtime/serde/PrimitiveDeserializer;", "input", "", "fieldDescriptor", "Laws/smithy/kotlin/runtime/serde/SdkFieldDescriptor;", "([BLaws/smithy/kotlin/runtime/serde/SdkFieldDescriptor;)V", "reader", "Laws/smithy/kotlin/runtime/serde/xml/XmlStreamReader;", "(Laws/smithy/kotlin/runtime/serde/xml/XmlStreamReader;Laws/smithy/kotlin/runtime/serde/SdkFieldDescriptor;)V", "deserializeBoolean", "", "deserializeByte", "", "deserializeDouble", "", "deserializeFloat", "", "deserializeInt", "", "deserializeLong", "", "deserializeNull", "", "deserializeShort", "", "deserializeString", "", "deserializeValue", "T", "transform", "Lkotlin/Function1;", "(Lkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "serde-xml"})
public final class XmlPrimitiveDeserializer
implements PrimitiveDeserializer {
    @NotNull
    private final XmlStreamReader reader;
    @NotNull
    private final SdkFieldDescriptor fieldDescriptor;

    public XmlPrimitiveDeserializer(@NotNull XmlStreamReader reader, @NotNull SdkFieldDescriptor fieldDescriptor) {
        Intrinsics.checkNotNullParameter((Object)reader, (String)"reader");
        Intrinsics.checkNotNullParameter((Object)fieldDescriptor, (String)"fieldDescriptor");
        this.reader = reader;
        this.fieldDescriptor = fieldDescriptor;
    }

    public XmlPrimitiveDeserializer(@NotNull byte[] input, @NotNull SdkFieldDescriptor fieldDescriptor) {
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        Intrinsics.checkNotNullParameter((Object)fieldDescriptor, (String)"fieldDescriptor");
        this(XmlStreamReaderXmlPullKt.xmlStreamReader(input), fieldDescriptor);
    }

    private final <T> T deserializeValue(Function1<? super String, ? extends T> transform) {
        Object object;
        Object object2;
        boolean $i$f$requireToken;
        XmlToken token$iv;
        boolean $i$f$takeNextAs;
        XmlStreamReader $this$takeNextAs$iv;
        if (XmlStreamReader.DefaultImpls.peek$default(this.reader, 0, 1, null) instanceof XmlToken.BeginElement) {
            $this$takeNextAs$iv = this.reader;
            $i$f$takeNextAs = false;
            XmlToken xmlToken = $this$takeNextAs$iv.nextToken();
            if (xmlToken == null) {
                throw new DeserializationException("Expected " + Reflection.getOrCreateKotlinClass(XmlToken.BeginElement.class) + " but instead found null");
            }
            token$iv = xmlToken;
            $i$f$requireToken = false;
            if (!Intrinsics.areEqual((Object)Reflection.getOrCreateKotlinClass(token$iv.getClass()), (Object)Reflection.getOrCreateKotlinClass(XmlToken.BeginElement.class))) {
                throw new DeserializationException("expected " + Reflection.getOrCreateKotlinClass(XmlToken.BeginElement.class) + "; found " + Reflection.getOrCreateKotlinClass(token$iv.getClass()) + " (" + token$iv + ')');
            }
            XmlToken.BeginElement wrapperToken = (XmlToken.BeginElement)((XmlToken)((XmlToken.BeginElement)token$iv));
            if (!Intrinsics.areEqual((Object)wrapperToken.getName().getLocal(), (Object)XmlFieldTraitsKt.generalName(this.fieldDescriptor))) {
                return this.deserializeValue(transform);
            }
        }
        $this$takeNextAs$iv = this.reader;
        $i$f$takeNextAs = false;
        XmlToken xmlToken = $this$takeNextAs$iv.nextToken();
        if (xmlToken == null) {
            throw new DeserializationException("Expected " + Reflection.getOrCreateKotlinClass(XmlToken.Text.class) + " but instead found null");
        }
        token$iv = xmlToken;
        $i$f$requireToken = false;
        if (!Intrinsics.areEqual((Object)Reflection.getOrCreateKotlinClass(token$iv.getClass()), (Object)Reflection.getOrCreateKotlinClass(XmlToken.Text.class))) {
            throw new DeserializationException("expected " + Reflection.getOrCreateKotlinClass(XmlToken.Text.class) + "; found " + Reflection.getOrCreateKotlinClass(token$iv.getClass()) + " (" + token$iv + ')');
        }
        XmlToken.Text token = (XmlToken.Text)((XmlToken)((XmlToken.Text)token$iv));
        String string = token.getValue();
        if (string == null) {
            object2 = null;
        } else {
            Object it = string;
            boolean bl = false;
            Object object3 = transform.invoke(it);
            if (object3 == null) {
                object2 = null;
            } else {
                Object object4;
                it = object4 = object3;
                boolean bl2 = false;
                XmlStreamReader $this$takeNextAs$iv2 = this.reader;
                boolean $i$f$takeNextAs2 = false;
                XmlToken xmlToken2 = $this$takeNextAs$iv2.nextToken();
                if (xmlToken2 == null) {
                    throw new DeserializationException("Expected " + Reflection.getOrCreateKotlinClass(XmlToken.EndElement.class) + " but instead found null");
                }
                XmlToken token$iv2 = xmlToken2;
                boolean $i$f$requireToken2 = false;
                if (!Intrinsics.areEqual((Object)Reflection.getOrCreateKotlinClass(token$iv2.getClass()), (Object)Reflection.getOrCreateKotlinClass(XmlToken.EndElement.class))) {
                    throw new DeserializationException("expected " + Reflection.getOrCreateKotlinClass(XmlToken.EndElement.class) + "; found " + Reflection.getOrCreateKotlinClass(token$iv2.getClass()) + " (" + token$iv2 + ')');
                }
                XmlToken cfr_ignored_0 = (XmlToken.EndElement)token$iv2;
                object2 = object = object4;
            }
        }
        if (object == null) {
            throw new DeserializationException(token + " specifies nonexistent or invalid value.");
        }
        return (T)object;
    }

    public byte deserializeByte() {
        return ((Number)this.deserializeValue(deserializeByte.1.INSTANCE)).byteValue();
    }

    public int deserializeInt() {
        return ((Number)this.deserializeValue(deserializeInt.1.INSTANCE)).intValue();
    }

    public short deserializeShort() {
        return ((Number)this.deserializeValue(deserializeShort.1.INSTANCE)).shortValue();
    }

    public long deserializeLong() {
        return ((Number)this.deserializeValue(deserializeLong.1.INSTANCE)).longValue();
    }

    public float deserializeFloat() {
        return ((Number)this.deserializeValue(deserializeFloat.1.INSTANCE)).floatValue();
    }

    public double deserializeDouble() {
        return ((Number)this.deserializeValue(deserializeDouble.1.INSTANCE)).doubleValue();
    }

    @NotNull
    public String deserializeString() {
        return (String)this.deserializeValue(deserializeString.1.INSTANCE);
    }

    public boolean deserializeBoolean() {
        return (Boolean)this.deserializeValue(deserializeBoolean.1.INSTANCE);
    }

    @Nullable
    public Void deserializeNull() {
        if (this.reader.nextToken() == null) {
            throw new DeserializationException("Unexpected end of stream");
        }
        XmlStreamReader $this$seek_u24default$iv = this.reader;
        boolean $i$f$seek = false;
        XmlToken token$iv = $this$seek_u24default$iv.getLastToken();
        boolean foundMatch$iv = false;
        while (token$iv != null && !foundMatch$iv) {
            boolean bl;
            if (token$iv instanceof XmlToken.EndElement) {
                XmlToken it = token$iv;
                bl = true;
            } else {
                bl = false;
            }
            if (foundMatch$iv = bl) continue;
            token$iv = $this$seek_u24default$iv.nextToken();
        }
        XmlToken cfr_ignored_0 = (XmlToken.EndElement)token$iv;
        if (this.reader.nextToken() == null) {
            throw new DeserializationException("Unexpected end of stream");
        }
        return null;
    }
}

