/*
 * Decompiled with CFR 0.152.
 */
package aws.smithy.kotlin.runtime.serde.xml;

import aws.smithy.kotlin.runtime.serde.xml.XmlStreamReader;
import aws.smithy.kotlin.runtime.serde.xml.XmlToken;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\n\u0010\f\u001a\u0004\u0018\u00010\tH\u0016J\u0012\u0010\r\u001a\u0004\u0018\u00010\t2\u0006\u0010\u000e\u001a\u00020\u0006H\u0016J\b\u0010\u000f\u001a\u00020\u0010H\u0016J\u0010\u0010\u0011\u001a\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u0004H\u0016J\b\u0010\u0012\u001a\u00020\u0013H\u0016R\u000e\u0010\u0002\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\b\u001a\u0004\u0018\u00010\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Laws/smithy/kotlin/runtime/serde/xml/SubTreeReader;", "Laws/smithy/kotlin/runtime/serde/xml/XmlStreamReader;", "currentReader", "subtreeStartDepth", "Laws/smithy/kotlin/runtime/serde/xml/XmlStreamReader$SubtreeStartDepth;", "minimumDepth", "", "(Laws/smithy/kotlin/runtime/serde/xml/XmlStreamReader;Laws/smithy/kotlin/runtime/serde/xml/XmlStreamReader$SubtreeStartDepth;I)V", "lastToken", "Laws/smithy/kotlin/runtime/serde/xml/XmlToken;", "getLastToken", "()Laws/smithy/kotlin/runtime/serde/xml/XmlToken;", "nextToken", "peek", "index", "skipNext", "", "subTreeReader", "toString", "", "serde-xml"})
final class SubTreeReader
implements XmlStreamReader {
    @NotNull
    private final XmlStreamReader currentReader;
    @NotNull
    private final XmlStreamReader.SubtreeStartDepth subtreeStartDepth;
    private final int minimumDepth;

    public SubTreeReader(@NotNull XmlStreamReader currentReader, @NotNull XmlStreamReader.SubtreeStartDepth subtreeStartDepth, int minimumDepth) {
        Intrinsics.checkNotNullParameter((Object)currentReader, (String)"currentReader");
        Intrinsics.checkNotNullParameter((Object)((Object)subtreeStartDepth), (String)"subtreeStartDepth");
        this.currentReader = currentReader;
        this.subtreeStartDepth = subtreeStartDepth;
        this.minimumDepth = minimumDepth;
    }

    @Override
    @Nullable
    public XmlToken getLastToken() {
        return this.currentReader.getLastToken();
    }

    @Override
    @NotNull
    public XmlStreamReader subTreeReader(@NotNull XmlStreamReader.SubtreeStartDepth subtreeStartDepth) {
        Intrinsics.checkNotNullParameter((Object)((Object)subtreeStartDepth), (String)"subtreeStartDepth");
        return this.currentReader.subTreeReader(subtreeStartDepth);
    }

    @Override
    @Nullable
    public XmlToken nextToken() {
        XmlToken xmlToken = this.currentReader.peek(1);
        if (xmlToken == null) {
            return null;
        }
        XmlToken peekToken = xmlToken;
        if (this.subtreeStartDepth == XmlStreamReader.SubtreeStartDepth.CHILD && peekToken.getDepth() < this.minimumDepth) {
            XmlToken xmlToken2 = this.currentReader.peek(2);
            if (xmlToken2 == null) {
                return null;
            }
            peekToken = xmlToken2;
            if (peekToken.getDepth() >= this.minimumDepth) {
                this.currentReader.nextToken();
            }
        }
        return peekToken.getDepth() >= this.minimumDepth ? this.currentReader.nextToken() : null;
    }

    @Override
    public void skipNext() {
        this.currentReader.skipNext();
    }

    @Override
    @Nullable
    public XmlToken peek(int index) {
        XmlToken xmlToken = this.currentReader.peek(index);
        if (xmlToken == null) {
            return null;
        }
        XmlToken peekToken = xmlToken;
        return peekToken.getDepth() >= this.minimumDepth ? peekToken : null;
    }

    @NotNull
    public String toString() {
        return this.currentReader + " (subTree " + this.minimumDepth + ')';
    }
}

