/*
 * Decompiled with CFR 0.152.
 */
package aws.smithy.kotlin.runtime.serde.json;

import aws.smithy.kotlin.runtime.serde.DeserializationException;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.CharRange;
import kotlin.text.CharsKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=2, xi=48, d1={"\u0000J\n\u0000\n\u0002\u0010\"\n\u0002\u0010\f\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010!\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\u001a\f\u0010\r\u001a\u00020\u000e*\u00020\u000eH\u0002\u001a$\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u000e2\u0006\u0010\u0012\u001a\u00020\u00102\n\u0010\u0013\u001a\u00060\u0014j\u0002`\u0015H\u0002\u001a\f\u0010\u0016\u001a\u00020\u0002*\u00020\u000eH\u0002\u001a\f\u0010\u0017\u001a\u00020\u0018*\u00020\u0002H\u0002\"\u0014\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000*\"\b\u0002\u0010\u0005\"\b\u0012\u0004\u0012\u00020\u0007`\u00062\u0012\u0012\u0004\u0012\u00020\u00070\bj\b\u0012\u0004\u0012\u00020\u0007`\u0006*.\b\u0002\u0010\t\"\u000e\u0012\u0004\u0012\u0002`\u000b\u0012\u0004\u0012\u00020\f0\n2\u0018\u0012\u000e\u0012\f\u0012\u0004\u0012\u00020\u00070\bj\u0002`\u000b\u0012\u0004\u0012\u00020\f0\n\u00a8\u0006\u0019"}, d2={"DIGITS", "", "", "EXP", "PLUS_MINUS", "StateStack", "Laws/smithy/kotlin/runtime/collections/ListStack;", "Laws/smithy/kotlin/runtime/serde/json/LexerState;", "", "StateMutation", "Lkotlin/Function1;", "Laws/smithy/kotlin/runtime/serde/json/StateStack;", "", "unescape", "", "readEscapedUnicode", "", "s", "start", "sb", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "decodeEscapedCodePoint", "isControl", "", "serde-json"})
@SourceDebugExtension(value={"SMAP\nJsonLexer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JsonLexer.kt\naws/smithy/kotlin/runtime/serde/json/JsonLexerKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Strings.kt\nkotlin/text/StringsKt___StringsKt\n*L\n1#1,444:1\n1#2:445\n1069#3,2:446\n*S KotlinDebug\n*F\n+ 1 JsonLexer.kt\naws/smithy/kotlin/runtime/serde/json/JsonLexerKt\n*L\n436#1:446,2\n*E\n"})
public final class JsonLexerKt {
    @NotNull
    private static final Set<Character> DIGITS = CollectionsKt.toSet((Iterable)((Iterable)new CharRange('0', '9')));
    @NotNull
    private static final Set<Character> EXP;
    @NotNull
    private static final Set<Character> PLUS_MINUS;

    private static final String unescape(String $this$unescape) {
        StringBuilder stringBuilder;
        String str = $this$unescape;
        int n = str.length() + 1;
        StringBuilder $this$unescape_u24lambda_u240 = stringBuilder = new StringBuilder(n);
        boolean bl = false;
        int i = 0;
        block11: while (i < str.length()) {
            Comparable<Integer> comparable;
            char chr = str.charAt(i);
            if (chr == '\\') {
                int n2 = ++i;
                ++i;
                char c = str.charAt(n2);
                switch (c) {
                    case 'u': {
                        i += JsonLexerKt.readEscapedUnicode(str, i, $this$unescape_u24lambda_u240);
                        comparable = Unit.INSTANCE;
                        continue block11;
                    }
                    case '\\': {
                        comparable = $this$unescape_u24lambda_u240.append('\\');
                        continue block11;
                    }
                    case '/': {
                        comparable = $this$unescape_u24lambda_u240.append('/');
                        continue block11;
                    }
                    case '\"': {
                        comparable = $this$unescape_u24lambda_u240.append('\"');
                        continue block11;
                    }
                    case 'b': {
                        comparable = $this$unescape_u24lambda_u240.append('\b');
                        continue block11;
                    }
                    case 'f': {
                        comparable = $this$unescape_u24lambda_u240.append('\f');
                        continue block11;
                    }
                    case 'r': {
                        comparable = $this$unescape_u24lambda_u240.append('\r');
                        continue block11;
                    }
                    case 'n': {
                        comparable = $this$unescape_u24lambda_u240.append('\n');
                        continue block11;
                    }
                    case 't': {
                        comparable = $this$unescape_u24lambda_u240.append('\t');
                        continue block11;
                    }
                    default: {
                        throw new DeserializationException("Invalid escape character: `" + c + '`');
                    }
                }
            }
            $this$unescape_u24lambda_u240.append(chr);
            comparable = i++;
        }
        return stringBuilder.toString();
    }

    private static final int readEscapedUnicode(String s, int start, StringBuilder sb) {
        Comparable<StringBuilder> comparable;
        if (!(start + 4 <= s.length())) {
            boolean $i$a$-check-JsonLexerKt$readEscapedUnicode$42 = false;
            String $i$a$-check-JsonLexerKt$readEscapedUnicode$42 = "Unexpected EOF reading escaped high surrogate";
            throw new IllegalStateException($i$a$-check-JsonLexerKt$readEscapedUnicode$42.toString());
        }
        String string = s.substring(start, start + 4);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
        char high = JsonLexerKt.decodeEscapedCodePoint(string);
        int consumed = 4;
        if (Character.isHighSurrogate(high)) {
            int lowStart = start + consumed;
            String string2 = s.substring(lowStart, lowStart + 6);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
            String escapedLow = string2;
            if (!StringsKt.startsWith$default((String)escapedLow, (String)"\\u", (boolean)false, (int)2, null)) {
                boolean bl = false;
                String string3 = "Expected surrogate pair, found `" + escapedLow + '`';
                throw new IllegalStateException(string3.toString());
            }
            String string4 = escapedLow.substring(2);
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"substring(...)");
            char low = JsonLexerKt.decodeEscapedCodePoint(string4);
            if (!Character.isLowSurrogate(low)) {
                boolean bl = false;
                String string5 = "Invalid surrogate pair: (" + high + ", " + low + ')';
                throw new IllegalStateException(string5.toString());
            }
            Object[] objectArray = new Object[]{Character.valueOf(high), Character.valueOf(low)};
            StringsKt.append((StringBuilder)sb, (Object[])objectArray);
            comparable = consumed += 6;
        } else {
            comparable = sb.append(high);
        }
        return consumed;
    }

    /*
     * Unable to fully structure code
     */
    private static final char decodeEscapedCodePoint(String $this$decodeEscapedCodePoint) {
        block4: {
            $this$all$iv = $this$decodeEscapedCodePoint;
            $i$f$all = false;
            for (var3_4 = 0; var3_4 < $this$all$iv.length(); ++var3_4) {
                it = element$iv = $this$all$iv.charAt(var3_4);
                $i$a$-all-JsonLexerKt$decodeEscapedCodePoint$1 = false;
                if ('0' <= it ? it < ':' : false) ** GOTO lbl-1000
                if ('a' <= it ? it < 'g' : false) ** GOTO lbl-1000
                v0 = 'A' <= it ? it < 'G' : false;
                if (v0) lbl-1000:
                // 3 sources

                {
                    v1 = true;
                } else {
                    v1 = false;
                }
                if (v1) continue;
                v2 = false;
                break block4;
            }
            v2 = true;
        }
        if (!v2) {
            $i$a$-check-JsonLexerKt$decodeEscapedCodePoint$2 = false;
            var2_3 = "Invalid unicode escape: `\\u" + $this$decodeEscapedCodePoint + '`';
            throw new IllegalStateException(var2_3.toString());
        }
        return (char)Integer.parseInt($this$decodeEscapedCodePoint, CharsKt.checkRadix((int)16));
    }

    private static final boolean isControl(char $this$isControl) {
        char c = $this$isControl;
        return '\u0000' <= c ? c < ' ' : false;
    }

    public static final /* synthetic */ Set access$getDIGITS$p() {
        return DIGITS;
    }

    public static final /* synthetic */ boolean access$isControl(char $receiver) {
        return JsonLexerKt.isControl($receiver);
    }

    public static final /* synthetic */ String access$unescape(String $receiver) {
        return JsonLexerKt.unescape($receiver);
    }

    public static final /* synthetic */ Set access$getEXP$p() {
        return EXP;
    }

    public static final /* synthetic */ Set access$getPLUS_MINUS$p() {
        return PLUS_MINUS;
    }

    static {
        Object[] objectArray = new Character[]{Character.valueOf('e'), Character.valueOf('E')};
        EXP = SetsKt.setOf((Object[])objectArray);
        objectArray = new Character[]{Character.valueOf('-'), Character.valueOf('+')};
        PLUS_MINUS = SetsKt.setOf((Object[])objectArray);
    }
}

