/*
 * Decompiled with CFR 0.152.
 */
package aws.smithy.kotlin.runtime.serde.json;

import aws.smithy.kotlin.runtime.serde.ListSerializer;
import aws.smithy.kotlin.runtime.serde.MapSerializer;
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor;
import aws.smithy.kotlin.runtime.serde.SdkSerializable;
import aws.smithy.kotlin.runtime.serde.SerializationException;
import aws.smithy.kotlin.runtime.serde.Serializer;
import aws.smithy.kotlin.runtime.serde.StructSerializer;
import aws.smithy.kotlin.runtime.serde.json.JsonFieldTraitsKt;
import aws.smithy.kotlin.runtime.serde.json.JsonStreamWriter;
import aws.smithy.kotlin.runtime.serde.json.JsonStreamWriterKt;
import aws.smithy.kotlin.runtime.time.Instant;
import aws.smithy.kotlin.runtime.time.TimestampFormat;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u008a\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0005\n\u0000\n\u0002\u0010\f\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\n\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0013\n\u0002\u0010\u0012\n\u0002\b\u0002\u0018\u0000 C2\u00020\u00012\u00020\u00022\u00020\u00032\u00020\u0004:\u0001CB\u0005\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\b\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\nH\u0016J\u0010\u0010\u000b\u001a\u00020\u00032\u0006\u0010\t\u001a\u00020\nH\u0016J\u0010\u0010\f\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\nH\u0016J\b\u0010\r\u001a\u00020\u000eH\u0016J\b\u0010\u000f\u001a\u00020\u000eH\u0016J\b\u0010\u0010\u001a\u00020\u000eH\u0016J\u001a\u0010\u0011\u001a\u00020\u000e2\u0006\u0010\u0012\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u0015H\u0016J\"\u0010\u0011\u001a\u00020\u000e2\u0006\u0010\u0012\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J\u001f\u0010\u0011\u001a\u00020\u000e2\u0006\u0010\u0012\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u0019H\u0016\u00a2\u0006\u0002\u0010\u001aJ\u001f\u0010\u0011\u001a\u00020\u000e2\u0006\u0010\u0012\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u001bH\u0016\u00a2\u0006\u0002\u0010\u001cJ\u001f\u0010\u0011\u001a\u00020\u000e2\u0006\u0010\u0012\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u001dH\u0016\u00a2\u0006\u0002\u0010\u001eJ\u001f\u0010\u0011\u001a\u00020\u000e2\u0006\u0010\u0012\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u001fH\u0016\u00a2\u0006\u0002\u0010 J\u001f\u0010\u0011\u001a\u00020\u000e2\u0006\u0010\u0012\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010!H\u0016\u00a2\u0006\u0002\u0010\"J\u001f\u0010\u0011\u001a\u00020\u000e2\u0006\u0010\u0012\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010#H\u0016\u00a2\u0006\u0002\u0010$J\u001f\u0010\u0011\u001a\u00020\u000e2\u0006\u0010\u0012\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010%H\u0016\u00a2\u0006\u0002\u0010&J\u001f\u0010\u0011\u001a\u00020\u000e2\u0006\u0010\u0012\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010'H\u0016\u00a2\u0006\u0002\u0010(J\u001a\u0010\u0011\u001a\u00020\u000e2\u0006\u0010\u0012\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u0013H\u0016J\u0018\u0010)\u001a\u00020\u000e2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J \u0010)\u001a\u00020\u000e2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0014\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J\u0018\u0010)\u001a\u00020\u000e2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0014\u001a\u00020\u0019H\u0016J\u0018\u0010)\u001a\u00020\u000e2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0014\u001a\u00020\u001bH\u0016J\u0018\u0010)\u001a\u00020\u000e2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0014\u001a\u00020\u001dH\u0016J\u0018\u0010)\u001a\u00020\u000e2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0014\u001a\u00020\u001fH\u0016J\u0018\u0010)\u001a\u00020\u000e2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0014\u001a\u00020!H\u0016J\u0018\u0010)\u001a\u00020\u000e2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0014\u001a\u00020#H\u0016J\u0018\u0010)\u001a\u00020\u000e2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0014\u001a\u00020%H\u0016J\u0018\u0010)\u001a\u00020\u000e2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0014\u001a\u00020'H\u0016J\u0018\u0010)\u001a\u00020\u000e2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0014\u001a\u00020\u0013H\u0016J1\u0010*\u001a\u00020\u000e2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010+\u001a\u00020\n2\u0017\u0010,\u001a\u0013\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u000e0-\u00a2\u0006\u0002\b.H\u0016J)\u0010/\u001a\u00020\u000e2\u0006\u0010\t\u001a\u00020\n2\u0017\u0010,\u001a\u0013\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u000e0-\u00a2\u0006\u0002\b.H\u0016J1\u00100\u001a\u00020\u000e2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u00101\u001a\u00020\n2\u0017\u0010,\u001a\u0013\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u000e0-\u00a2\u0006\u0002\b.H\u0016J)\u00102\u001a\u00020\u000e2\u0006\u0010\t\u001a\u00020\n2\u0017\u0010,\u001a\u0013\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u000e0-\u00a2\u0006\u0002\b.H\u0016J\u0010\u00103\u001a\u00020\u000e2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0010\u00104\u001a\u00020\u000e2\u0006\u0010\u0014\u001a\u00020\u0019H\u0016J\u0010\u00105\u001a\u00020\u000e2\u0006\u0010\u0014\u001a\u00020\u001bH\u0016J\u0010\u00106\u001a\u00020\u000e2\u0006\u0010\u0014\u001a\u00020\u001dH\u0016J\u0010\u00107\u001a\u00020\u000e2\u0006\u0010\u0014\u001a\u00020\u001fH\u0016J\u0010\u00108\u001a\u00020\u000e2\u0006\u0010\u0014\u001a\u00020!H\u0016J\u0018\u00109\u001a\u00020\u000e2\u0006\u0010\u0014\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J\u0010\u0010:\u001a\u00020\u000e2\u0006\u0010\u0014\u001a\u00020#H\u0016J\u0010\u0010;\u001a\u00020\u000e2\u0006\u0010\u0014\u001a\u00020%H\u0016J\b\u0010<\u001a\u00020\u000eH\u0016J\u0010\u0010=\u001a\u00020\u000e2\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u0010\u0010>\u001a\u00020\u000e2\u0006\u0010\u0014\u001a\u00020'H\u0016J\u0010\u0010?\u001a\u00020\u000e2\u0006\u0010\u0014\u001a\u00020\u0013H\u0016J)\u0010@\u001a\u00020\u000e2\u0006\u0010\t\u001a\u00020\n2\u0017\u0010,\u001a\u0013\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u000e0-\u00a2\u0006\u0002\b.H\u0016J\b\u0010A\u001a\u00020BH\u0016R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006D"}, d2={"Laws/smithy/kotlin/runtime/serde/json/JsonSerializer;", "Laws/smithy/kotlin/runtime/serde/Serializer;", "Laws/smithy/kotlin/runtime/serde/ListSerializer;", "Laws/smithy/kotlin/runtime/serde/MapSerializer;", "Laws/smithy/kotlin/runtime/serde/StructSerializer;", "()V", "jsonWriter", "Laws/smithy/kotlin/runtime/serde/json/JsonStreamWriter;", "beginList", "descriptor", "Laws/smithy/kotlin/runtime/serde/SdkFieldDescriptor;", "beginMap", "beginStruct", "endList", "", "endMap", "endStruct", "entry", "key", "", "value", "Laws/smithy/kotlin/runtime/serde/SdkSerializable;", "Laws/smithy/kotlin/runtime/time/Instant;", "format", "Laws/smithy/kotlin/runtime/time/TimestampFormat;", "", "(Ljava/lang/String;Ljava/lang/Boolean;)V", "", "(Ljava/lang/String;Ljava/lang/Byte;)V", "", "(Ljava/lang/String;Ljava/lang/Character;)V", "", "(Ljava/lang/String;Ljava/lang/Double;)V", "", "(Ljava/lang/String;Ljava/lang/Float;)V", "", "(Ljava/lang/String;Ljava/lang/Integer;)V", "", "(Ljava/lang/String;Ljava/lang/Long;)V", "", "(Ljava/lang/String;Ljava/lang/Short;)V", "field", "listEntry", "listDescriptor", "block", "Lkotlin/Function1;", "Lkotlin/ExtensionFunctionType;", "listField", "mapEntry", "mapDescriptor", "mapField", "nullField", "serializeBoolean", "serializeByte", "serializeChar", "serializeDouble", "serializeFloat", "serializeInstant", "serializeInt", "serializeLong", "serializeNull", "serializeSdkSerializable", "serializeShort", "serializeString", "structField", "toByteArray", "", "Companion", "serde-json"})
public final class JsonSerializer
implements Serializer,
ListSerializer,
MapSerializer,
StructSerializer {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final JsonStreamWriter jsonWriter = JsonStreamWriterKt.jsonStreamWriter$default(false, 1, null);
    @NotNull
    private static final Set<Double> doublesToStringify;
    @NotNull
    private static final Set<Float> floatsToStringify;

    @NotNull
    public byte[] toByteArray() {
        byte[] byArray = this.jsonWriter.getBytes();
        if (byArray == null) {
            throw new SerializationException("Serializer payload is empty");
        }
        return byArray;
    }

    @NotNull
    public StructSerializer beginStruct(@NotNull SdkFieldDescriptor descriptor) {
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        this.jsonWriter.beginObject();
        return this;
    }

    @NotNull
    public ListSerializer beginList(@NotNull SdkFieldDescriptor descriptor) {
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        this.jsonWriter.beginArray();
        return this;
    }

    @NotNull
    public MapSerializer beginMap(@NotNull SdkFieldDescriptor descriptor) {
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        this.jsonWriter.beginObject();
        return this;
    }

    public void endStruct() {
        this.jsonWriter.endObject();
    }

    public void endList() {
        this.jsonWriter.endArray();
    }

    public void endMap() {
        this.jsonWriter.endObject();
    }

    public void field(@NotNull SdkFieldDescriptor descriptor, @NotNull SdkSerializable value) {
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        this.jsonWriter.writeName(JsonFieldTraitsKt.getSerialName(descriptor));
        value.serialize((Serializer)this);
    }

    public void field(@NotNull SdkFieldDescriptor descriptor, int value) {
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        this.jsonWriter.writeName(JsonFieldTraitsKt.getSerialName(descriptor));
        this.serializeInt(value);
    }

    public void field(@NotNull SdkFieldDescriptor descriptor, long value) {
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        this.jsonWriter.writeName(JsonFieldTraitsKt.getSerialName(descriptor));
        this.serializeLong(value);
    }

    public void field(@NotNull SdkFieldDescriptor descriptor, float value) {
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        this.jsonWriter.writeName(JsonFieldTraitsKt.getSerialName(descriptor));
        this.serializeFloat(value);
    }

    public void field(@NotNull SdkFieldDescriptor descriptor, @NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        this.jsonWriter.writeName(JsonFieldTraitsKt.getSerialName(descriptor));
        this.serializeString(value);
    }

    public void field(@NotNull SdkFieldDescriptor descriptor, double value) {
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        this.jsonWriter.writeName(JsonFieldTraitsKt.getSerialName(descriptor));
        this.serializeDouble(value);
    }

    public void field(@NotNull SdkFieldDescriptor descriptor, boolean value) {
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        this.jsonWriter.writeName(JsonFieldTraitsKt.getSerialName(descriptor));
        this.serializeBoolean(value);
    }

    public void field(@NotNull SdkFieldDescriptor descriptor, byte value) {
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        this.jsonWriter.writeName(JsonFieldTraitsKt.getSerialName(descriptor));
        this.serializeByte(value);
    }

    public void field(@NotNull SdkFieldDescriptor descriptor, short value) {
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        this.jsonWriter.writeName(JsonFieldTraitsKt.getSerialName(descriptor));
        this.serializeShort(value);
    }

    public void field(@NotNull SdkFieldDescriptor descriptor, char value) {
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        this.jsonWriter.writeName(JsonFieldTraitsKt.getSerialName(descriptor));
        this.serializeChar(value);
    }

    public void field(@NotNull SdkFieldDescriptor descriptor, @NotNull Instant value, @NotNull TimestampFormat format) {
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        Intrinsics.checkNotNullParameter((Object)format, (String)"format");
        this.jsonWriter.writeName(JsonFieldTraitsKt.getSerialName(descriptor));
        this.serializeInstant(value, format);
    }

    public void nullField(@NotNull SdkFieldDescriptor descriptor) {
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        this.jsonWriter.writeName(JsonFieldTraitsKt.getSerialName(descriptor));
        this.serializeNull();
    }

    public void structField(@NotNull SdkFieldDescriptor descriptor, @NotNull Function1<? super StructSerializer, Unit> block) {
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        Intrinsics.checkNotNullParameter(block, (String)"block");
        this.jsonWriter.writeName(JsonFieldTraitsKt.getSerialName(descriptor));
        Serializer $this$serializeStruct$iv = this;
        boolean $i$f$serializeStruct = false;
        StructSerializer struct$iv = $this$serializeStruct$iv.beginStruct(descriptor);
        block.invoke((Object)struct$iv);
        struct$iv.endStruct();
    }

    public void listField(@NotNull SdkFieldDescriptor descriptor, @NotNull Function1<? super ListSerializer, Unit> block) {
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        Intrinsics.checkNotNullParameter(block, (String)"block");
        this.jsonWriter.writeName(JsonFieldTraitsKt.getSerialName(descriptor));
        Serializer $this$serializeList$iv = this;
        boolean $i$f$serializeList = false;
        ListSerializer list$iv = $this$serializeList$iv.beginList(descriptor);
        block.invoke((Object)list$iv);
        list$iv.endList();
    }

    public void mapField(@NotNull SdkFieldDescriptor descriptor, @NotNull Function1<? super MapSerializer, Unit> block) {
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        Intrinsics.checkNotNullParameter(block, (String)"block");
        this.jsonWriter.writeName(JsonFieldTraitsKt.getSerialName(descriptor));
        Serializer $this$serializeMap$iv = this;
        boolean $i$f$serializeMap = false;
        MapSerializer map$iv = $this$serializeMap$iv.beginMap(descriptor);
        block.invoke((Object)map$iv);
        map$iv.endMap();
    }

    public void entry(@NotNull String key2, @Nullable Integer value) {
        Intrinsics.checkNotNullParameter((Object)key2, (String)"key");
        this.jsonWriter.writeName(key2);
        if (value != null) {
            this.serializeInt(value);
        } else {
            this.jsonWriter.writeNull();
        }
    }

    public void entry(@NotNull String key2, @Nullable Long value) {
        Intrinsics.checkNotNullParameter((Object)key2, (String)"key");
        this.jsonWriter.writeName(key2);
        if (value != null) {
            this.serializeLong(value);
        } else {
            this.jsonWriter.writeNull();
        }
    }

    public void entry(@NotNull String key2, @Nullable Float value) {
        Intrinsics.checkNotNullParameter((Object)key2, (String)"key");
        this.jsonWriter.writeName(key2);
        if (value != null) {
            this.serializeFloat(value.floatValue());
        } else {
            this.jsonWriter.writeNull();
        }
    }

    public void entry(@NotNull String key2, @Nullable String value) {
        Intrinsics.checkNotNullParameter((Object)key2, (String)"key");
        this.jsonWriter.writeName(key2);
        if (value != null) {
            this.serializeString(value);
        } else {
            this.jsonWriter.writeNull();
        }
    }

    public void entry(@NotNull String key2, @Nullable SdkSerializable value) {
        Unit unit;
        Unit unit2;
        Intrinsics.checkNotNullParameter((Object)key2, (String)"key");
        this.jsonWriter.writeName(key2);
        SdkSerializable sdkSerializable = value;
        if (sdkSerializable == null) {
            unit2 = null;
        } else {
            sdkSerializable.serialize((Serializer)this);
            unit2 = unit = Unit.INSTANCE;
        }
        if (unit == null) {
            this.jsonWriter.writeNull();
        }
    }

    public void entry(@NotNull String key2, @Nullable Double value) {
        Intrinsics.checkNotNullParameter((Object)key2, (String)"key");
        this.jsonWriter.writeName(key2);
        if (value != null) {
            this.serializeDouble(value);
        } else {
            this.jsonWriter.writeNull();
        }
    }

    public void entry(@NotNull String key2, @Nullable Boolean value) {
        Intrinsics.checkNotNullParameter((Object)key2, (String)"key");
        this.jsonWriter.writeName(key2);
        if (value != null) {
            this.serializeBoolean(value);
        } else {
            this.jsonWriter.writeNull();
        }
    }

    public void entry(@NotNull String key2, @Nullable Byte value) {
        Intrinsics.checkNotNullParameter((Object)key2, (String)"key");
        this.jsonWriter.writeName(key2);
        if (value != null) {
            this.serializeByte(value);
        } else {
            this.jsonWriter.writeNull();
        }
    }

    public void entry(@NotNull String key2, @Nullable Short value) {
        Intrinsics.checkNotNullParameter((Object)key2, (String)"key");
        this.jsonWriter.writeName(key2);
        if (value != null) {
            this.serializeShort(value);
        } else {
            this.jsonWriter.writeNull();
        }
    }

    public void entry(@NotNull String key2, @Nullable Character value) {
        Intrinsics.checkNotNullParameter((Object)key2, (String)"key");
        this.jsonWriter.writeName(key2);
        if (value != null) {
            this.serializeChar(value.charValue());
        } else {
            this.jsonWriter.writeNull();
        }
    }

    public void entry(@NotNull String key2, @Nullable Instant value, @NotNull TimestampFormat format) {
        Intrinsics.checkNotNullParameter((Object)key2, (String)"key");
        Intrinsics.checkNotNullParameter((Object)format, (String)"format");
        this.jsonWriter.writeName(key2);
        if (value != null) {
            this.serializeInstant(value, format);
        } else {
            this.jsonWriter.writeNull();
        }
    }

    public void listEntry(@NotNull String key2, @NotNull SdkFieldDescriptor listDescriptor, @NotNull Function1<? super ListSerializer, Unit> block) {
        Intrinsics.checkNotNullParameter((Object)key2, (String)"key");
        Intrinsics.checkNotNullParameter((Object)listDescriptor, (String)"listDescriptor");
        Intrinsics.checkNotNullParameter(block, (String)"block");
        this.jsonWriter.writeName(key2);
        this.beginList(listDescriptor);
        block.invoke((Object)this);
        this.endList();
    }

    public void mapEntry(@NotNull String key2, @NotNull SdkFieldDescriptor mapDescriptor, @NotNull Function1<? super MapSerializer, Unit> block) {
        Intrinsics.checkNotNullParameter((Object)key2, (String)"key");
        Intrinsics.checkNotNullParameter((Object)mapDescriptor, (String)"mapDescriptor");
        Intrinsics.checkNotNullParameter(block, (String)"block");
        this.jsonWriter.writeName(key2);
        this.beginMap(mapDescriptor);
        block.invoke((Object)this);
        this.endMap();
    }

    public void serializeNull() {
        this.jsonWriter.writeNull();
    }

    public void serializeBoolean(boolean value) {
        this.jsonWriter.writeValue(value);
    }

    public void serializeByte(byte value) {
        this.jsonWriter.writeValue(value);
    }

    public void serializeShort(short value) {
        this.jsonWriter.writeValue(value);
    }

    public void serializeChar(char value) {
        this.jsonWriter.writeValue(String.valueOf(value));
    }

    public void serializeInt(int value) {
        this.jsonWriter.writeValue(value);
    }

    public void serializeLong(long value) {
        this.jsonWriter.writeValue(value);
    }

    public void serializeFloat(float value) {
        if (floatsToStringify.contains(Float.valueOf(value))) {
            this.jsonWriter.writeValue(String.valueOf(value));
        } else {
            this.jsonWriter.writeValue(value);
        }
    }

    public void serializeDouble(double value) {
        if (doublesToStringify.contains(value)) {
            this.jsonWriter.writeValue(String.valueOf(value));
        } else {
            this.jsonWriter.writeValue(value);
        }
    }

    public void serializeString(@NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        this.jsonWriter.writeValue(value);
    }

    public void serializeSdkSerializable(@NotNull SdkSerializable value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        value.serialize((Serializer)this);
    }

    public void serializeInstant(@NotNull Instant value, @NotNull TimestampFormat format) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        Intrinsics.checkNotNullParameter((Object)format, (String)"format");
        TimestampFormat timestampFormat = format;
        int n = WhenMappings.$EnumSwitchMapping$0[timestampFormat.ordinal()];
        switch (n) {
            case 1: {
                this.jsonWriter.writeRawValue(value.format(format));
                break;
            }
            case 2: 
            case 3: {
                this.jsonWriter.writeValue(value.format(format));
            }
        }
    }

    static {
        Object[] objectArray = new Double[]{Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY, Double.NaN};
        doublesToStringify = SetsKt.setOf((Object[])objectArray);
        objectArray = new Float[]{Float.valueOf(Float.NEGATIVE_INFINITY), Float.valueOf(Float.POSITIVE_INFINITY), Float.valueOf(Float.NaN)};
        floatsToStringify = SetsKt.setOf((Object[])objectArray);
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\u0007\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00070\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Laws/smithy/kotlin/runtime/serde/json/JsonSerializer$Companion;", "", "()V", "doublesToStringify", "", "", "floatsToStringify", "", "serde-json"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 5, 1}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[TimestampFormat.values().length];
            nArray[TimestampFormat.EPOCH_SECONDS.ordinal()] = 1;
            nArray[TimestampFormat.ISO_8601.ordinal()] = 2;
            nArray[TimestampFormat.RFC_5322.ordinal()] = 3;
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

