/*
 * Decompiled with CFR 0.152.
 */
package aws.smithy.kotlin.runtime.serde.json;

import aws.smithy.kotlin.runtime.serde.json.JsonEncoderKt;
import aws.smithy.kotlin.runtime.serde.json.JsonStreamWriter;
import aws.smithy.kotlin.runtime.serde.json.LexerState;
import aws.smithy.kotlin.runtime.util.StackKt;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u000f\n\u0002\u0010\u0004\n\u0002\b\u0003\n\u0002\u0010\u0005\n\u0002\u0010\u0006\n\u0002\u0010\u0007\n\u0002\u0010\t\n\u0002\u0010\n\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0012\u001a\u00020\u0013H\u0016J\b\u0010\u0014\u001a\u00020\u0013H\u0016J)\u0010\u0015\u001a\u00020\u00132\u0006\u0010\u0016\u001a\u00020\u00172\u0012\u0010\u0018\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00100\u0019\"\u00020\u0010H\u0002\u00a2\u0006\u0002\u0010\u001aJ\u0010\u0010\u001b\u001a\u00020\u00132\u0006\u0010\u001c\u001a\u00020\u0017H\u0002J\b\u0010\u001d\u001a\u00020\u0013H\u0016J\b\u0010\u001e\u001a\u00020\u0013H\u0016J\u0018\u0010\u001f\u001a\u00020\u00132\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010 \u001a\u00020\u0010H\u0002J\b\u0010!\u001a\u00020\u0013H\u0002J\b\u0010\"\u001a\u00020\u0013H\u0002J\b\u0010#\u001a\u00020\u0013H\u0002J\u0010\u0010$\u001a\u00020\u00132\u0006\u0010%\u001a\u00020\u0017H\u0016J\b\u0010&\u001a\u00020\u0013H\u0002J\b\u0010'\u001a\u00020\u0013H\u0016J\u0010\u0010(\u001a\u00020\u00132\u0006\u0010\u001c\u001a\u00020)H\u0002J\u0010\u0010*\u001a\u00020\u00132\u0006\u0010\u001c\u001a\u00020\u0017H\u0016J\u0010\u0010+\u001a\u00020\u00132\u0006\u0010,\u001a\u00020\u0003H\u0016J\u0010\u0010+\u001a\u00020\u00132\u0006\u0010\u001c\u001a\u00020-H\u0016J\u0010\u0010+\u001a\u00020\u00132\u0006\u0010\u001c\u001a\u00020.H\u0016J\u0010\u0010+\u001a\u00020\u00132\u0006\u0010\u001c\u001a\u00020/H\u0016J\u0010\u0010+\u001a\u00020\u00132\u0006\u0010\u001c\u001a\u00020\rH\u0016J\u0010\u0010+\u001a\u00020\u00132\u0006\u0010\u001c\u001a\u000200H\u0016J\u0010\u0010+\u001a\u00020\u00132\u0006\u0010\u001c\u001a\u000201H\u0016J\u0010\u0010+\u001a\u00020\u00132\u0006\u0010\u001c\u001a\u00020\u0017H\u0016J\u0018\u00102\u001a\u00020\u0013*\u00060\u0006j\u0002`\u00072\u0006\u0010\u001c\u001a\u00020\u0017H\u0002R\u0012\u0010\u0005\u001a\u00060\u0006j\u0002`\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\u00020\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u000e\u0010\f\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u000e\u001a\u0012\u0012\u0004\u0012\u00020\u00100\u000fj\b\u0012\u0004\u0012\u00020\u0010`\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00063"}, d2={"Laws/smithy/kotlin/runtime/serde/json/JsonEncoder;", "Laws/smithy/kotlin/runtime/serde/json/JsonStreamWriter;", "pretty", "", "(Z)V", "buffer", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "bytes", "", "getBytes", "()[B", "depth", "", "state", "", "Laws/smithy/kotlin/runtime/serde/json/LexerState;", "Laws/smithy/kotlin/runtime/util/ListStack;", "beginArray", "", "beginObject", "closeStructure", "token", "", "allowedStates", "", "(Ljava/lang/String;[Laws/smithy/kotlin/runtime/serde/json/LexerState;)V", "encodeValue", "value", "endArray", "endObject", "openStructure", "nextState", "writeColon", "writeComma", "writeIndent", "writeName", "name", "writeNewline", "writeNull", "writeNumber", "", "writeRawValue", "writeValue", "bool", "", "", "", "", "", "appendQuoted", "serde-json"})
public final class JsonEncoder
implements JsonStreamWriter {
    private final boolean pretty;
    @NotNull
    private final StringBuilder buffer;
    @NotNull
    private final List<LexerState> state;
    private int depth;

    public JsonEncoder(boolean pretty) {
        this.pretty = pretty;
        this.buffer = new StringBuilder();
        LexerState[] lexerStateArray = new LexerState[]{LexerState.Initial};
        this.state = CollectionsKt.mutableListOf((Object[])lexerStateArray);
    }

    public /* synthetic */ JsonEncoder(boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            bl = false;
        }
        this(bl);
    }

    @Override
    @NotNull
    public byte[] getBytes() {
        String string = this.buffer.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"buffer.toString()");
        return StringsKt.encodeToByteArray((String)string);
    }

    @Override
    public void beginObject() {
        this.openStructure("{", LexerState.ObjectFirstKeyOrEnd);
    }

    @Override
    public void endObject() {
        LexerState[] lexerStateArray = new LexerState[]{LexerState.ObjectFirstKeyOrEnd, LexerState.ObjectNextKeyOrEnd};
        this.closeStructure("}", lexerStateArray);
    }

    @Override
    public void beginArray() {
        this.openStructure("[", LexerState.ArrayFirstValueOrEnd);
    }

    @Override
    public void endArray() {
        LexerState[] lexerStateArray = new LexerState[]{LexerState.ArrayFirstValueOrEnd, LexerState.ArrayNextValueOrEnd};
        this.closeStructure("]", lexerStateArray);
    }

    private final void openStructure(String token, LexerState nextState) {
        this.encodeValue(token);
        this.writeNewline();
        JsonEncoder jsonEncoder = this;
        int n = jsonEncoder.depth;
        jsonEncoder.depth = n + 1;
        StackKt.push(this.state, (Object)((Object)nextState));
    }

    private final void closeStructure(String token, LexerState ... allowedStates) {
        this.writeNewline();
        JsonEncoder jsonEncoder = this;
        int n = jsonEncoder.depth;
        jsonEncoder.depth = n + -1;
        this.writeIndent();
        this.buffer.append(token);
        LexerState last = (LexerState)((Object)StackKt.pop(this.state));
        n = ArraysKt.contains((Object[])allowedStates, (Object)((Object)last)) ? 1 : 0;
        boolean bl = false;
        boolean bl2 = false;
        if (n == 0) {
            boolean bl3 = false;
            String string = "Invalid JSON encoder state " + (Object)((Object)last) + "; expected one of " + ArraysKt.joinToString$default((Object[])allowedStates, null, null, null, (int)0, null, null, (int)63, null);
            throw (Throwable)new IllegalStateException(string.toString());
        }
    }

    private final void writeIndent() {
        if (this.pretty && this.depth > 0) {
            String indent = StringsKt.repeat((CharSequence)" ", (int)(this.depth * 4));
            this.buffer.append(indent);
        }
    }

    private final void writeNewline() {
        if (this.pretty) {
            this.buffer.append('\n');
        }
    }

    private final void writeComma() {
        this.buffer.append(",");
        this.writeNewline();
    }

    private final void writeColon() {
        this.buffer.append(":");
        if (this.pretty) {
            this.buffer.append(" ");
        }
    }

    private final void encodeValue(String value) {
        LexerState lexerState = (LexerState)((Object)StackKt.top(this.state));
        int n = WhenMappings.$EnumSwitchMapping$0[lexerState.ordinal()];
        switch (n) {
            case 1: {
                StackKt.replaceTop(this.state, (Object)((Object)LexerState.ArrayNextValueOrEnd));
                this.writeIndent();
                break;
            }
            case 2: {
                this.writeComma();
                this.writeIndent();
                break;
            }
            case 3: {
                this.writeColon();
                StackKt.replaceTop(this.state, (Object)((Object)LexerState.ObjectNextKeyOrEnd));
            }
        }
        this.buffer.append(value);
    }

    @Override
    public void writeNull() {
        this.encodeValue("null");
    }

    private final void appendQuoted(StringBuilder $this$appendQuoted, String value) {
        $this$appendQuoted.append("\"");
        $this$appendQuoted.append(value);
        $this$appendQuoted.append("\"");
    }

    @Override
    public void writeName(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        if (StackKt.top(this.state) == LexerState.ObjectNextKeyOrEnd) {
            this.writeComma();
        }
        this.writeIndent();
        this.appendQuoted(this.buffer, JsonEncoderKt.escape(name));
        StackKt.replaceTop(this.state, (Object)((Object)LexerState.ObjectFieldValue));
    }

    @Override
    public void writeValue(@NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        this.encodeValue('\"' + JsonEncoderKt.escape(value) + '\"');
    }

    @Override
    public void writeValue(boolean bool) {
        this.encodeValue(String.valueOf(bool));
    }

    private final void writeNumber(Number value) {
        this.encodeValue(value.toString());
    }

    @Override
    public void writeValue(byte value) {
        this.writeNumber(value);
    }

    @Override
    public void writeValue(long value) {
        this.writeNumber(value);
    }

    @Override
    public void writeValue(short value) {
        this.writeNumber(value);
    }

    @Override
    public void writeValue(int value) {
        this.writeNumber(value);
    }

    @Override
    public void writeValue(float value) {
        this.writeNumber(Float.valueOf(value));
    }

    @Override
    public void writeValue(double value) {
        this.writeNumber(value);
    }

    @Override
    public void writeRawValue(@NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        this.encodeValue(value);
    }

    public JsonEncoder() {
        this(false, 1, null);
    }

    @Metadata(mv={1, 5, 1}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[LexerState.values().length];
            nArray[LexerState.ArrayFirstValueOrEnd.ordinal()] = 1;
            nArray[LexerState.ArrayNextValueOrEnd.ordinal()] = 2;
            nArray[LexerState.ObjectFieldValue.ordinal()] = 3;
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

