/*
 * Decompiled with CFR 0.152.
 */
package aws.smithy.kotlin.runtime.serde.formurl;

import aws.smithy.kotlin.runtime.content.BigDecimal;
import aws.smithy.kotlin.runtime.content.BigInteger;
import aws.smithy.kotlin.runtime.content.Document;
import aws.smithy.kotlin.runtime.io.SdkBuffer;
import aws.smithy.kotlin.runtime.io.SdkBufferedSink;
import aws.smithy.kotlin.runtime.serde.FieldTrait;
import aws.smithy.kotlin.runtime.serde.ListSerializer;
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor;
import aws.smithy.kotlin.runtime.serde.SdkSerializable;
import aws.smithy.kotlin.runtime.serde.SerializationException;
import aws.smithy.kotlin.runtime.serde.Serializer;
import aws.smithy.kotlin.runtime.serde.formurl.FormUrlCollectionName;
import aws.smithy.kotlin.runtime.serde.formurl.FormUrlFlattened;
import aws.smithy.kotlin.runtime.serde.formurl.FormUrlSerializer;
import aws.smithy.kotlin.runtime.serde.formurl.FormUrlSerializerKt;
import aws.smithy.kotlin.runtime.text.encoding.Base64Kt;
import aws.smithy.kotlin.runtime.time.Instant;
import aws.smithy.kotlin.runtime.time.TimestampFormat;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0096\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\f\n\u0000\n\u0002\u0010\u0005\n\u0000\n\u0002\u0010\n\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\u000e\u001a\u00020\u000fH\u0002J!\u0010\u0010\u001a\u00020\u00112\u0017\u0010\u0012\u001a\u0013\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u00110\u0013\u00a2\u0006\u0002\b\u0014H\u0002J\b\u0010\u0015\u001a\u00020\u0011H\u0016J\u0010\u0010\u0016\u001a\u00020\u00112\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J\u0010\u0010\u0019\u001a\u00020\u00112\u0006\u0010\u0017\u001a\u00020\u001aH\u0016J\u0010\u0010\u001b\u001a\u00020\u00112\u0006\u0010\u0017\u001a\u00020\u001cH\u0016J\u0010\u0010\u001d\u001a\u00020\u00112\u0006\u0010\u0017\u001a\u00020\u001eH\u0016J\u0010\u0010\u001f\u001a\u00020\u00112\u0006\u0010\u0017\u001a\u00020\rH\u0016J\u0010\u0010 \u001a\u00020\u00112\u0006\u0010\u0017\u001a\u00020\u000bH\u0016J\u0010\u0010!\u001a\u00020\u00112\u0006\u0010\u0017\u001a\u00020\"H\u0016J\u0010\u0010#\u001a\u00020\u00112\u0006\u0010\u0017\u001a\u00020$H\u0016J\u0010\u0010%\u001a\u00020\u00112\u0006\u0010\u0017\u001a\u00020&H\u0016J\u0010\u0010'\u001a\u00020\u00112\u0006\u0010\u0017\u001a\u00020(H\u0016J\u0010\u0010)\u001a\u00020\u00112\u0006\u0010\u0017\u001a\u00020\u000fH\u0016J\u0018\u0010*\u001a\u00020\u00112\u0006\u0010\u0017\u001a\u00020+2\u0006\u0010,\u001a\u00020-H\u0016J\u0010\u0010.\u001a\u00020\u00112\u0006\u0010\u0017\u001a\u00020/H\u0016J\u0010\u00100\u001a\u00020\u00112\u0006\u0010\u0017\u001a\u000201H\u0016J\b\u00102\u001a\u00020\u0011H\u0016J\u0012\u00103\u001a\u00020\u00112\b\u0010\u0017\u001a\u0004\u0018\u000104H\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u00065"}, d2={"Laws/smithy/kotlin/runtime/serde/formurl/FormUrlListSerializer;", "Laws/smithy/kotlin/runtime/serde/ListSerializer;", "parent", "Laws/smithy/kotlin/runtime/serde/formurl/FormUrlSerializer;", "descriptor", "Laws/smithy/kotlin/runtime/serde/SdkFieldDescriptor;", "<init>", "(Laws/smithy/kotlin/runtime/serde/formurl/FormUrlSerializer;Laws/smithy/kotlin/runtime/serde/SdkFieldDescriptor;)V", "buffer", "Laws/smithy/kotlin/runtime/io/SdkBuffer;", "initialBufferPos", "", "idx", "", "prefix", "", "writePrefixed", "", "block", "Lkotlin/Function1;", "Lkotlin/ExtensionFunctionType;", "endList", "serializeBoolean", "value", "", "serializeChar", "", "serializeByte", "", "serializeShort", "", "serializeInt", "serializeLong", "serializeFloat", "", "serializeDouble", "", "serializeBigInteger", "Laws/smithy/kotlin/runtime/content/BigInteger;", "serializeBigDecimal", "Laws/smithy/kotlin/runtime/content/BigDecimal;", "serializeString", "serializeInstant", "Laws/smithy/kotlin/runtime/time/Instant;", "format", "Laws/smithy/kotlin/runtime/time/TimestampFormat;", "serializeByteArray", "", "serializeSdkSerializable", "Laws/smithy/kotlin/runtime/serde/SdkSerializable;", "serializeNull", "serializeDocument", "Laws/smithy/kotlin/runtime/content/Document;", "serde-form-url"})
@SourceDebugExtension(value={"SMAP\nFormUrlSerializer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FormUrlSerializer.kt\naws/smithy/kotlin/runtime/serde/formurl/FormUrlListSerializer\n+ 2 SdkFieldDescriptor.kt\naws/smithy/kotlin/runtime/serde/SdkFieldDescriptorKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,396:1\n103#2:397\n87#2:401\n89#2:403\n1755#3,3:398\n1#4:402\n*S KotlinDebug\n*F\n+ 1 FormUrlSerializer.kt\naws/smithy/kotlin/runtime/serde/formurl/FormUrlListSerializer\n*L\n207#1:397\n209#1:401\n209#1:403\n207#1:398,3\n209#1:402\n*E\n"})
final class FormUrlListSerializer
implements ListSerializer {
    @NotNull
    private final SdkFieldDescriptor descriptor;
    @NotNull
    private final SdkBuffer buffer;
    private final long initialBufferPos;
    private int idx;

    public FormUrlListSerializer(@NotNull FormUrlSerializer parent, @NotNull SdkFieldDescriptor descriptor) {
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        this.descriptor = descriptor;
        this.buffer = parent.getBuffer();
        this.initialBufferPos = this.buffer.getSize();
    }

    private final String prefix() {
        String string;
        FieldTrait it$iv;
        boolean bl;
        block8: {
            SdkFieldDescriptor $this$hasTrait$iv = this.descriptor;
            boolean $i$f$hasTrait = false;
            Iterable $this$any$iv$iv = $this$hasTrait$iv.getTraits();
            boolean $i$f$any = false;
            if ($this$any$iv$iv instanceof Collection && ((Collection)$this$any$iv$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv$iv : $this$any$iv$iv) {
                    it$iv = (FieldTrait)element$iv$iv;
                    boolean bl2 = false;
                    if (!(it$iv instanceof FormUrlFlattened)) continue;
                    bl = true;
                    break block8;
                }
                bl = false;
            }
        }
        if (bl) {
            string = FormUrlSerializerKt.access$getSerialName(this.descriptor) + '.' + this.idx;
        } else {
            FormUrlCollectionName formUrlCollectionName;
            FieldTrait x$iv;
            FieldTrait fieldTrait;
            Object v2;
            block9: {
                SdkFieldDescriptor $this$findTrait$iv = this.descriptor;
                boolean $i$f$findTrait = false;
                for (Object t : (Iterable)$this$findTrait$iv.getTraits()) {
                    it$iv = (FieldTrait)t;
                    boolean bl3 = false;
                    if (!(it$iv.getClass() == FormUrlCollectionName.class)) continue;
                    v2 = t;
                    break block9;
                }
                v2 = null;
            }
            if (!((fieldTrait = (x$iv = (FieldTrait)v2)) instanceof FormUrlCollectionName)) {
                fieldTrait = null;
            }
            if ((formUrlCollectionName = (FormUrlCollectionName)((FieldTrait)((FormUrlCollectionName)fieldTrait))) == null) {
                formUrlCollectionName = FormUrlCollectionName.Companion.getDefault();
            }
            FormUrlCollectionName memberName = formUrlCollectionName;
            string = FormUrlSerializerKt.access$getSerialName(this.descriptor) + '.' + memberName.getMember() + '.' + this.idx;
        }
        return string;
    }

    private final void writePrefixed(Function1<? super SdkBuffer, Unit> block) {
        int n = this.idx;
        this.idx = n + 1;
        if (this.buffer.getSize() > 0L) {
            SdkBufferedSink.DefaultImpls.writeUtf8$default((SdkBufferedSink)((SdkBufferedSink)this.buffer), (String)"&", (int)0, (int)0, (int)6, null);
        }
        SdkBufferedSink.DefaultImpls.writeUtf8$default((SdkBufferedSink)((SdkBufferedSink)this.buffer), (String)this.prefix(), (int)0, (int)0, (int)6, null);
        SdkBufferedSink.DefaultImpls.writeUtf8$default((SdkBufferedSink)((SdkBufferedSink)this.buffer), (String)"=", (int)0, (int)0, (int)6, null);
        SdkBuffer sdkBuffer = this.buffer;
        block.invoke((Object)sdkBuffer);
    }

    public void endList() {
        if (this.buffer.getSize() == this.initialBufferPos) {
            if (this.buffer.getSize() > 0L) {
                SdkBufferedSink.DefaultImpls.writeUtf8$default((SdkBufferedSink)((SdkBufferedSink)this.buffer), (String)"&", (int)0, (int)0, (int)6, null);
            }
            SdkBufferedSink.DefaultImpls.writeUtf8$default((SdkBufferedSink)((SdkBufferedSink)this.buffer), (String)FormUrlSerializerKt.access$getSerialName(this.descriptor), (int)0, (int)0, (int)6, null);
            SdkBufferedSink.DefaultImpls.writeUtf8$default((SdkBufferedSink)((SdkBufferedSink)this.buffer), (String)"=", (int)0, (int)0, (int)6, null);
        }
    }

    public void serializeBoolean(boolean value) {
        this.writePrefixed((Function1<? super SdkBuffer, Unit>)((Function1)arg_0 -> FormUrlListSerializer.serializeBoolean$lambda$0(value, arg_0)));
    }

    public void serializeChar(char value) {
        this.writePrefixed((Function1<? super SdkBuffer, Unit>)((Function1)arg_0 -> FormUrlListSerializer.serializeChar$lambda$1(value, arg_0)));
    }

    public void serializeByte(byte value) {
        this.writePrefixed((Function1<? super SdkBuffer, Unit>)((Function1)arg_0 -> FormUrlListSerializer.serializeByte$lambda$2(value, arg_0)));
    }

    public void serializeShort(short value) {
        this.writePrefixed((Function1<? super SdkBuffer, Unit>)((Function1)arg_0 -> FormUrlListSerializer.serializeShort$lambda$3(value, arg_0)));
    }

    public void serializeInt(int value) {
        this.writePrefixed((Function1<? super SdkBuffer, Unit>)((Function1)arg_0 -> FormUrlListSerializer.serializeInt$lambda$4(value, arg_0)));
    }

    public void serializeLong(long value) {
        this.writePrefixed((Function1<? super SdkBuffer, Unit>)((Function1)arg_0 -> FormUrlListSerializer.serializeLong$lambda$5(value, arg_0)));
    }

    public void serializeFloat(float value) {
        this.writePrefixed((Function1<? super SdkBuffer, Unit>)((Function1)arg_0 -> FormUrlListSerializer.serializeFloat$lambda$6(value, arg_0)));
    }

    public void serializeDouble(double value) {
        this.writePrefixed((Function1<? super SdkBuffer, Unit>)((Function1)arg_0 -> FormUrlListSerializer.serializeDouble$lambda$7(value, arg_0)));
    }

    public void serializeBigInteger(@NotNull BigInteger value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        this.writePrefixed((Function1<? super SdkBuffer, Unit>)((Function1)arg_0 -> FormUrlListSerializer.serializeBigInteger$lambda$8(value, arg_0)));
    }

    public void serializeBigDecimal(@NotNull BigDecimal value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        this.writePrefixed((Function1<? super SdkBuffer, Unit>)((Function1)arg_0 -> FormUrlListSerializer.serializeBigDecimal$lambda$9(value, arg_0)));
    }

    public void serializeString(@NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        this.writePrefixed((Function1<? super SdkBuffer, Unit>)((Function1)arg_0 -> FormUrlListSerializer.serializeString$lambda$10(value, arg_0)));
    }

    public void serializeInstant(@NotNull Instant value, @NotNull TimestampFormat format) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        Intrinsics.checkNotNullParameter((Object)format, (String)"format");
        this.writePrefixed((Function1<? super SdkBuffer, Unit>)((Function1)arg_0 -> FormUrlListSerializer.serializeInstant$lambda$11(value, format, arg_0)));
    }

    public void serializeByteArray(@NotNull byte[] value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        this.serializeString(Base64Kt.encodeBase64String((byte[])value));
    }

    public void serializeSdkSerializable(@NotNull SdkSerializable value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        int n = this.idx;
        this.idx = n + 1;
        String nestedPrefix = this.prefix() + '.';
        value.serialize((Serializer)new FormUrlSerializer(this.buffer, nestedPrefix));
    }

    public void serializeNull() {
    }

    public void serializeDocument(@Nullable Document value) {
        throw new SerializationException("document values not supported by form-url serializer");
    }

    private static final Unit serializeBoolean$lambda$0(boolean $value, SdkBuffer $this$writePrefixed) {
        Intrinsics.checkNotNullParameter((Object)$this$writePrefixed, (String)"$this$writePrefixed");
        SdkBufferedSink.DefaultImpls.writeUtf8$default((SdkBufferedSink)((SdkBufferedSink)$this$writePrefixed), (String)String.valueOf($value), (int)0, (int)0, (int)6, null);
        return Unit.INSTANCE;
    }

    private static final Unit serializeChar$lambda$1(char $value, SdkBuffer $this$writePrefixed) {
        Intrinsics.checkNotNullParameter((Object)$this$writePrefixed, (String)"$this$writePrefixed");
        SdkBufferedSink.DefaultImpls.writeUtf8$default((SdkBufferedSink)((SdkBufferedSink)$this$writePrefixed), (String)String.valueOf($value), (int)0, (int)0, (int)6, null);
        return Unit.INSTANCE;
    }

    private static final Unit serializeByte$lambda$2(byte $value, SdkBuffer $this$writePrefixed) {
        Intrinsics.checkNotNullParameter((Object)$this$writePrefixed, (String)"$this$writePrefixed");
        FormUrlSerializerKt.access$commonWriteNumber($this$writePrefixed, $value);
        return Unit.INSTANCE;
    }

    private static final Unit serializeShort$lambda$3(short $value, SdkBuffer $this$writePrefixed) {
        Intrinsics.checkNotNullParameter((Object)$this$writePrefixed, (String)"$this$writePrefixed");
        FormUrlSerializerKt.access$commonWriteNumber($this$writePrefixed, $value);
        return Unit.INSTANCE;
    }

    private static final Unit serializeInt$lambda$4(int $value, SdkBuffer $this$writePrefixed) {
        Intrinsics.checkNotNullParameter((Object)$this$writePrefixed, (String)"$this$writePrefixed");
        FormUrlSerializerKt.access$commonWriteNumber($this$writePrefixed, $value);
        return Unit.INSTANCE;
    }

    private static final Unit serializeLong$lambda$5(long $value, SdkBuffer $this$writePrefixed) {
        Intrinsics.checkNotNullParameter((Object)$this$writePrefixed, (String)"$this$writePrefixed");
        FormUrlSerializerKt.access$commonWriteNumber($this$writePrefixed, $value);
        return Unit.INSTANCE;
    }

    private static final Unit serializeFloat$lambda$6(float $value, SdkBuffer $this$writePrefixed) {
        Intrinsics.checkNotNullParameter((Object)$this$writePrefixed, (String)"$this$writePrefixed");
        FormUrlSerializerKt.access$commonWriteNumber($this$writePrefixed, Float.valueOf($value));
        return Unit.INSTANCE;
    }

    private static final Unit serializeDouble$lambda$7(double $value, SdkBuffer $this$writePrefixed) {
        Intrinsics.checkNotNullParameter((Object)$this$writePrefixed, (String)"$this$writePrefixed");
        FormUrlSerializerKt.access$commonWriteNumber($this$writePrefixed, $value);
        return Unit.INSTANCE;
    }

    private static final Unit serializeBigInteger$lambda$8(BigInteger $value, SdkBuffer $this$writePrefixed) {
        Intrinsics.checkNotNullParameter((Object)$value, (String)"$value");
        Intrinsics.checkNotNullParameter((Object)$this$writePrefixed, (String)"$this$writePrefixed");
        FormUrlSerializerKt.access$commonWriteNumber($this$writePrefixed, (Number)$value);
        return Unit.INSTANCE;
    }

    private static final Unit serializeBigDecimal$lambda$9(BigDecimal $value, SdkBuffer $this$writePrefixed) {
        Intrinsics.checkNotNullParameter((Object)$value, (String)"$value");
        Intrinsics.checkNotNullParameter((Object)$this$writePrefixed, (String)"$this$writePrefixed");
        SdkBufferedSink.DefaultImpls.writeUtf8$default((SdkBufferedSink)((SdkBufferedSink)$this$writePrefixed), (String)$value.toPlainString(), (int)0, (int)0, (int)6, null);
        return Unit.INSTANCE;
    }

    private static final Unit serializeString$lambda$10(String $value, SdkBuffer $this$writePrefixed) {
        Intrinsics.checkNotNullParameter((Object)$value, (String)"$value");
        Intrinsics.checkNotNullParameter((Object)$this$writePrefixed, (String)"$this$writePrefixed");
        SdkBufferedSink.DefaultImpls.writeUtf8$default((SdkBufferedSink)((SdkBufferedSink)$this$writePrefixed), (String)FormUrlSerializerKt.access$encode($value), (int)0, (int)0, (int)6, null);
        return Unit.INSTANCE;
    }

    private static final Unit serializeInstant$lambda$11(Instant $value, TimestampFormat $format, SdkBuffer $this$writePrefixed) {
        Intrinsics.checkNotNullParameter((Object)$value, (String)"$value");
        Intrinsics.checkNotNullParameter((Object)$format, (String)"$format");
        Intrinsics.checkNotNullParameter((Object)$this$writePrefixed, (String)"$this$writePrefixed");
        SdkBufferedSink.DefaultImpls.writeUtf8$default((SdkBufferedSink)((SdkBufferedSink)$this$writePrefixed), (String)$value.format($format), (int)0, (int)0, (int)6, null);
        return Unit.INSTANCE;
    }
}

