/*
 * Decompiled with CFR 0.152.
 */
package aws.smithy.kotlin.runtime.serde.cbor.encoding;

import aws.smithy.kotlin.runtime.io.SdkBufferedSink;
import aws.smithy.kotlin.runtime.io.SdkBufferedSource;
import aws.smithy.kotlin.runtime.serde.DeserializationException;
import aws.smithy.kotlin.runtime.serde.cbor.CborUtilsKt;
import aws.smithy.kotlin.runtime.serde.cbor.encoding.BigNum;
import aws.smithy.kotlin.runtime.serde.cbor.encoding.DecimalFraction;
import aws.smithy.kotlin.runtime.serde.cbor.encoding.Major;
import aws.smithy.kotlin.runtime.serde.cbor.encoding.MinorKt;
import aws.smithy.kotlin.runtime.serde.cbor.encoding.NegBigNum;
import aws.smithy.kotlin.runtime.serde.cbor.encoding.TagId;
import aws.smithy.kotlin.runtime.serde.cbor.encoding.Timestamp;
import aws.smithy.kotlin.runtime.serde.cbor.encoding.Value;
import kotlin.Metadata;
import kotlin.ULong;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u0000 \u00102\u00020\u0001:\u0001\u0010B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0001\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016R\u0013\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\n\n\u0002\u0010\t\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0011"}, d2={"Laws/smithy/kotlin/runtime/serde/cbor/encoding/Tag;", "Laws/smithy/kotlin/runtime/serde/cbor/encoding/Value;", "id", "Lkotlin/ULong;", "value", "<init>", "(JLaws/smithy/kotlin/runtime/serde/cbor/encoding/Value;Lkotlin/jvm/internal/DefaultConstructorMarker;)V", "getId-s-VKNKU", "()J", "J", "getValue", "()Laws/smithy/kotlin/runtime/serde/cbor/encoding/Value;", "encode", "", "into", "Laws/smithy/kotlin/runtime/io/SdkBufferedSink;", "Companion", "serde-cbor"})
public final class Tag
implements Value {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final long id;
    @NotNull
    private final Value value;

    private Tag(long id, Value value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        this.id = id;
        this.value = value;
    }

    public final long getId-s-VKNKU() {
        return this.id;
    }

    @NotNull
    public final Value getValue() {
        return this.value;
    }

    @Override
    public void encode(@NotNull SdkBufferedSink into) {
        Intrinsics.checkNotNullParameter((Object)into, (String)"into");
        SdkBufferedSink.DefaultImpls.write$default((SdkBufferedSink)into, (byte[])CborUtilsKt.encodeArgument-2TYgG_w(Major.TAG, this.id), (int)0, (int)0, (int)6, null);
        this.value.encode(into);
    }

    public /* synthetic */ Tag(long id, Value value, DefaultConstructorMarker $constructor_marker) {
        this(id, value);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0080\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007\u00a8\u0006\b"}, d2={"Laws/smithy/kotlin/runtime/serde/cbor/encoding/Tag$Companion;", "", "<init>", "()V", "decode", "Laws/smithy/kotlin/runtime/serde/cbor/encoding/Tag;", "buffer", "Laws/smithy/kotlin/runtime/io/SdkBufferedSource;", "serde-cbor"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Tag decode(@NotNull SdkBufferedSource buffer) {
            Value value;
            long id;
            Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
            long l = id = MinorKt.decodeArgument(buffer);
            if (l == TagId.TIMESTAMP.getValue-s-VKNKU()) {
                value = Timestamp.Companion.decode$serde_cbor(buffer);
            } else if (l == TagId.BIG_NUM.getValue-s-VKNKU()) {
                value = BigNum.Companion.decode$serde_cbor(buffer);
            } else if (l == TagId.NEG_BIG_NUM.getValue-s-VKNKU()) {
                value = NegBigNum.Companion.decode$serde_cbor(buffer);
            } else if (l == TagId.DECIMAL_FRACTION.getValue-s-VKNKU()) {
                value = DecimalFraction.Companion.decode$serde_cbor(buffer);
            } else {
                throw new DeserializationException("Unsupported tag ID " + ULong.toString-impl((long)id));
            }
            Value value2 = value;
            return new Tag(id, value2, null);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

