/*
 * Decompiled with CFR 0.152.
 */
package aws.smithy.kotlin.runtime.serde.cbor.encoding;

import aws.smithy.kotlin.runtime.io.SdkBuffer;
import aws.smithy.kotlin.runtime.io.SdkBufferedSource;
import aws.smithy.kotlin.runtime.io.SdkSource;
import aws.smithy.kotlin.runtime.io.SdkSourceKt;
import aws.smithy.kotlin.runtime.serde.DeserializationException;
import aws.smithy.kotlin.runtime.serde.cbor.CborUtilsKt;
import aws.smithy.kotlin.runtime.serde.cbor.encoding.Minor;
import java.io.Closeable;
import kotlin.ExceptionsKt;
import kotlin.Metadata;
import kotlin.UByte;
import kotlin.ULong;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000\u001a\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u0015\u0010\u0005\u001a\u00020\u00012\u0006\u0010\u0006\u001a\u00020\u0007H\u0000\u00a2\u0006\u0002\u0010\b\u001a\u0015\u0010\t\u001a\u00020\n2\u0006\u0010\u0006\u001a\u00020\u0007H\u0000\u00a2\u0006\u0002\u0010\u000b\"\u0016\u0010\u0000\u001a\u00020\u0001X\u0080D\u00a2\u0006\n\n\u0002\u0010\u0004\u001a\u0004\b\u0002\u0010\u0003\u00a8\u0006\f"}, d2={"MINOR_BYTE_MASK", "Lkotlin/UByte;", "getMINOR_BYTE_MASK", "()B", "B", "peekMinorByte", "buffer", "Laws/smithy/kotlin/runtime/io/SdkBufferedSource;", "(Laws/smithy/kotlin/runtime/io/SdkBufferedSource;)B", "decodeArgument", "Lkotlin/ULong;", "(Laws/smithy/kotlin/runtime/io/SdkBufferedSource;)J", "serde-cbor"})
@SourceDebugExtension(value={"SMAP\nMinor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Minor.kt\naws/smithy/kotlin/runtime/serde/cbor/encoding/MinorKt\n+ 2 Closeable.kt\naws/smithy/kotlin/runtime/io/CloseableKt\n*L\n1#1,62:1\n29#2,4:63\n43#2,4:67\n33#2,9:71\n*S KotlinDebug\n*F\n+ 1 Minor.kt\naws/smithy/kotlin/runtime/serde/cbor/encoding/MinorKt\n*L\n56#1:63,4\n56#1:67,4\n56#1:71,9\n*E\n"})
public final class MinorKt {
    private static final byte MINOR_BYTE_MASK = (byte)31;

    public static final byte getMINOR_BYTE_MASK() {
        return MINOR_BYTE_MASK;
    }

    public static final byte peekMinorByte(@NotNull SdkBufferedSource buffer) {
        Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
        byte by = UByte.constructor-impl((byte)buffer.peek().readByte());
        return UByte.constructor-impl((byte)((byte)(by & MINOR_BYTE_MASK)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final long decodeArgument(@NotNull SdkBufferedSource buffer) {
        byte[] byArray;
        long l;
        Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
        byte minor = UByte.constructor-impl((byte)((byte)(UByte.constructor-impl((byte)buffer.readByte()) & MINOR_BYTE_MASK)));
        if (Intrinsics.compare((int)(minor & 0xFF), (int)(Minor.ARG_1.getValue-w2LRezQ() & 0xFF)) < 0) {
            return ULong.constructor-impl((long)((long)minor & 0xFFL));
        }
        byte by = minor;
        if (by == Minor.ARG_1.getValue-w2LRezQ()) {
            l = 1L;
        } else if (by == Minor.ARG_2.getValue-w2LRezQ()) {
            l = 2L;
        } else if (by == Minor.ARG_4.getValue-w2LRezQ()) {
            l = 4L;
        } else if (by == Minor.ARG_8.getValue-w2LRezQ()) {
            l = 8L;
        } else {
            throw new DeserializationException("Unsupported minor value " + UByte.toString-impl((byte)minor) + ", expected one of " + UByte.toString-impl((byte)Minor.ARG_1.getValue-w2LRezQ()) + ", " + UByte.toString-impl((byte)Minor.ARG_2.getValue-w2LRezQ()) + ", " + UByte.toString-impl((byte)Minor.ARG_4.getValue-w2LRezQ()) + ", " + UByte.toString-impl((byte)Minor.ARG_8.getValue-w2LRezQ()));
        }
        long numBytes = l;
        Closeable $this$use$iv = (Closeable)new SdkBuffer();
        boolean $i$f$use = false;
        boolean closed$iv = false;
        try {
            SdkBuffer it = (SdkBuffer)$this$use$iv;
            boolean bl = false;
            SdkSourceKt.readFully((SdkSource)((SdkSource)buffer), (SdkBuffer)it, (long)numBytes);
            byArray = it.readByteArray();
        }
        catch (Throwable first$iv) {
            try {
                try {
                    closed$iv = true;
                    $this$use$iv.close();
                }
                catch (Throwable second$iv) {
                    ExceptionsKt.addSuppressed((Throwable)first$iv, (Throwable)second$iv);
                }
                throw first$iv;
            }
            catch (Throwable throwable) {
                if (!closed$iv) {
                    $this$use$iv.close();
                }
                throw throwable;
            }
        }
        $this$use$iv.close();
        byte[] bytes = byArray;
        return CborUtilsKt.toULong(bytes);
    }
}

