/*
 * Decompiled with CFR 0.152.
 */
package aws.smithy.kotlin.runtime.serde.cbor.encoding;

import aws.smithy.kotlin.runtime.io.SdkBufferedSink;
import aws.smithy.kotlin.runtime.io.SdkBufferedSource;
import aws.smithy.kotlin.runtime.serde.DeserializationException;
import aws.smithy.kotlin.runtime.serde.cbor.CborUtilsKt;
import aws.smithy.kotlin.runtime.serde.cbor.encoding.Major;
import aws.smithy.kotlin.runtime.serde.cbor.encoding.Minor;
import aws.smithy.kotlin.runtime.serde.cbor.encoding.MinorKt;
import aws.smithy.kotlin.runtime.serde.cbor.encoding.Value;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.UByte;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u0000 \f2\u00020\u0001:\u0001\fB\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\r"}, d2={"Laws/smithy/kotlin/runtime/serde/cbor/encoding/Boolean;", "Laws/smithy/kotlin/runtime/serde/cbor/encoding/Value;", "value", "", "<init>", "(Z)V", "getValue", "()Z", "encode", "", "into", "Laws/smithy/kotlin/runtime/io/SdkBufferedSink;", "Companion", "serde-cbor"})
public final class Boolean
implements Value {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final boolean value;

    public Boolean(boolean value) {
        this.value = value;
    }

    public final boolean getValue() {
        return this.value;
    }

    @Override
    public void encode(@NotNull SdkBufferedSink into) {
        byte by;
        Intrinsics.checkNotNullParameter((Object)into, (String)"into");
        boolean bl = this.value;
        if (!bl) {
            by = CborUtilsKt.encodeMajorMinor(Major.TYPE_7, Minor.FALSE);
        } else if (bl) {
            by = CborUtilsKt.encodeMajorMinor(Major.TYPE_7, Minor.TRUE);
        } else {
            throw new NoWhenBranchMatchedException();
        }
        into.writeByte(by);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0080\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0015\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0000\u00a2\u0006\u0002\b\b\u00a8\u0006\t"}, d2={"Laws/smithy/kotlin/runtime/serde/cbor/encoding/Boolean$Companion;", "", "<init>", "()V", "decode", "Laws/smithy/kotlin/runtime/serde/cbor/encoding/Boolean;", "buffer", "Laws/smithy/kotlin/runtime/io/SdkBufferedSource;", "decode$serde_cbor", "serde-cbor"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Boolean decode$serde_cbor(@NotNull SdkBufferedSource buffer) {
            Boolean boolean_;
            Boolean boolean_2;
            Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
            byte minor = MinorKt.peekMinorByte(buffer);
            if (minor == Minor.FALSE.getValue-w2LRezQ()) {
                boolean_2 = new Boolean(false);
            } else if (minor == Minor.TRUE.getValue-w2LRezQ()) {
                boolean_2 = new Boolean(true);
            } else {
                throw new DeserializationException("Unknown minor argument " + UByte.toString-impl((byte)minor) + " for Boolean");
            }
            Boolean it = boolean_ = boolean_2;
            boolean bl = false;
            buffer.readByte();
            return boolean_;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

