/*
 * Decompiled with CFR 0.152.
 */
package aws.smithy.kotlin.runtime.serde.cbor;

import aws.smithy.kotlin.runtime.InternalApi;
import aws.smithy.kotlin.runtime.content.BigDecimal;
import aws.smithy.kotlin.runtime.content.BigInteger;
import aws.smithy.kotlin.runtime.content.Document;
import aws.smithy.kotlin.runtime.http.HttpBody;
import aws.smithy.kotlin.runtime.http.HttpBodyKt;
import aws.smithy.kotlin.runtime.io.SdkBuffer;
import aws.smithy.kotlin.runtime.serde.ListSerializer;
import aws.smithy.kotlin.runtime.serde.MapSerializer;
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor;
import aws.smithy.kotlin.runtime.serde.SdkSerializable;
import aws.smithy.kotlin.runtime.serde.SerializationException;
import aws.smithy.kotlin.runtime.serde.Serializer;
import aws.smithy.kotlin.runtime.serde.StructSerializer;
import aws.smithy.kotlin.runtime.serde.cbor.CborFieldTraitsKt;
import aws.smithy.kotlin.runtime.serde.cbor.CborUtilsKt;
import aws.smithy.kotlin.runtime.serde.cbor.encoding.BigNum;
import aws.smithy.kotlin.runtime.serde.cbor.encoding.Boolean;
import aws.smithy.kotlin.runtime.serde.cbor.encoding.ByteString;
import aws.smithy.kotlin.runtime.serde.cbor.encoding.DecimalFraction;
import aws.smithy.kotlin.runtime.serde.cbor.encoding.Float32;
import aws.smithy.kotlin.runtime.serde.cbor.encoding.Float64;
import aws.smithy.kotlin.runtime.serde.cbor.encoding.IndefiniteBreak;
import aws.smithy.kotlin.runtime.serde.cbor.encoding.IndefiniteList;
import aws.smithy.kotlin.runtime.serde.cbor.encoding.IndefiniteMap;
import aws.smithy.kotlin.runtime.serde.cbor.encoding.NegBigNum;
import aws.smithy.kotlin.runtime.serde.cbor.encoding.NegInt;
import aws.smithy.kotlin.runtime.serde.cbor.encoding.Null;
import aws.smithy.kotlin.runtime.serde.cbor.encoding.TextString;
import aws.smithy.kotlin.runtime.serde.cbor.encoding.Timestamp;
import aws.smithy.kotlin.runtime.serde.cbor.encoding.UInt;
import aws.smithy.kotlin.runtime.serde.cbor.encoding.Value;
import aws.smithy.kotlin.runtime.time.Instant;
import aws.smithy.kotlin.runtime.time.TimestampFormat;
import kotlin.Metadata;
import kotlin.ULong;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@InternalApi
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u00b4\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0004\n\u0002\b\u0002\n\u0002\u0010\u0005\n\u0000\n\u0002\u0010\n\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\f\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\b\b\u0007\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u00032\u00020\u0004B\u0007\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0006\u0010\t\u001a\u00020\nJ\b\u0010\u000b\u001a\u00020\fH\u0016J\u0010\u0010\r\u001a\u00020\u00032\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\b\u0010\u0010\u001a\u00020\u0011H\u0016J\u0010\u0010\u0012\u001a\u00020\u00022\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\b\u0010\u0013\u001a\u00020\u0011H\u0016J\u0010\u0010\u0014\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\b\u0010\u0015\u001a\u00020\u0011H\u0016J\u0010\u0010\u0016\u001a\u00020\u00112\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J\"\u0010\u0019\u001a\u00020\u0011\"\n\b\u0000\u0010\u001a\u0018\u0001*\u00020\u001b2\u0006\u0010\u0017\u001a\u0002H\u001aH\u0082\b\u00a2\u0006\u0002\u0010\u001cJ\u0010\u0010\u001d\u001a\u00020\u00112\u0006\u0010\u0017\u001a\u00020\u001eH\u0016J\u0010\u0010\u001f\u001a\u00020\u00112\u0006\u0010\u0017\u001a\u00020 H\u0016J\u0010\u0010!\u001a\u00020\u00112\u0006\u0010\u0017\u001a\u00020\"H\u0016J\u0010\u0010#\u001a\u00020\u00112\u0006\u0010\u0017\u001a\u00020$H\u0016J\u0010\u0010%\u001a\u00020\u00112\u0006\u0010\u0017\u001a\u00020&H\u0016J\u0010\u0010'\u001a\u00020\u00112\u0006\u0010\u0017\u001a\u00020(H\u0016J\u0010\u0010)\u001a\u00020\u00112\u0006\u0010\u0017\u001a\u00020*H\u0016J\u0010\u0010+\u001a\u00020\u00112\u0006\u0010\u0017\u001a\u00020,H\u0016J\u0010\u0010-\u001a\u00020\u00112\u0006\u0010\u0017\u001a\u00020.H\u0016J\u0010\u0010/\u001a\u00020\u00112\u0006\u0010\u0017\u001a\u000200H\u0016J\u0018\u00101\u001a\u00020\u00112\u0006\u0010\u0017\u001a\u0002022\u0006\u00103\u001a\u000204H\u0016J\u000e\u00101\u001a\u00020\u00112\u0006\u0010\u0017\u001a\u000202J\u0010\u00105\u001a\u00020\u00112\u0006\u0010\u0017\u001a\u00020\fH\u0016J\u0010\u00106\u001a\u00020\u00112\u0006\u0010\u0017\u001a\u000207H\u0016J\b\u00108\u001a\u00020\u0011H\u0016J\u0012\u00109\u001a\u00020\u00112\b\u0010\u0017\u001a\u0004\u0018\u00010:H\u0016J:\u0010;\u001a\u00020\u0011\"\u0004\b\u0000\u0010\u001a2\u0006\u0010<\u001a\u0002002\b\u0010\u0017\u001a\u0004\u0018\u0001H\u001a2\u0012\u0010=\u001a\u000e\u0012\u0004\u0012\u0002H\u001a\u0012\u0004\u0012\u00020\u00110>H\u0082\b\u00a2\u0006\u0002\u0010?J\u001f\u0010@\u001a\u00020\u00112\u0006\u0010<\u001a\u0002002\b\u0010\u0017\u001a\u0004\u0018\u00010\u0018H\u0016\u00a2\u0006\u0002\u0010AJ\u001f\u0010@\u001a\u00020\u00112\u0006\u0010<\u001a\u0002002\b\u0010\u0017\u001a\u0004\u0018\u00010\u001eH\u0016\u00a2\u0006\u0002\u0010BJ\u001f\u0010@\u001a\u00020\u00112\u0006\u0010<\u001a\u0002002\b\u0010\u0017\u001a\u0004\u0018\u00010 H\u0016\u00a2\u0006\u0002\u0010CJ\u001f\u0010@\u001a\u00020\u00112\u0006\u0010<\u001a\u0002002\b\u0010\u0017\u001a\u0004\u0018\u00010.H\u0016\u00a2\u0006\u0002\u0010DJ\u001f\u0010@\u001a\u00020\u00112\u0006\u0010<\u001a\u0002002\b\u0010\u0017\u001a\u0004\u0018\u00010\"H\u0016\u00a2\u0006\u0002\u0010EJ\u001f\u0010@\u001a\u00020\u00112\u0006\u0010<\u001a\u0002002\b\u0010\u0017\u001a\u0004\u0018\u00010$H\u0016\u00a2\u0006\u0002\u0010FJ\u001f\u0010@\u001a\u00020\u00112\u0006\u0010<\u001a\u0002002\b\u0010\u0017\u001a\u0004\u0018\u00010&H\u0016\u00a2\u0006\u0002\u0010GJ\u001f\u0010@\u001a\u00020\u00112\u0006\u0010<\u001a\u0002002\b\u0010\u0017\u001a\u0004\u0018\u00010(H\u0016\u00a2\u0006\u0002\u0010HJ\u001a\u0010@\u001a\u00020\u00112\u0006\u0010<\u001a\u0002002\b\u0010\u0017\u001a\u0004\u0018\u000100H\u0016J\u001a\u0010@\u001a\u00020\u00112\u0006\u0010<\u001a\u0002002\b\u0010\u0017\u001a\u0004\u0018\u00010\fH\u0016J\u001a\u0010@\u001a\u00020\u00112\u0006\u0010<\u001a\u0002002\b\u0010\u0017\u001a\u0004\u0018\u00010:H\u0016J\"\u0010@\u001a\u00020\u00112\u0006\u0010<\u001a\u0002002\b\u0010\u0017\u001a\u0004\u0018\u0001022\u0006\u00103\u001a\u000204H\u0016J\u001a\u0010@\u001a\u00020\u00112\u0006\u0010<\u001a\u0002002\b\u0010\u0017\u001a\u0004\u0018\u000107H\u0016J1\u0010I\u001a\u00020\u00112\u0006\u0010<\u001a\u0002002\u0006\u0010J\u001a\u00020\u000f2\u0017\u0010K\u001a\u0013\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00110>\u00a2\u0006\u0002\bLH\u0016J1\u0010M\u001a\u00020\u00112\u0006\u0010<\u001a\u0002002\u0006\u0010N\u001a\u00020\u000f2\u0017\u0010K\u001a\u0013\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00110>\u00a2\u0006\u0002\bLH\u0016J\u0018\u0010O\u001a\u00020\u00112\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J\u0018\u0010O\u001a\u00020\u00112\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0017\u001a\u00020\u001eH\u0016J\u0018\u0010O\u001a\u00020\u00112\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0017\u001a\u00020 H\u0016J\u0018\u0010O\u001a\u00020\u00112\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0017\u001a\u00020.H\u0016J\u0018\u0010O\u001a\u00020\u00112\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0017\u001a\u00020\"H\u0016J\u0018\u0010O\u001a\u00020\u00112\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0017\u001a\u00020$H\u0016J\u0018\u0010O\u001a\u00020\u00112\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0017\u001a\u00020&H\u0016J\u0018\u0010O\u001a\u00020\u00112\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0017\u001a\u00020(H\u0016J\u0018\u0010O\u001a\u00020\u00112\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0017\u001a\u000200H\u0016J \u0010O\u001a\u00020\u00112\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0017\u001a\u0002022\u0006\u00103\u001a\u000204H\u0016J\u001a\u0010O\u001a\u00020\u00112\u0006\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0017\u001a\u0004\u0018\u00010:H\u0016J\u0018\u0010O\u001a\u00020\u00112\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0017\u001a\u000207H\u0016J\u0018\u0010O\u001a\u00020\u00112\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0017\u001a\u00020\fH\u0016J\u0018\u0010O\u001a\u00020\u00112\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0017\u001a\u00020*H\u0016J\u0018\u0010O\u001a\u00020\u00112\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0017\u001a\u00020,H\u0016J)\u0010P\u001a\u00020\u00112\u0006\u0010\u000e\u001a\u00020\u000f2\u0017\u0010K\u001a\u0013\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00110>\u00a2\u0006\u0002\bLH\u0016J)\u0010Q\u001a\u00020\u00112\u0006\u0010\u000e\u001a\u00020\u000f2\u0017\u0010K\u001a\u0013\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00110>\u00a2\u0006\u0002\bLH\u0016J)\u0010R\u001a\u00020\u00112\u0006\u0010\u000e\u001a\u00020\u000f2\u0017\u0010K\u001a\u0013\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00110>\u00a2\u0006\u0002\bLH\u0016J\u0010\u0010S\u001a\u00020\u00112\u0006\u0010\u000e\u001a\u00020\u000fH\u0016R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006T"}, d2={"Laws/smithy/kotlin/runtime/serde/cbor/CborSerializer;", "Laws/smithy/kotlin/runtime/serde/Serializer;", "Laws/smithy/kotlin/runtime/serde/ListSerializer;", "Laws/smithy/kotlin/runtime/serde/MapSerializer;", "Laws/smithy/kotlin/runtime/serde/StructSerializer;", "<init>", "()V", "buffer", "Laws/smithy/kotlin/runtime/io/SdkBuffer;", "toHttpBody", "Laws/smithy/kotlin/runtime/http/HttpBody;", "toByteArray", "", "beginMap", "descriptor", "Laws/smithy/kotlin/runtime/serde/SdkFieldDescriptor;", "endMap", "", "beginList", "endList", "beginStruct", "endStruct", "serializeBoolean", "value", "", "serializeNumber", "T", "", "(Ljava/lang/Number;)V", "serializeByte", "", "serializeShort", "", "serializeInt", "", "serializeLong", "", "serializeFloat", "", "serializeDouble", "", "serializeBigInteger", "Laws/smithy/kotlin/runtime/content/BigInteger;", "serializeBigDecimal", "Laws/smithy/kotlin/runtime/content/BigDecimal;", "serializeChar", "", "serializeString", "", "serializeInstant", "Laws/smithy/kotlin/runtime/time/Instant;", "format", "Laws/smithy/kotlin/runtime/time/TimestampFormat;", "serializeByteArray", "serializeSdkSerializable", "Laws/smithy/kotlin/runtime/serde/SdkSerializable;", "serializeNull", "serializeDocument", "Laws/smithy/kotlin/runtime/content/Document;", "serializeEntry", "key", "serializeValue", "Lkotlin/Function1;", "(Ljava/lang/String;Ljava/lang/Object;Lkotlin/jvm/functions/Function1;)V", "entry", "(Ljava/lang/String;Ljava/lang/Boolean;)V", "(Ljava/lang/String;Ljava/lang/Byte;)V", "(Ljava/lang/String;Ljava/lang/Short;)V", "(Ljava/lang/String;Ljava/lang/Character;)V", "(Ljava/lang/String;Ljava/lang/Integer;)V", "(Ljava/lang/String;Ljava/lang/Long;)V", "(Ljava/lang/String;Ljava/lang/Float;)V", "(Ljava/lang/String;Ljava/lang/Double;)V", "listEntry", "listDescriptor", "block", "Lkotlin/ExtensionFunctionType;", "mapEntry", "mapDescriptor", "field", "structField", "listField", "mapField", "nullField", "serde-cbor"})
@SourceDebugExtension(value={"SMAP\nCborSerializer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CborSerializer.kt\naws/smithy/kotlin/runtime/serde/cbor/CborSerializer\n+ 2 Serializer.kt\naws/smithy/kotlin/runtime/serde/SerializerKt\n*L\n1#1,190:1\n60#1,7:191\n60#1,7:198\n60#1,7:205\n60#1,7:212\n103#1,3:219\n103#1,3:222\n103#1,3:225\n103#1,3:228\n103#1,3:231\n103#1,3:234\n103#1,3:237\n103#1,3:240\n103#1,3:243\n103#1,3:246\n504#2,4:249\n514#2,4:253\n524#2,4:257\n*S KotlinDebug\n*F\n+ 1 CborSerializer.kt\naws/smithy/kotlin/runtime/serde/cbor/CborSerializer\n*L\n67#1:191,7\n68#1:198,7\n69#1:205,7\n70#1:212,7\n106#1:219,3\n107#1:222,3\n108#1:225,3\n109#1:228,3\n110#1:231,3\n111#1:234,3\n112#1:237,3\n113#1:240,3\n114#1:243,3\n115#1:246,3\n172#1:249,4\n177#1:253,4\n182#1:257,4\n*E\n"})
public final class CborSerializer
implements Serializer,
ListSerializer,
MapSerializer,
StructSerializer {
    @NotNull
    private final SdkBuffer buffer = new SdkBuffer();

    @NotNull
    public final HttpBody toHttpBody() {
        return HttpBodyKt.toHttpBody((byte[])this.buffer.readByteArray());
    }

    @NotNull
    public byte[] toByteArray() {
        return this.buffer.readByteArray();
    }

    @NotNull
    public MapSerializer beginMap(@NotNull SdkFieldDescriptor descriptor) {
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        CborUtilsKt.write(this.buffer, new IndefiniteMap(null, 1, null));
        return this;
    }

    public void endMap() {
        CborUtilsKt.write(this.buffer, IndefiniteBreak.INSTANCE);
    }

    @NotNull
    public ListSerializer beginList(@NotNull SdkFieldDescriptor descriptor) {
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        CborUtilsKt.write(this.buffer, new IndefiniteList(null, 1, null));
        return this;
    }

    public void endList() {
        CborUtilsKt.write(this.buffer, IndefiniteBreak.INSTANCE);
    }

    @NotNull
    public StructSerializer beginStruct(@NotNull SdkFieldDescriptor descriptor) {
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        this.beginMap(descriptor);
        return this;
    }

    public void endStruct() {
        this.endMap();
    }

    public void serializeBoolean(boolean value) {
        CborUtilsKt.write(this.buffer, new Boolean(value));
    }

    private final /* synthetic */ <T extends Number> void serializeNumber(T value) {
        boolean $i$f$serializeNumber = false;
        CborUtilsKt.write(this.buffer, value.longValue() < 0L ? (Value)new NegInt(ULong.constructor-impl((long)Math.abs(value.longValue())), null) : (Value)new UInt(ULong.constructor-impl((long)value.longValue()), null));
    }

    /*
     * WARNING - void declaration
     */
    public void serializeByte(byte value) {
        void this_$iv;
        CborSerializer cborSerializer = this;
        byte value$iv = value;
        boolean $i$f$serializeNumber = false;
        CborUtilsKt.write(this_$iv.buffer, (long)value$iv < 0L ? (Value)new NegInt(ULong.constructor-impl((long)Math.abs((long)value$iv)), null) : (Value)new UInt(ULong.constructor-impl((long)value$iv), null));
    }

    /*
     * WARNING - void declaration
     */
    public void serializeShort(short value) {
        void this_$iv;
        CborSerializer cborSerializer = this;
        short value$iv = value;
        boolean $i$f$serializeNumber = false;
        CborUtilsKt.write(this_$iv.buffer, (long)value$iv < 0L ? (Value)new NegInt(ULong.constructor-impl((long)Math.abs((long)value$iv)), null) : (Value)new UInt(ULong.constructor-impl((long)value$iv), null));
    }

    /*
     * WARNING - void declaration
     */
    public void serializeInt(int value) {
        void this_$iv;
        CborSerializer cborSerializer = this;
        int value$iv = value;
        boolean $i$f$serializeNumber = false;
        CborUtilsKt.write(this_$iv.buffer, (long)value$iv < 0L ? (Value)new NegInt(ULong.constructor-impl((long)Math.abs((long)value$iv)), null) : (Value)new UInt(ULong.constructor-impl((long)value$iv), null));
    }

    /*
     * WARNING - void declaration
     */
    public void serializeLong(long value) {
        void this_$iv;
        CborSerializer cborSerializer = this;
        long value$iv = value;
        boolean $i$f$serializeNumber = false;
        CborUtilsKt.write(this_$iv.buffer, value$iv < 0L ? (Value)new NegInt(ULong.constructor-impl((long)Math.abs(value$iv)), null) : (Value)new UInt(ULong.constructor-impl((long)value$iv), null));
    }

    public void serializeFloat(float value) {
        CborUtilsKt.write(this.buffer, new Float32(value));
    }

    public void serializeDouble(double value) {
        CborUtilsKt.write(this.buffer, new Float64(value));
    }

    public void serializeBigInteger(@NotNull BigInteger value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        if (StringsKt.startsWith$default((String)value.toString(), (String)"-", (boolean)false, (int)2, null)) {
            CborUtilsKt.write(this.buffer, new NegBigNum(value));
        } else {
            CborUtilsKt.write(this.buffer, new BigNum(value));
        }
    }

    public void serializeBigDecimal(@NotNull BigDecimal value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        CborUtilsKt.write(this.buffer, new DecimalFraction(value));
    }

    public void serializeChar(char value) {
        CborUtilsKt.write(this.buffer, new TextString(String.valueOf(value)));
    }

    public void serializeString(@NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        CborUtilsKt.write(this.buffer, new TextString(value));
    }

    public void serializeInstant(@NotNull Instant value, @NotNull TimestampFormat format) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        Intrinsics.checkNotNullParameter((Object)format, (String)"format");
        this.serializeInstant(value);
    }

    public final void serializeInstant(@NotNull Instant value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        CborUtilsKt.write(this.buffer, new Timestamp(value));
    }

    public void serializeByteArray(@NotNull byte[] value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        CborUtilsKt.write(this.buffer, new ByteString(value));
    }

    public void serializeSdkSerializable(@NotNull SdkSerializable value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        value.serialize((Serializer)this);
    }

    public void serializeNull() {
        CborUtilsKt.write(this.buffer, Null.INSTANCE);
    }

    public void serializeDocument(@Nullable Document value) {
        throw new SerializationException("Document is not a supported CBOR type");
    }

    private final <T> void serializeEntry(String key, T value, Function1<? super T, Unit> serializeValue) {
        boolean $i$f$serializeEntry = false;
        this.serializeString(key);
        T t = value;
        if (t != null) {
            serializeValue.invoke(t);
        } else {
            this.serializeNull();
        }
    }

    public void entry(@NotNull String key, @Nullable java.lang.Boolean value) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        CborSerializer this_$iv = this;
        boolean $i$f$serializeEntry = false;
        this_$iv.serializeString(key);
        java.lang.Boolean bl = value;
        if (bl != null) {
            boolean p0 = bl;
            boolean $i$f$entry$stub_for_inlining = false;
            boolean bl2 = false;
            this.serializeBoolean(p0);
        } else {
            this_$iv.serializeNull();
        }
    }

    public void entry(@NotNull String key, @Nullable Byte value) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        CborSerializer this_$iv = this;
        boolean $i$f$serializeEntry = false;
        this_$iv.serializeString(key);
        Byte by = value;
        if (by != null) {
            byte p0 = ((Number)by).byteValue();
            boolean $i$f$entry$stub_for_inlining$0 = false;
            boolean bl = false;
            this.serializeByte(p0);
        } else {
            this_$iv.serializeNull();
        }
    }

    public void entry(@NotNull String key, @Nullable Short value) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        CborSerializer this_$iv = this;
        boolean $i$f$serializeEntry = false;
        this_$iv.serializeString(key);
        Short s = value;
        if (s != null) {
            short p0 = ((Number)s).shortValue();
            boolean $i$f$entry$stub_for_inlining$1 = false;
            boolean bl = false;
            this.serializeShort(p0);
        } else {
            this_$iv.serializeNull();
        }
    }

    public void entry(@NotNull String key, @Nullable Character value) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        CborSerializer this_$iv = this;
        boolean $i$f$serializeEntry = false;
        this_$iv.serializeString(key);
        Character c = value;
        if (c != null) {
            char p0 = c.charValue();
            boolean $i$f$entry$stub_for_inlining$2 = false;
            boolean bl = false;
            this.serializeChar(p0);
        } else {
            this_$iv.serializeNull();
        }
    }

    public void entry(@NotNull String key, @Nullable Integer value) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        CborSerializer this_$iv = this;
        boolean $i$f$serializeEntry = false;
        this_$iv.serializeString(key);
        Integer n = value;
        if (n != null) {
            int p0 = ((Number)n).intValue();
            boolean $i$f$entry$stub_for_inlining$3 = false;
            boolean bl = false;
            this.serializeInt(p0);
        } else {
            this_$iv.serializeNull();
        }
    }

    public void entry(@NotNull String key, @Nullable Long value) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        CborSerializer this_$iv = this;
        boolean $i$f$serializeEntry = false;
        this_$iv.serializeString(key);
        Long l = value;
        if (l != null) {
            long p0 = ((Number)l).longValue();
            boolean $i$f$entry$stub_for_inlining$4 = false;
            boolean bl = false;
            this.serializeLong(p0);
        } else {
            this_$iv.serializeNull();
        }
    }

    public void entry(@NotNull String key, @Nullable Float value) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        CborSerializer this_$iv = this;
        boolean $i$f$serializeEntry = false;
        this_$iv.serializeString(key);
        Float f = value;
        if (f != null) {
            float p0 = ((Number)f).floatValue();
            boolean $i$f$entry$stub_for_inlining$5 = false;
            boolean bl = false;
            this.serializeFloat(p0);
        } else {
            this_$iv.serializeNull();
        }
    }

    public void entry(@NotNull String key, @Nullable Double value) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        CborSerializer this_$iv = this;
        boolean $i$f$serializeEntry = false;
        this_$iv.serializeString(key);
        Double d = value;
        if (d != null) {
            double p0 = ((Number)d).doubleValue();
            boolean $i$f$entry$stub_for_inlining$6 = false;
            boolean bl = false;
            this.serializeDouble(p0);
        } else {
            this_$iv.serializeNull();
        }
    }

    public void entry(@NotNull String key, @Nullable String value) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        CborSerializer this_$iv = this;
        boolean $i$f$serializeEntry = false;
        this_$iv.serializeString(key);
        String string = value;
        if (string != null) {
            String p0 = string;
            boolean $i$f$entry$stub_for_inlining$7 = false;
            boolean bl = false;
            this.serializeString(p0);
        } else {
            this_$iv.serializeNull();
        }
    }

    public void entry(@NotNull String key, @Nullable byte[] value) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        CborSerializer this_$iv = this;
        boolean $i$f$serializeEntry = false;
        this_$iv.serializeString(key);
        if (value != null) {
            byte[] p0 = value;
            boolean $i$f$entry$stub_for_inlining$8 = false;
            boolean bl = false;
            this.serializeByteArray(p0);
        } else {
            this_$iv.serializeNull();
        }
    }

    public void entry(@NotNull String key, @Nullable Document value) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        throw new SerializationException("Document is not a supported CBOR type.");
    }

    public void entry(@NotNull String key, @Nullable Instant value, @NotNull TimestampFormat format) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)format, (String)"format");
        this.serializeString(key);
        Instant instant = value;
        if (instant != null) {
            Instant it = instant;
            boolean bl = false;
            this.serializeInstant(it, format);
        } else {
            this.serializeNull();
        }
    }

    public void entry(@NotNull String key, @Nullable SdkSerializable value) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        this.serializeString(key);
        SdkSerializable sdkSerializable = value;
        if (sdkSerializable != null) {
            SdkSerializable it = sdkSerializable;
            boolean bl = false;
            this.serializeSdkSerializable(value);
        } else {
            this.serializeNull();
        }
    }

    public void listEntry(@NotNull String key, @NotNull SdkFieldDescriptor listDescriptor, @NotNull Function1<? super ListSerializer, Unit> block) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)listDescriptor, (String)"listDescriptor");
        Intrinsics.checkNotNullParameter(block, (String)"block");
        this.serializeString(key);
        this.beginList(listDescriptor);
        block.invoke((Object)this);
        this.endList();
    }

    public void mapEntry(@NotNull String key, @NotNull SdkFieldDescriptor mapDescriptor, @NotNull Function1<? super MapSerializer, Unit> block) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)mapDescriptor, (String)"mapDescriptor");
        Intrinsics.checkNotNullParameter(block, (String)"block");
        this.serializeString(key);
        this.beginMap(mapDescriptor);
        block.invoke((Object)this);
        this.endMap();
    }

    public void field(@NotNull SdkFieldDescriptor descriptor, boolean value) {
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        this.entry(CborFieldTraitsKt.getSerialName(descriptor), value);
    }

    public void field(@NotNull SdkFieldDescriptor descriptor, byte value) {
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        this.entry(CborFieldTraitsKt.getSerialName(descriptor), value);
    }

    public void field(@NotNull SdkFieldDescriptor descriptor, short value) {
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        this.entry(CborFieldTraitsKt.getSerialName(descriptor), value);
    }

    public void field(@NotNull SdkFieldDescriptor descriptor, char value) {
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        this.entry(CborFieldTraitsKt.getSerialName(descriptor), Character.valueOf(value));
    }

    public void field(@NotNull SdkFieldDescriptor descriptor, int value) {
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        this.entry(CborFieldTraitsKt.getSerialName(descriptor), value);
    }

    public void field(@NotNull SdkFieldDescriptor descriptor, long value) {
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        this.entry(CborFieldTraitsKt.getSerialName(descriptor), value);
    }

    public void field(@NotNull SdkFieldDescriptor descriptor, float value) {
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        this.entry(CborFieldTraitsKt.getSerialName(descriptor), Float.valueOf(value));
    }

    public void field(@NotNull SdkFieldDescriptor descriptor, double value) {
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        this.entry(CborFieldTraitsKt.getSerialName(descriptor), value);
    }

    public void field(@NotNull SdkFieldDescriptor descriptor, @NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        this.entry(CborFieldTraitsKt.getSerialName(descriptor), value);
    }

    public void field(@NotNull SdkFieldDescriptor descriptor, @NotNull Instant value, @NotNull TimestampFormat format) {
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        Intrinsics.checkNotNullParameter((Object)format, (String)"format");
        this.entry(CborFieldTraitsKt.getSerialName(descriptor), value, format);
    }

    public void field(@NotNull SdkFieldDescriptor descriptor, @Nullable Document value) {
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        throw new SerializationException("Document is not a supported CBOR type.");
    }

    public void field(@NotNull SdkFieldDescriptor descriptor, @NotNull SdkSerializable value) {
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        this.entry(CborFieldTraitsKt.getSerialName(descriptor), value);
    }

    public void field(@NotNull SdkFieldDescriptor descriptor, @NotNull byte[] value) {
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        this.entry(CborFieldTraitsKt.getSerialName(descriptor), value);
    }

    public void field(@NotNull SdkFieldDescriptor descriptor, @NotNull BigInteger value) {
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        CborUtilsKt.write(this.buffer, new TextString(CborFieldTraitsKt.getSerialName(descriptor)));
        this.serializeBigInteger(value);
    }

    public void field(@NotNull SdkFieldDescriptor descriptor, @NotNull BigDecimal value) {
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        CborUtilsKt.write(this.buffer, new TextString(CborFieldTraitsKt.getSerialName(descriptor)));
        this.serializeBigDecimal(value);
    }

    public void structField(@NotNull SdkFieldDescriptor descriptor, @NotNull Function1<? super StructSerializer, Unit> block) {
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        Intrinsics.checkNotNullParameter(block, (String)"block");
        CborUtilsKt.write(this.buffer, new TextString(CborFieldTraitsKt.getSerialName(descriptor)));
        Serializer $this$serializeStruct$iv = this;
        boolean $i$f$serializeStruct = false;
        StructSerializer struct$iv = $this$serializeStruct$iv.beginStruct(descriptor);
        block.invoke((Object)struct$iv);
        struct$iv.endStruct();
    }

    public void listField(@NotNull SdkFieldDescriptor descriptor, @NotNull Function1<? super ListSerializer, Unit> block) {
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        Intrinsics.checkNotNullParameter(block, (String)"block");
        CborUtilsKt.write(this.buffer, new TextString(CborFieldTraitsKt.getSerialName(descriptor)));
        Serializer $this$serializeList$iv = this;
        boolean $i$f$serializeList = false;
        ListSerializer list$iv = $this$serializeList$iv.beginList(descriptor);
        block.invoke((Object)list$iv);
        list$iv.endList();
    }

    public void mapField(@NotNull SdkFieldDescriptor descriptor, @NotNull Function1<? super MapSerializer, Unit> block) {
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        Intrinsics.checkNotNullParameter(block, (String)"block");
        CborUtilsKt.write(this.buffer, new TextString(CborFieldTraitsKt.getSerialName(descriptor)));
        Serializer $this$serializeMap$iv = this;
        boolean $i$f$serializeMap = false;
        MapSerializer map$iv = $this$serializeMap$iv.beginMap(descriptor);
        block.invoke((Object)map$iv);
        map$iv.endMap();
    }

    public void nullField(@NotNull SdkFieldDescriptor descriptor) {
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        CborUtilsKt.write(this.buffer, new TextString(CborFieldTraitsKt.getSerialName(descriptor)));
        this.serializeNull();
    }
}

