/*
 * Decompiled with CFR 0.152.
 */
package aws.smithy.kotlin.runtime.serde.cbor;

import aws.smithy.kotlin.runtime.content.BigDecimal;
import aws.smithy.kotlin.runtime.content.BigInteger;
import aws.smithy.kotlin.runtime.content.Document;
import aws.smithy.kotlin.runtime.io.SdkBuffer;
import aws.smithy.kotlin.runtime.io.SdkBufferedSource;
import aws.smithy.kotlin.runtime.serde.DeserializationException;
import aws.smithy.kotlin.runtime.serde.Deserializer;
import aws.smithy.kotlin.runtime.serde.PrimitiveDeserializer;
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor;
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor;
import aws.smithy.kotlin.runtime.serde.cbor.CborFieldTraitsKt;
import aws.smithy.kotlin.runtime.serde.cbor.CborPrimitiveDeserializer;
import aws.smithy.kotlin.runtime.serde.cbor.CborUtilsKt;
import aws.smithy.kotlin.runtime.serde.cbor.encoding.IndefiniteBreak;
import aws.smithy.kotlin.runtime.serde.cbor.encoding.TextString;
import aws.smithy.kotlin.runtime.serde.cbor.encoding.Value;
import aws.smithy.kotlin.runtime.time.Instant;
import aws.smithy.kotlin.runtime.time.TimestampFormat;
import kotlin.Metadata;
import kotlin.ULong;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0086\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0005\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0001\n\u0000\n\u0002\u0010\n\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0002\u0018\u00002\u00020\u00012\u00020\u0002B#\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nJ\u000f\u0010\u0017\u001a\u0004\u0018\u00010\u0018H\u0016\u00a2\u0006\u0002\u0010\u0019J\b\u0010\u001a\u001a\u00020\u001bH\u0016J\t\u0010\u001c\u001a\u00020\u001dH\u0096\u0001J\t\u0010\u001e\u001a\u00020\u001fH\u0096\u0001J\t\u0010 \u001a\u00020!H\u0096\u0001J\t\u0010\"\u001a\u00020#H\u0096\u0001J\t\u0010$\u001a\u00020%H\u0096\u0001J\t\u0010&\u001a\u00020'H\u0096\u0001J\t\u0010(\u001a\u00020)H\u0096\u0001J\t\u0010*\u001a\u00020+H\u0096\u0001J\u0011\u0010,\u001a\u00020-2\u0006\u0010.\u001a\u00020/H\u0096\u0001J\t\u00100\u001a\u00020\u0018H\u0096\u0001J\t\u00101\u001a\u000202H\u0096\u0001J\u000b\u00103\u001a\u0004\u0018\u000104H\u0096\u0001J\t\u00105\u001a\u000206H\u0096\u0001J\t\u00107\u001a\u000208H\u0096\u0001R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0013\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u001c\u0010\u0011\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u0010\n\u0002\u0010\u0016\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015\u00a8\u00069"}, d2={"Laws/smithy/kotlin/runtime/serde/cbor/CborFieldIterator;", "Laws/smithy/kotlin/runtime/serde/Deserializer$FieldIterator;", "Laws/smithy/kotlin/runtime/serde/PrimitiveDeserializer;", "buffer", "Laws/smithy/kotlin/runtime/io/SdkBuffer;", "expectedLength", "Lkotlin/ULong;", "descriptor", "Laws/smithy/kotlin/runtime/serde/SdkObjectDescriptor;", "<init>", "(Laws/smithy/kotlin/runtime/io/SdkBuffer;Lkotlin/ULong;Laws/smithy/kotlin/runtime/serde/SdkObjectDescriptor;Lkotlin/jvm/internal/DefaultConstructorMarker;)V", "getBuffer", "()Laws/smithy/kotlin/runtime/io/SdkBuffer;", "getExpectedLength-6VbMDqA", "()Lkotlin/ULong;", "getDescriptor", "()Laws/smithy/kotlin/runtime/serde/SdkObjectDescriptor;", "currentLength", "getCurrentLength-s-VKNKU", "()J", "setCurrentLength-VKZWuLQ", "(J)V", "J", "findNextFieldIndex", "", "()Ljava/lang/Integer;", "skipValue", "", "deserializeBigDecimal", "Laws/smithy/kotlin/runtime/content/BigDecimal;", "deserializeBigInteger", "Laws/smithy/kotlin/runtime/content/BigInteger;", "deserializeBoolean", "", "deserializeByte", "", "deserializeByteArray", "", "deserializeDocument", "Laws/smithy/kotlin/runtime/content/Document;", "deserializeDouble", "", "deserializeFloat", "", "deserializeInstant", "Laws/smithy/kotlin/runtime/time/Instant;", "format", "Laws/smithy/kotlin/runtime/time/TimestampFormat;", "deserializeInt", "deserializeLong", "", "deserializeNull", "", "deserializeShort", "", "deserializeString", "", "serde-cbor"})
@SourceDebugExtension(value={"SMAP\nCborDeserializer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CborDeserializer.kt\naws/smithy/kotlin/runtime/serde/cbor/CborFieldIterator\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,257:1\n295#2,2:258\n*S KotlinDebug\n*F\n+ 1 CborDeserializer.kt\naws/smithy/kotlin/runtime/serde/cbor/CborFieldIterator\n*L\n204#1:258,2\n*E\n"})
final class CborFieldIterator
implements Deserializer.FieldIterator,
PrimitiveDeserializer {
    private final /* synthetic */ CborPrimitiveDeserializer $$delegate_0;
    @NotNull
    private final SdkBuffer buffer;
    @Nullable
    private final ULong expectedLength;
    @NotNull
    private final SdkObjectDescriptor descriptor;
    private long currentLength;

    private CborFieldIterator(SdkBuffer buffer, ULong expectedLength, SdkObjectDescriptor descriptor) {
        Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        this.$$delegate_0 = new CborPrimitiveDeserializer((SdkBufferedSource)buffer);
        this.buffer = buffer;
        this.expectedLength = expectedLength;
        this.descriptor = descriptor;
    }

    public /* synthetic */ CborFieldIterator(SdkBuffer sdkBuffer, ULong uLong, SdkObjectDescriptor sdkObjectDescriptor, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            uLong = null;
        }
        this(sdkBuffer, uLong, sdkObjectDescriptor, null);
    }

    @NotNull
    public final SdkBuffer getBuffer() {
        return this.buffer;
    }

    @Nullable
    public final ULong getExpectedLength-6VbMDqA() {
        return this.expectedLength;
    }

    @NotNull
    public final SdkObjectDescriptor getDescriptor() {
        return this.descriptor;
    }

    public final long getCurrentLength-s-VKNKU() {
        return this.currentLength;
    }

    public final void setCurrentLength-VKZWuLQ(long l) {
        this.currentLength = l;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public Integer findNextFieldIndex() {
        Integer candidate;
        Integer n;
        long l;
        ULong uLong;
        if (this.buffer.exhausted()) {
            uLong = this.expectedLength;
            l = this.currentLength;
            ULong uLong2 = uLong;
            if (!(uLong2 == null ? false : uLong2.unbox-impl() == l)) {
                throw new DeserializationException("Buffer is unexpectedly exhausted, expected " + this.expectedLength + " elements, got " + ULong.toString-impl((long)this.currentLength));
            }
        }
        uLong = this.expectedLength;
        l = this.currentLength;
        ULong uLong3 = uLong;
        if (uLong3 == null ? false : uLong3.unbox-impl() == l) {
            return null;
        }
        this.currentLength = ULong.constructor-impl((long)(this.currentLength + 1L));
        if (CborUtilsKt.getNextValueIsIndefiniteBreak((SdkBufferedSource)this.buffer)) {
            if (this.expectedLength != null) {
                throw new DeserializationException("Received unexpected indefinite break while deserializing structure, expected " + this.expectedLength + " elements, got " + ULong.toString-impl((long)this.currentLength));
            }
            IndefiniteBreak.INSTANCE.decode$serde_cbor((SdkBufferedSource)this.buffer);
            n = null;
        } else {
            Object v3;
            block8: {
                void $this$firstOrNull$iv;
                String nextFieldName = TextString.Companion.decode((SdkBufferedSource)this.buffer).getValue();
                Iterable iterable = this.descriptor.getFields();
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    SdkFieldDescriptor it = (SdkFieldDescriptor)element$iv;
                    boolean bl = false;
                    if (!Intrinsics.areEqual((Object)CborFieldTraitsKt.getSerialName(it), (Object)nextFieldName)) continue;
                    v3 = element$iv;
                    break block8;
                }
                v3 = null;
            }
            SdkFieldDescriptor sdkFieldDescriptor = v3;
            n = candidate = Integer.valueOf(sdkFieldDescriptor != null ? sdkFieldDescriptor.getIndex() : -1);
        }
        if (candidate != null && CborUtilsKt.getNextValueIsNull((SdkBufferedSource)this.buffer)) {
            this.skipValue();
            return this.findNextFieldIndex();
        }
        return candidate;
    }

    public void skipValue() {
        Value.Companion.decode((SdkBufferedSource)this.buffer);
    }

    public byte deserializeByte() {
        return this.$$delegate_0.deserializeByte();
    }

    public int deserializeInt() {
        return this.$$delegate_0.deserializeInt();
    }

    public short deserializeShort() {
        return this.$$delegate_0.deserializeShort();
    }

    public long deserializeLong() {
        return this.$$delegate_0.deserializeLong();
    }

    public float deserializeFloat() {
        return this.$$delegate_0.deserializeFloat();
    }

    public double deserializeDouble() {
        return this.$$delegate_0.deserializeDouble();
    }

    @NotNull
    public BigInteger deserializeBigInteger() {
        return this.$$delegate_0.deserializeBigInteger();
    }

    @NotNull
    public BigDecimal deserializeBigDecimal() {
        return this.$$delegate_0.deserializeBigDecimal();
    }

    @NotNull
    public String deserializeString() {
        return this.$$delegate_0.deserializeString();
    }

    public boolean deserializeBoolean() {
        return this.$$delegate_0.deserializeBoolean();
    }

    @NotNull
    public Document deserializeDocument() {
        return this.$$delegate_0.deserializeDocument();
    }

    @Nullable
    public Void deserializeNull() {
        return this.$$delegate_0.deserializeNull();
    }

    @NotNull
    public byte[] deserializeByteArray() {
        return this.$$delegate_0.deserializeByteArray();
    }

    @NotNull
    public Instant deserializeInstant(@NotNull TimestampFormat format) {
        Intrinsics.checkNotNullParameter((Object)format, (String)"format");
        return this.$$delegate_0.deserializeInstant(format);
    }

    public /* synthetic */ CborFieldIterator(SdkBuffer buffer, ULong expectedLength, SdkObjectDescriptor descriptor, DefaultConstructorMarker $constructor_marker) {
        this(buffer, expectedLength, descriptor);
    }
}

