/*
 * Decompiled with CFR 0.152.
 */
package aws.smithy.kotlin.runtime.serde.cbor;

import aws.smithy.kotlin.runtime.content.BigDecimal;
import aws.smithy.kotlin.runtime.content.BigInteger;
import aws.smithy.kotlin.runtime.content.Document;
import aws.smithy.kotlin.runtime.io.SdkBufferedSource;
import aws.smithy.kotlin.runtime.serde.Deserializer;
import aws.smithy.kotlin.runtime.serde.PrimitiveDeserializer;
import aws.smithy.kotlin.runtime.serde.cbor.CborPrimitiveDeserializer;
import aws.smithy.kotlin.runtime.serde.cbor.CborUtilsKt;
import aws.smithy.kotlin.runtime.serde.cbor.encoding.IndefiniteBreak;
import aws.smithy.kotlin.runtime.time.Instant;
import aws.smithy.kotlin.runtime.time.TimestampFormat;
import kotlin.Metadata;
import kotlin.ULong;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000|\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0005\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0001\n\u0000\n\u0002\u0010\n\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u00012\u00020\u0002B\u0019\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\b\u0010\u000f\u001a\u00020\u0010H\u0016J\b\u0010\u0011\u001a\u00020\u0012H\u0016J\b\u0010\u0013\u001a\u00020\u0010H\u0016J\t\u0010\u0014\u001a\u00020\u0015H\u0096\u0001J\t\u0010\u0016\u001a\u00020\u0017H\u0096\u0001J\t\u0010\u0018\u001a\u00020\u0010H\u0096\u0001J\t\u0010\u0019\u001a\u00020\u001aH\u0096\u0001J\t\u0010\u001b\u001a\u00020\u001cH\u0096\u0001J\t\u0010\u001d\u001a\u00020\u001eH\u0096\u0001J\t\u0010\u001f\u001a\u00020 H\u0096\u0001J\t\u0010!\u001a\u00020\"H\u0096\u0001J\u0011\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020&H\u0096\u0001J\t\u0010'\u001a\u00020(H\u0096\u0001J\t\u0010)\u001a\u00020*H\u0096\u0001J\u000b\u0010+\u001a\u0004\u0018\u00010,H\u0096\u0001J\t\u0010-\u001a\u00020.H\u0096\u0001J\t\u0010/\u001a\u00020\u0012H\u0096\u0001R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0013\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0010\u0010\r\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u000e\u00a8\u00060"}, d2={"Laws/smithy/kotlin/runtime/serde/cbor/CborEntryIterator;", "Laws/smithy/kotlin/runtime/serde/Deserializer$EntryIterator;", "Laws/smithy/kotlin/runtime/serde/PrimitiveDeserializer;", "buffer", "Laws/smithy/kotlin/runtime/io/SdkBufferedSource;", "expectedLength", "Lkotlin/ULong;", "<init>", "(Laws/smithy/kotlin/runtime/io/SdkBufferedSource;Lkotlin/ULong;Lkotlin/jvm/internal/DefaultConstructorMarker;)V", "getBuffer", "()Laws/smithy/kotlin/runtime/io/SdkBufferedSource;", "getExpectedLength-6VbMDqA", "()Lkotlin/ULong;", "currentLength", "J", "hasNextEntry", "", "key", "", "nextHasValue", "deserializeBigDecimal", "Laws/smithy/kotlin/runtime/content/BigDecimal;", "deserializeBigInteger", "Laws/smithy/kotlin/runtime/content/BigInteger;", "deserializeBoolean", "deserializeByte", "", "deserializeByteArray", "", "deserializeDocument", "Laws/smithy/kotlin/runtime/content/Document;", "deserializeDouble", "", "deserializeFloat", "", "deserializeInstant", "Laws/smithy/kotlin/runtime/time/Instant;", "format", "Laws/smithy/kotlin/runtime/time/TimestampFormat;", "deserializeInt", "", "deserializeLong", "", "deserializeNull", "", "deserializeShort", "", "deserializeString", "serde-cbor"})
@SourceDebugExtension(value={"SMAP\nCborDeserializer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CborDeserializer.kt\naws/smithy/kotlin/runtime/serde/cbor/CborEntryIterator\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,257:1\n1#2:258\n*E\n"})
final class CborEntryIterator
implements Deserializer.EntryIterator,
PrimitiveDeserializer {
    private final /* synthetic */ CborPrimitiveDeserializer $$delegate_0;
    @NotNull
    private final SdkBufferedSource buffer;
    @Nullable
    private final ULong expectedLength;
    private long currentLength;

    private CborEntryIterator(SdkBufferedSource buffer, ULong expectedLength) {
        Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
        this.$$delegate_0 = new CborPrimitiveDeserializer(buffer);
        this.buffer = buffer;
        this.expectedLength = expectedLength;
    }

    @NotNull
    public final SdkBufferedSource getBuffer() {
        return this.buffer;
    }

    @Nullable
    public final ULong getExpectedLength-6VbMDqA() {
        return this.expectedLength;
    }

    public boolean hasNextEntry() {
        boolean bl;
        if (this.expectedLength != null) {
            boolean bl2;
            if (!ULong.equals-impl((long)this.currentLength, (Object)this.expectedLength)) {
                if (!(!this.buffer.exhausted())) {
                    boolean $i$a$-check-CborEntryIterator$hasNextEntry$32 = false;
                    String $i$a$-check-CborEntryIterator$hasNextEntry$32 = "Buffer unexpectedly exhausted, expected " + this.expectedLength + " elements, read " + ULong.toString-impl((long)this.currentLength);
                    throw new IllegalStateException($i$a$-check-CborEntryIterator$hasNextEntry$32.toString());
                }
                bl2 = true;
            } else {
                bl2 = false;
            }
            return bl2;
        }
        if (CborUtilsKt.getNextValueIsIndefiniteBreak(this.buffer)) {
            IndefiniteBreak.INSTANCE.decode$serde_cbor(this.buffer);
            bl = false;
        } else {
            if (!(!this.buffer.exhausted())) {
                boolean bl3 = false;
                String string = "Buffer is unexpectedly exhausted";
                throw new IllegalStateException(string.toString());
            }
            bl = true;
        }
        return bl;
    }

    @NotNull
    public String key() {
        String string;
        String it = string = this.deserializeString();
        boolean bl = false;
        this.currentLength = ULong.constructor-impl((long)(this.currentLength + 1L));
        return string;
    }

    public boolean nextHasValue() {
        return !CborUtilsKt.getNextValueIsNull(this.buffer);
    }

    public byte deserializeByte() {
        return this.$$delegate_0.deserializeByte();
    }

    public int deserializeInt() {
        return this.$$delegate_0.deserializeInt();
    }

    public short deserializeShort() {
        return this.$$delegate_0.deserializeShort();
    }

    public long deserializeLong() {
        return this.$$delegate_0.deserializeLong();
    }

    public float deserializeFloat() {
        return this.$$delegate_0.deserializeFloat();
    }

    public double deserializeDouble() {
        return this.$$delegate_0.deserializeDouble();
    }

    @NotNull
    public BigInteger deserializeBigInteger() {
        return this.$$delegate_0.deserializeBigInteger();
    }

    @NotNull
    public BigDecimal deserializeBigDecimal() {
        return this.$$delegate_0.deserializeBigDecimal();
    }

    @NotNull
    public String deserializeString() {
        return this.$$delegate_0.deserializeString();
    }

    public boolean deserializeBoolean() {
        return this.$$delegate_0.deserializeBoolean();
    }

    @NotNull
    public Document deserializeDocument() {
        return this.$$delegate_0.deserializeDocument();
    }

    @Nullable
    public Void deserializeNull() {
        return this.$$delegate_0.deserializeNull();
    }

    @NotNull
    public byte[] deserializeByteArray() {
        return this.$$delegate_0.deserializeByteArray();
    }

    @NotNull
    public Instant deserializeInstant(@NotNull TimestampFormat format) {
        Intrinsics.checkNotNullParameter((Object)format, (String)"format");
        return this.$$delegate_0.deserializeInstant(format);
    }

    public /* synthetic */ CborEntryIterator(SdkBufferedSource buffer, ULong expectedLength, DefaultConstructorMarker $constructor_marker) {
        this(buffer, expectedLength);
    }
}

