/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0
 */
package aws.smithy.kotlin.runtime.hashing

import aws.smithy.kotlin.runtime.InternalApi
import java.util.zip.CRC32

@InternalApi
public actual class Crc32 : Crc32Base() {
    private val md = CRC32()

    actual override fun update(input: ByteArray, offset: Int, length: Int): Unit = md.update(input, offset, length)

    actual override fun digestValue(): UInt = md.value.toUInt()

    actual override fun reset(): Unit = md.reset()
}
