/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0
 */
package aws.smithy.kotlin.runtime.content

/**
 * Container for wrapping a ByteArray as a [ByteStream]
 */
internal class ByteArrayContent(private val bytes: ByteArray) : ByteStream.Buffer() {
    override val contentLength: Long = bytes.size.toLong()
    override fun bytes(): ByteArray = bytes
}
