/*
 * Decompiled with CFR 0.152.
 */
package aws.smithy.kotlin.runtime.util;

import aws.smithy.kotlin.runtime.util.Filesystem;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0010\u0012\n\u0002\b\b\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001B!\u0012\u0012\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0007J\u001b\u0010\n\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u000b\u001a\u00020\u0004H\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\fJ!\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000b\u001a\u00020\u00042\u0006\u0010\u000f\u001a\u00020\u0005H\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0010R\u0014\u0010\u0006\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u001a\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006\u0011"}, d2={"Laws/smithy/kotlin/runtime/util/MapFilesystem;", "Laws/smithy/kotlin/runtime/util/Filesystem;", "memFs", "", "", "", "filePathSeparator", "(Ljava/util/Map;Ljava/lang/String;)V", "getFilePathSeparator", "()Ljava/lang/String;", "readFileOrNull", "path", "(Ljava/lang/String;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "writeFile", "", "data", "(Ljava/lang/String;[BLkotlin/coroutines/Continuation;)Ljava/lang/Object;", "runtime-core"})
public final class MapFilesystem
implements Filesystem {
    @NotNull
    private final Map<String, byte[]> memFs;
    @NotNull
    private final String filePathSeparator;

    public MapFilesystem(@NotNull Map<String, byte[]> memFs, @NotNull String filePathSeparator2) {
        Intrinsics.checkNotNullParameter(memFs, (String)"memFs");
        Intrinsics.checkNotNullParameter((Object)filePathSeparator2, (String)"filePathSeparator");
        this.memFs = memFs;
        this.filePathSeparator = filePathSeparator2;
    }

    @Override
    @NotNull
    public String getFilePathSeparator() {
        return this.filePathSeparator;
    }

    @Override
    @Nullable
    public Object readFileOrNull(@NotNull String path, @NotNull Continuation<? super byte[]> $completion) {
        return this.memFs.get(path);
    }

    @Override
    @Nullable
    public Object writeFile(@NotNull String path, @NotNull byte[] data, @NotNull Continuation<? super Unit> $completion) {
        this.memFs.put(path, data);
        return Unit.INSTANCE;
    }
}

