/*
 * Decompiled with CFR 0.152.
 */
package aws.smithy.kotlin.runtime.util;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntProgression;
import kotlin.ranges.RangesKt;
import kotlin.text.CharsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u0000\u0016\n\u0000\n\u0002\u0010\u0019\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\u001a\u000e\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005\u001a\u000e\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\u0003\u001a\n\u0010\b\u001a\u00020\u0003*\u00020\u0005\u001a\n\u0010\t\u001a\u00020\u0005*\u00020\u0003\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"hexChars", "", "decodeHex", "", "s", "", "encodeHex", "bytes", "decodeHexBytes", "encodeToHex", "runtime-core"})
public final class HexKt {
    @NotNull
    private static final char[] hexChars;

    @NotNull
    public static final String encodeHex(@NotNull byte[] bytes) {
        StringBuilder stringBuilder;
        Intrinsics.checkNotNullParameter((Object)bytes, (String)"bytes");
        int n = bytes.length * 2;
        StringBuilder $this$encodeHex_u24lambda_u240 = stringBuilder = new StringBuilder(n);
        boolean bl = false;
        int n2 = bytes.length;
        for (int i = 0; i < n2; ++i) {
            int n3 = bytes[i] & 0xFF;
            $this$encodeHex_u24lambda_u240.append(hexChars[n3 >> 4]);
            $this$encodeHex_u24lambda_u240.append(hexChars[n3 & 0xF]);
        }
        String string = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"StringBuilder(capacity).\u2026builderAction).toString()");
        return string;
    }

    @NotNull
    public static final String encodeToHex(@NotNull byte[] $this$encodeToHex) {
        Intrinsics.checkNotNullParameter((Object)$this$encodeToHex, (String)"<this>");
        return HexKt.encodeHex($this$encodeToHex);
    }

    @NotNull
    public static final byte[] decodeHex(@NotNull String s) {
        Intrinsics.checkNotNullParameter((Object)s, (String)"s");
        byte[] result = new byte[(s.length() + 1) / 2];
        int start = 0;
        int writeIdx = 0;
        if (s.length() % 2 == 1) {
            result[writeIdx++] = (byte)CharsKt.digitToInt((char)s.charAt(0), (int)16);
            start = writeIdx;
        }
        IntProgression intProgression = RangesKt.step((IntProgression)((IntProgression)RangesKt.until((int)start, (int)s.length())), (int)2);
        int i = intProgression.getFirst();
        int n = intProgression.getLast();
        int n2 = intProgression.getStep();
        if (n2 > 0 && i <= n || n2 < 0 && n <= i) {
            while (true) {
                int high = CharsKt.digitToInt((char)s.charAt(i), (int)16) << 4;
                int low = CharsKt.digitToInt((char)s.charAt(i + 1), (int)16);
                result[writeIdx++] = (byte)(high | low);
                if (i == n) break;
                i += n2;
            }
        }
        return result;
    }

    @NotNull
    public static final byte[] decodeHexBytes(@NotNull String $this$decodeHexBytes) {
        Intrinsics.checkNotNullParameter((Object)$this$decodeHexBytes, (String)"<this>");
        return HexKt.decodeHex($this$decodeHexBytes);
    }

    static {
        char[] cArray = "0123456789abcdef".toCharArray();
        Intrinsics.checkNotNullExpressionValue((Object)cArray, (String)"this as java.lang.String).toCharArray()");
        hexChars = cArray;
    }
}

