/*
 * Decompiled with CFR 0.152.
 */
package aws.smithy.kotlin.runtime.util;

import kotlin.Metadata;
import kotlin.internal.ProgressionUtilKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u0000,\n\u0000\n\u0002\u0010\u0015\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\f\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0002\b\u0007\n\u0002\u0010\u0005\n\u0002\b\u0006\u001a\u0010\u0010\b\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\nH\u0002\u001a\u0010\u0010\u000b\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\u0007H\u0002\u001a\n\u0010\r\u001a\u00020\n*\u00020\n\u001a\n\u0010\r\u001a\u00020\u0003*\u00020\u0003\u001a\n\u0010\u000e\u001a\u00020\n*\u00020\u0003\u001a\n\u0010\u000f\u001a\u00020\n*\u00020\n\u001a\n\u0010\u000f\u001a\u00020\u0003*\u00020\u0003\u001a\n\u0010\u0010\u001a\u00020\u0003*\u00020\n\u001a\f\u0010\u0011\u001a\u00020\u0007*\u00020\u0012H\u0002\u001a%\u0010\u0013\u001a\u00020\u0007*\u00020\n2\u0006\u0010\u0014\u001a\u00020\u00072\n\b\u0002\u0010\u0015\u001a\u0004\u0018\u00010\u0007H\u0002\u00a2\u0006\u0002\u0010\u0016\u001a\f\u0010\u0017\u001a\u00020\u0012*\u00020\u0007H\u0002\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0003X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0006\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"BASE64_DECODE_TABLE", "", "BASE64_ENCODE_TABLE", "", "BASE64_PAD", "", "BASE64_PAD_SENTINEL", "", "base64DecodedLen", "encoded", "", "base64EncodedLen", "srcLen", "decodeBase64", "decodeBase64Bytes", "encodeBase64", "encodeBase64String", "fromBase64", "", "getOrZero", "index", "mask", "([BILjava/lang/Integer;)I", "toBase64", "runtime-core"})
public final class Base64Kt {
    @NotNull
    private static final String BASE64_ENCODE_TABLE = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/";
    private static final int BASE64_PAD_SENTINEL = 255;
    private static final char BASE64_PAD = '=';
    @NotNull
    private static final int[] BASE64_DECODE_TABLE;

    private static final int base64EncodedLen(int srcLen) {
        return 4 * ((srcLen + 2) / 3);
    }

    private static final int base64DecodedLen(byte[] encoded) {
        if (encoded.length == 0) {
            return 0;
        }
        int len = encoded.length;
        if ((len & 3) != 0) {
            throw new IllegalArgumentException("invalid base64 string of length " + len + "; not a multiple of 4");
        }
        int padding = 0;
        if (len >= 2 && encoded[len - 1] == 61 && encoded[len - 2] == 61) {
            padding = 2;
        } else if (encoded[len - 1] == 61) {
            padding = 1;
        }
        return len * 3 / 4 - padding;
    }

    @NotNull
    public static final String encodeBase64(@NotNull String $this$encodeBase64) {
        Intrinsics.checkNotNullParameter((Object)$this$encodeBase64, (String)"<this>");
        return StringsKt.decodeToString((byte[])Base64Kt.encodeBase64(StringsKt.encodeToByteArray((String)$this$encodeBase64)));
    }

    @NotNull
    public static final String encodeBase64String(@NotNull byte[] $this$encodeBase64String) {
        Intrinsics.checkNotNullParameter((Object)$this$encodeBase64String, (String)"<this>");
        return StringsKt.decodeToString((byte[])Base64Kt.encodeBase64($this$encodeBase64String));
    }

    @NotNull
    public static final byte[] encodeBase64(@NotNull byte[] $this$encodeBase64) {
        Intrinsics.checkNotNullParameter((Object)$this$encodeBase64, (String)"<this>");
        byte[] output = new byte[Base64Kt.base64EncodedLen($this$encodeBase64.length)];
        int remainderCnt = $this$encodeBase64.length % 3;
        int blockCnt = ($this$encodeBase64.length + 2) / 3;
        int writeIdx = 0;
        int n = $this$encodeBase64.length + -1;
        int i = 0;
        int n2 = ProgressionUtilKt.getProgressionLastElement((int)0, (int)n, (int)3);
        if (i <= n2) {
            while (true) {
                int block = Base64Kt.getOrZero($this$encodeBase64, i, 255) << 16 | Base64Kt.getOrZero($this$encodeBase64, i + 1, 255) << 8 | Base64Kt.getOrZero($this$encodeBase64, i + 2, 255);
                output[writeIdx++] = Base64Kt.toBase64(block >> 18 & 0x3F);
                output[writeIdx++] = Base64Kt.toBase64(block >> 12 & 0x3F);
                output[writeIdx++] = Base64Kt.toBase64(block >> 6 & 0x3F);
                output[writeIdx++] = Base64Kt.toBase64(block & 0x3F);
                if (i == n2) break;
                i += 3;
            }
        }
        if (remainderCnt > 0) {
            output[blockCnt * 4 - 1] = 61;
            if (remainderCnt == 1) {
                output[blockCnt * 4 - 2] = 61;
            }
        }
        return output;
    }

    @NotNull
    public static final String decodeBase64(@NotNull String $this$decodeBase64) {
        Intrinsics.checkNotNullParameter((Object)$this$decodeBase64, (String)"<this>");
        return StringsKt.decodeToString((byte[])Base64Kt.decodeBase64Bytes($this$decodeBase64));
    }

    @NotNull
    public static final byte[] decodeBase64Bytes(@NotNull String $this$decodeBase64Bytes) {
        Intrinsics.checkNotNullParameter((Object)$this$decodeBase64Bytes, (String)"<this>");
        return Base64Kt.decodeBase64(StringsKt.encodeToByteArray((String)$this$decodeBase64Bytes));
    }

    @NotNull
    public static final byte[] decodeBase64(@NotNull byte[] $this$decodeBase64) {
        Intrinsics.checkNotNullParameter((Object)$this$decodeBase64, (String)"<this>");
        byte[] encoded = $this$decodeBase64;
        int decodedLen = Base64Kt.base64DecodedLen(encoded);
        byte[] decoded = new byte[decodedLen];
        int blockCnt = $this$decodeBase64.length / 4;
        int readIdx = 0;
        int writeIdx = 0;
        int n = blockCnt - 1;
        for (int i = 0; i < n; ++i) {
            int block = Base64Kt.fromBase64(encoded[readIdx++]) << 18 | Base64Kt.fromBase64(encoded[readIdx++]) << 12 | Base64Kt.fromBase64(encoded[readIdx++]) << 6 | Base64Kt.fromBase64(encoded[readIdx++]) & 0xFF;
            for (int j = 2; -1 < j; --j) {
                decoded[writeIdx++] = (byte)(block >> j * 8 & 0xFF);
            }
        }
        int bufIdx = (blockCnt - 1) * 3;
        if (bufIdx >= 0) {
            int v1 = Base64Kt.fromBase64(encoded[readIdx++]);
            int v2 = Base64Kt.fromBase64(encoded[readIdx++]);
            int v3 = Base64Kt.fromBase64(encoded[readIdx++]);
            int v4 = Base64Kt.fromBase64(encoded[readIdx]);
            if (v1 == 255 || v2 == 255) {
                throw new IllegalArgumentException("decode base64: invalid padding");
            }
            decoded[writeIdx++] = (byte)(v1 << 2 | v2 >> 4 & 3);
            if (v3 != 255) {
                decoded[writeIdx++] = (byte)(v2 << 4 & 0xF0 | v3 >> 2 & 0xF);
            }
            if (v4 != 255) {
                decoded[writeIdx] = (byte)((v3 & 3) << 6 | v4);
            }
        }
        return decoded;
    }

    private static final byte toBase64(int $this$toBase64) {
        return (byte)BASE64_ENCODE_TABLE.charAt($this$toBase64);
    }

    /*
     * WARNING - void declaration
     */
    private static final int getOrZero(byte[] $this$getOrZero, int index, Integer mask) {
        int n;
        if (index >= $this$getOrZero.length) {
            n = 0;
        } else {
            void var3_3;
            int tmp = $this$getOrZero[index];
            if (mask != null) {
                tmp &= mask.intValue();
            }
            n = var3_3;
        }
        return n;
    }

    static /* synthetic */ int getOrZero$default(byte[] byArray, int n, Integer n2, int n3, Object object) {
        if ((n3 & 2) != 0) {
            n2 = null;
        }
        return Base64Kt.getOrZero(byArray, n, n2);
    }

    private static final int fromBase64(byte $this$fromBase64) {
        int decoded = BASE64_DECODE_TABLE[$this$fromBase64];
        if (decoded == -1) {
            throw new IllegalArgumentException("decode base64: invalid input byte: " + $this$fromBase64);
        }
        return decoded;
    }

    static {
        int[] nArray = new int[256];
        for (int i = 0; i < 256; ++i) {
            int n = i;
            nArray[n] = n == 61 ? 255 : StringsKt.indexOf$default((CharSequence)BASE64_ENCODE_TABLE, (char)((char)n), (int)0, (boolean)false, (int)6, null);
        }
        BASE64_DECODE_TABLE = nArray;
    }
}

