/*
 * Decompiled with CFR 0.152.
 */
package aws.smithy.kotlin.runtime.util;

import aws.smithy.kotlin.runtime.util.AttributeKey;
import aws.smithy.kotlin.runtime.util.Attributes;
import aws.smithy.kotlin.runtime.util.AttributesKt;
import aws.smithy.kotlin.runtime.util.MutableAttributes;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0010\u0000\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0004\b\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0016\u00a2\u0006\u0002\u0010\u0002B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J3\u0010\u000e\u001a\u0002H\u000f\"\b\b\u0000\u0010\u000f*\u00020\r2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u0002H\u000f0\b2\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u0002H\u000f0\u0012H\u0016\u00a2\u0006\u0002\u0010\u0013J\u0015\u0010\u0014\u001a\u00020\u00152\n\u0010\u0010\u001a\u0006\u0012\u0002\b\u00030\bH\u0096\u0002J'\u0010\u0016\u001a\u0004\u0018\u0001H\u000f\"\b\b\u0000\u0010\u000f*\u00020\r2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u0002H\u000f0\bH\u0016\u00a2\u0006\u0002\u0010\u0017J \u0010\u0018\u001a\u00020\u0019\"\b\b\u0000\u0010\u000f*\u00020\r2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u0002H\u000f0\bH\u0016J.\u0010\u001a\u001a\u00020\u0019\"\b\b\u0000\u0010\u000f*\u00020\r2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u0002H\u000f0\b2\u0006\u0010\u001b\u001a\u0002H\u000fH\u0096\u0002\u00a2\u0006\u0002\u0010\u001cR\u001e\u0010\u0006\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\b0\u00078VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u001e\u0010\u000b\u001a\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030\b\u0012\u0004\u0012\u00020\r0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Laws/smithy/kotlin/runtime/util/AttributesImpl;", "Laws/smithy/kotlin/runtime/util/MutableAttributes;", "()V", "seed", "Laws/smithy/kotlin/runtime/util/Attributes;", "(Laws/smithy/kotlin/runtime/util/Attributes;)V", "keys", "", "Laws/smithy/kotlin/runtime/util/AttributeKey;", "getKeys", "()Ljava/util/Set;", "map", "", "", "computeIfAbsent", "T", "key", "block", "Lkotlin/Function0;", "(Laws/smithy/kotlin/runtime/util/AttributeKey;Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "contains", "", "getOrNull", "(Laws/smithy/kotlin/runtime/util/AttributeKey;)Ljava/lang/Object;", "remove", "", "set", "value", "(Laws/smithy/kotlin/runtime/util/AttributeKey;Ljava/lang/Object;)V", "runtime-core"})
final class AttributesImpl
implements MutableAttributes {
    @NotNull
    private final Map<AttributeKey<?>, Object> map;

    public AttributesImpl(@NotNull Attributes seed) {
        Intrinsics.checkNotNullParameter((Object)seed, (String)"seed");
        this.map = new LinkedHashMap();
        AttributesKt.merge(this, seed);
    }

    public AttributesImpl() {
        this(AttributesKt.emptyAttributes());
    }

    @Override
    @Nullable
    public <T> T getOrNull(@NotNull AttributeKey<T> key) {
        Intrinsics.checkNotNullParameter(key, (String)"key");
        return (T)this.map.get(key);
    }

    @Override
    public boolean contains(@NotNull AttributeKey<?> key) {
        Intrinsics.checkNotNullParameter(key, (String)"key");
        return this.map.containsKey(key);
    }

    @Override
    public <T> void set(@NotNull AttributeKey<T> key, @NotNull T value) {
        Intrinsics.checkNotNullParameter(key, (String)"key");
        Intrinsics.checkNotNullParameter(value, (String)"value");
        this.map.put(key, value);
    }

    @Override
    public <T> void remove(@NotNull AttributeKey<T> key) {
        Intrinsics.checkNotNullParameter(key, (String)"key");
        this.map.remove(key);
    }

    @Override
    @NotNull
    public <T> T computeIfAbsent(@NotNull AttributeKey<T> key, @NotNull Function0<? extends T> block) {
        Intrinsics.checkNotNullParameter(key, (String)"key");
        Intrinsics.checkNotNullParameter(block, (String)"block");
        T value = this.getOrNull(key);
        if (value != null) {
            return value;
        }
        Object result = block.invoke();
        this.map.put(key, result);
        return (T)result;
    }

    @Override
    @NotNull
    public Set<AttributeKey<?>> getKeys() {
        return this.map.keySet();
    }
}

