/*
 * Decompiled with CFR 0.152.
 */
package aws.smithy.kotlin.runtime.retries.delay;

import aws.smithy.kotlin.runtime.InternalApi;
import aws.smithy.kotlin.runtime.retries.delay.RetryCapacityExceededException;
import aws.smithy.kotlin.runtime.retries.delay.RetryToken;
import aws.smithy.kotlin.runtime.retries.delay.RetryTokenBucket;
import aws.smithy.kotlin.runtime.retries.delay.StandardRetryTokenBucket;
import aws.smithy.kotlin.runtime.retries.policy.RetryErrorType;
import aws.smithy.kotlin.runtime.util.DslFactory;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.time.Duration;
import kotlin.time.DurationKt;
import kotlin.time.DurationUnit;
import kotlin.time.TimeMark;
import kotlin.time.TimeSource;
import kotlinx.coroutines.DelayKt;
import kotlinx.coroutines.sync.Mutex;
import kotlinx.coroutines.sync.MutexKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\b\u0018\u0000 \u001d2\u00020\u0001:\u0003\u001d\u001e\u001fB\u0011\b\u0016\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\u0017\b\u0000\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0011\u0010\u0014\u001a\u00020\u0015H\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0016J\u0019\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\nH\u0082@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u001aJ\b\u0010\u001b\u001a\u00020\u0018H\u0002J\u0019\u0010\u001c\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\nH\u0082@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u001aR\u001e\u0010\u000b\u001a\u00020\n2\u0006\u0010\t\u001a\u00020\n@BX\u0080\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0014\u0010\u0005\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006 "}, d2={"Laws/smithy/kotlin/runtime/retries/delay/StandardRetryTokenBucket;", "Laws/smithy/kotlin/runtime/retries/delay/RetryTokenBucket;", "options", "Laws/smithy/kotlin/runtime/retries/delay/StandardRetryTokenBucket$Config;", "(Laws/smithy/kotlin/runtime/retries/delay/StandardRetryTokenBucket$Config;)V", "config", "timeSource", "Lkotlin/time/TimeSource;", "(Laws/smithy/kotlin/runtime/retries/delay/StandardRetryTokenBucket$Config;Lkotlin/time/TimeSource;)V", "<set-?>", "", "capacity", "getCapacity$runtime_core", "()I", "getConfig", "()Laws/smithy/kotlin/runtime/retries/delay/StandardRetryTokenBucket$Config;", "lastTimeMark", "Lkotlin/time/TimeMark;", "mutex", "Lkotlinx/coroutines/sync/Mutex;", "acquireToken", "Laws/smithy/kotlin/runtime/retries/delay/RetryToken;", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "checkoutCapacity", "", "size", "(ILkotlin/coroutines/Continuation;)Ljava/lang/Object;", "refillCapacity", "returnCapacity", "Companion", "Config", "StandardRetryToken", "runtime-core"})
@SourceDebugExtension(value={"SMAP\nStandardRetryTokenBucket.kt\nKotlin\n*S Kotlin\n*F\n+ 1 StandardRetryTokenBucket.kt\naws/smithy/kotlin/runtime/retries/delay/StandardRetryTokenBucket\n+ 2 Mutex.kt\nkotlinx/coroutines/sync/MutexKt\n*L\n1#1,239:1\n107#2,10:240\n107#2,10:250\n*S KotlinDebug\n*F\n+ 1 StandardRetryTokenBucket.kt\naws/smithy/kotlin/runtime/retries/delay/StandardRetryTokenBucket\n*L\n58#1:240,10\n83#1:250,10\n*E\n"})
public final class StandardRetryTokenBucket
implements RetryTokenBucket {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Config config;
    @NotNull
    private final TimeSource timeSource;
    private int capacity;
    @NotNull
    private TimeMark lastTimeMark;
    @NotNull
    private final Mutex mutex;

    public StandardRetryTokenBucket(@NotNull Config config2, @NotNull TimeSource timeSource) {
        Intrinsics.checkNotNullParameter((Object)config2, (String)"config");
        Intrinsics.checkNotNullParameter((Object)timeSource, (String)"timeSource");
        this.config = config2;
        this.timeSource = timeSource;
        this.capacity = this.getConfig().getMaxCapacity();
        this.lastTimeMark = this.timeSource.markNow();
        this.mutex = MutexKt.Mutex$default((boolean)false, (int)1, null);
    }

    @Override
    @NotNull
    public Config getConfig() {
        return this.config;
    }

    public StandardRetryTokenBucket(@NotNull Config options) {
        Intrinsics.checkNotNullParameter((Object)options, (String)"options");
        this(options, (TimeSource)TimeSource.Monotonic.INSTANCE);
    }

    public /* synthetic */ StandardRetryTokenBucket(Config config2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            config2 = Config.Companion.getDefault();
        }
        this(config2);
    }

    public final int getCapacity$runtime_core() {
        return this.capacity;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    @Nullable
    public Object acquireToken(@NotNull Continuation<? super RetryToken> var1_1) {
        if (!(var1_1 instanceof acquireToken.1)) ** GOTO lbl-1000
        var3_2 = var1_1;
        if ((var3_2.label & -2147483648) != 0) {
            var3_2.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, var1_1){
                Object L$0;
                /* synthetic */ Object result;
                final /* synthetic */ StandardRetryTokenBucket this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.acquireToken((Continuation<? super RetryToken>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var4_4 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                $continuation.L$0 = this;
                $continuation.label = 1;
                v0 = this.checkoutCapacity(this.getConfig().getInitialTryCost(), (Continuation<? super Unit>)$continuation);
                if (v0 == var4_4) {
                    return var4_4;
                }
                ** GOTO lbl22
            }
            case 1: {
                this = (StandardRetryTokenBucket)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl22:
                // 2 sources

                return new StandardRetryToken(this.getConfig().getInitialTrySuccessIncrement());
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private final Object checkoutCapacity(int var1_1, Continuation<? super Unit> var2_2) {
        if (!(var2_2 instanceof checkoutCapacity.1)) ** GOTO lbl-1000
        var12_3 = var2_2;
        if ((var12_3.label & -2147483648) != 0) {
            var12_3.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, var2_2){
                Object L$0;
                Object L$1;
                int I$0;
                /* synthetic */ Object result;
                final /* synthetic */ StandardRetryTokenBucket this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return StandardRetryTokenBucket.access$checkoutCapacity(this.this$0, 0, (Continuation)this);
                }
            };
        }
        $result = $continuation.result;
        var13_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                $this$withLock_u24default$iv = this.mutex;
                owner$iv = null;
                $i$f$withLock = false;
                $continuation.L$0 = this;
                $continuation.L$1 = $this$withLock_u24default$iv;
                $continuation.I$0 = size;
                $continuation.label = 1;
                v0 = $this$withLock_u24default$iv.lock(owner$iv, (Continuation)$continuation);
                if (v0 == var13_5) {
                    return var13_5;
                }
                ** GOTO lbl33
            }
            case 1: {
                $i$f$withLock = false;
                size = $continuation.I$0;
                owner$iv = null;
                $this$withLock_u24default$iv = (Mutex)$continuation.L$1;
                this = (StandardRetryTokenBucket)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl33:
                // 3 sources

                $i$a$-withLock$default-StandardRetryTokenBucket$checkoutCapacity$2 = false;
                this.refillCapacity();
                if (size > this.capacity) ** GOTO lbl39
                this.capacity -= size;
                ** GOTO lbl62
lbl39:
                // 1 sources

                if (this.getConfig().getUseCircuitBreakerMode()) {
                    throw new RetryCapacityExceededException("Insufficient capacity to attempt another retry");
                }
                extraRequiredCapacity = size - this.capacity;
                delayDuration = DurationKt.toDuration((double)Math.ceil((double)extraRequiredCapacity / (double)this.getConfig().getRefillUnitsPerSecond()), (DurationUnit)DurationUnit.SECONDS);
                $continuation.L$0 = this;
                $continuation.L$1 = $this$withLock_u24default$iv;
                $continuation.label = 2;
                v1 = DelayKt.delay-VtjQ1oo((long)delayDuration, (Continuation)$continuation);
                ** if (v1 != var13_5) goto lbl50
lbl49:
                // 1 sources

                return var13_5;
lbl50:
                // 1 sources

                ** GOTO lbl61
            }
            case 2: {
                $i$f$withLock = false;
                $i$a$-withLock$default-StandardRetryTokenBucket$checkoutCapacity$2 = false;
                owner$iv = null;
                $this$withLock_u24default$iv = (Mutex)$continuation.L$1;
                this = (StandardRetryTokenBucket)$continuation.L$0;
                try {
                    ResultKt.throwOnFailure((Object)$result);
                    v1 = $result;
lbl61:
                    // 2 sources

                    this.capacity = 0;
lbl62:
                    // 2 sources

                    this.lastTimeMark = this.timeSource.markNow();
                    var10_15 = Unit.INSTANCE;
                }
                catch (Throwable var10_16) {
                    throw var10_16;
                }
                finally {
                    $this$withLock_u24default$iv.unlock(owner$iv);
                }
                return Unit.INSTANCE;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    private final void refillCapacity() {
        double refillSeconds = Duration.toDouble-impl((long)this.lastTimeMark.elapsedNow-UwyO8pc(), (DurationUnit)DurationUnit.SECONDS);
        int refillSize = (int)Math.floor((double)this.getConfig().getRefillUnitsPerSecond() * refillSeconds);
        this.capacity = Math.min(this.getConfig().getMaxCapacity(), this.capacity + refillSize);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private final Object returnCapacity(int var1_1, Continuation<? super Unit> var2_2) {
        if (!(var2_2 instanceof returnCapacity.1)) ** GOTO lbl-1000
        var9_3 = var2_2;
        if ((var9_3.label & -2147483648) != 0) {
            var9_3.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, var2_2){
                Object L$0;
                Object L$1;
                int I$0;
                /* synthetic */ Object result;
                final /* synthetic */ StandardRetryTokenBucket this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return StandardRetryTokenBucket.access$returnCapacity(this.this$0, 0, (Continuation)this);
                }
            };
        }
        $result = $continuation.result;
        var10_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                $this$withLock_u24default$iv = this.mutex;
                owner$iv = null;
                $i$f$withLock = false;
                $continuation.L$0 = this;
                $continuation.L$1 = $this$withLock_u24default$iv;
                $continuation.I$0 = size;
                $continuation.label = 1;
                v0 = $this$withLock_u24default$iv.lock(owner$iv, (Continuation)$continuation);
                if (v0 == var10_5) {
                    return var10_5;
                }
                ** GOTO lbl32
            }
            case 1: {
                $i$f$withLock = false;
                size = $continuation.I$0;
                owner$iv = null;
                $this$withLock_u24default$iv = (Mutex)$continuation.L$1;
                this = (StandardRetryTokenBucket)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl32:
                // 2 sources

                try {
                    $i$a$-withLock$default-StandardRetryTokenBucket$returnCapacity$2 = false;
                    this.refillCapacity();
                    this.capacity = Math.min(this.getConfig().getMaxCapacity(), this.capacity + size);
                    this.lastTimeMark = this.timeSource.markNow();
                    var7_11 = Unit.INSTANCE;
                }
                finally {
                    $this$withLock_u24default$iv.unlock(owner$iv);
                }
                return Unit.INSTANCE;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    public static final /* synthetic */ Object access$checkoutCapacity(StandardRetryTokenBucket $this, int size, Continuation $completion) {
        return $this.checkoutCapacity(size, (Continuation<? super Unit>)$completion);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0004J\"\u0010\u0005\u001a\u00020\u00032\u0017\u0010\u0006\u001a\u0013\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\u0002\b\tH\u0096\u0002\u00a8\u0006\n"}, d2={"Laws/smithy/kotlin/runtime/retries/delay/StandardRetryTokenBucket$Companion;", "Laws/smithy/kotlin/runtime/util/DslFactory;", "Laws/smithy/kotlin/runtime/retries/delay/StandardRetryTokenBucket$Config$Builder;", "Laws/smithy/kotlin/runtime/retries/delay/StandardRetryTokenBucket;", "()V", "invoke", "block", "Lkotlin/Function1;", "", "Lkotlin/ExtensionFunctionType;", "runtime-core"})
    public static final class Companion
    implements DslFactory<Config.Builder, StandardRetryTokenBucket> {
        private Companion() {
        }

        @Override
        @NotNull
        public StandardRetryTokenBucket invoke(@NotNull Function1<? super Config.Builder, Unit> block) {
            Intrinsics.checkNotNullParameter(block, (String)"block");
            Config.Builder builder = new Config.Builder();
            block.invoke((Object)builder);
            return new StandardRetryTokenBucket(new Config(builder));
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\r\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u001d2\u00020\u0001:\u0002\u001c\u001dB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0019\u0010\u0017\u001a\u0013\u0012\u0004\u0012\u00020\u0019\u0012\u0004\u0012\u00020\u001a0\u0018\u00a2\u0006\u0002\b\u001bH\u0017R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\t\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\bR\u0011\u0010\u000b\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\bR\u0011\u0010\r\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\bR\u0011\u0010\u000f\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\bR\u0011\u0010\u0011\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\bR\u0011\u0010\u0013\u001a\u00020\u0014\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016\u00a8\u0006\u001e"}, d2={"Laws/smithy/kotlin/runtime/retries/delay/StandardRetryTokenBucket$Config;", "Laws/smithy/kotlin/runtime/retries/delay/RetryTokenBucket$Config;", "builder", "Laws/smithy/kotlin/runtime/retries/delay/StandardRetryTokenBucket$Config$Builder;", "(Laws/smithy/kotlin/runtime/retries/delay/StandardRetryTokenBucket$Config$Builder;)V", "initialTryCost", "", "getInitialTryCost", "()I", "initialTrySuccessIncrement", "getInitialTrySuccessIncrement", "maxCapacity", "getMaxCapacity", "refillUnitsPerSecond", "getRefillUnitsPerSecond", "retryCost", "getRetryCost", "timeoutRetryCost", "getTimeoutRetryCost", "useCircuitBreakerMode", "", "getUseCircuitBreakerMode", "()Z", "toBuilderApplicator", "Lkotlin/Function1;", "Laws/smithy/kotlin/runtime/retries/delay/RetryTokenBucket$Config$Builder;", "", "Lkotlin/ExtensionFunctionType;", "Builder", "Companion", "runtime-core"})
    public static final class Config
    implements RetryTokenBucket.Config {
        @NotNull
        public static final Companion Companion = new Companion(null);
        private final boolean useCircuitBreakerMode;
        private final int initialTryCost;
        private final int initialTrySuccessIncrement;
        private final int maxCapacity;
        private final int refillUnitsPerSecond;
        private final int retryCost;
        private final int timeoutRetryCost;
        @NotNull
        private static final Config Default = new Config(new Builder());

        public Config(@NotNull Builder builder) {
            Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
            this.useCircuitBreakerMode = builder.getUseCircuitBreakerMode();
            this.initialTryCost = builder.getInitialTryCost();
            this.initialTrySuccessIncrement = builder.getInitialTrySuccessIncrement();
            this.maxCapacity = builder.getMaxCapacity();
            this.refillUnitsPerSecond = builder.getRefillUnitsPerSecond();
            this.retryCost = builder.getRetryCost();
            this.timeoutRetryCost = builder.getTimeoutRetryCost();
        }

        public final boolean getUseCircuitBreakerMode() {
            return this.useCircuitBreakerMode;
        }

        public final int getInitialTryCost() {
            return this.initialTryCost;
        }

        public final int getInitialTrySuccessIncrement() {
            return this.initialTrySuccessIncrement;
        }

        public final int getMaxCapacity() {
            return this.maxCapacity;
        }

        public final int getRefillUnitsPerSecond() {
            return this.refillUnitsPerSecond;
        }

        public final int getRetryCost() {
            return this.retryCost;
        }

        public final int getTimeoutRetryCost() {
            return this.timeoutRetryCost;
        }

        @Override
        @InternalApi
        @NotNull
        public Function1<RetryTokenBucket.Config.Builder, Unit> toBuilderApplicator() {
            return (Function1)new Function1<RetryTokenBucket.Config.Builder, Unit>(this){
                final /* synthetic */ Config this$0;
                {
                    this.this$0 = $receiver;
                    super(1);
                }

                public final void invoke(@NotNull RetryTokenBucket.Config.Builder $this$null) {
                    Intrinsics.checkNotNullParameter((Object)$this$null, (String)"$this$null");
                    if ($this$null instanceof Builder) {
                        ((Builder)$this$null).setUseCircuitBreakerMode(this.this$0.getUseCircuitBreakerMode());
                        ((Builder)$this$null).setInitialTryCost(this.this$0.getInitialTryCost());
                        ((Builder)$this$null).setInitialTrySuccessIncrement(this.this$0.getInitialTrySuccessIncrement());
                        ((Builder)$this$null).setMaxCapacity(this.this$0.getMaxCapacity());
                        ((Builder)$this$null).setRefillUnitsPerSecond(this.this$0.getRefillUnitsPerSecond());
                        ((Builder)$this$null).setRetryCost(this.this$0.getRetryCost());
                        ((Builder)$this$null).setTimeoutRetryCost(this.this$0.getTimeoutRetryCost());
                    }
                }
            };
        }

        @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0015\n\u0002\u0010\u000b\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002R\u001a\u0010\u0003\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\bR\u001a\u0010\t\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u0006\"\u0004\b\u000b\u0010\bR\u001a\u0010\f\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u0006\"\u0004\b\u000e\u0010\bR$\u0010\u0010\u001a\u00020\u00042\u0006\u0010\u000f\u001a\u00020\u0004@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0006\"\u0004\b\u0012\u0010\bR\u001a\u0010\u0013\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u0006\"\u0004\b\u0015\u0010\bR\u001a\u0010\u0016\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u0006\"\u0004\b\u0018\u0010\bR\u001a\u0010\u0019\u001a\u00020\u001aX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001b\u0010\u001c\"\u0004\b\u001d\u0010\u001e\u00a8\u0006\u001f"}, d2={"Laws/smithy/kotlin/runtime/retries/delay/StandardRetryTokenBucket$Config$Builder;", "Laws/smithy/kotlin/runtime/retries/delay/RetryTokenBucket$Config$Builder;", "()V", "initialTryCost", "", "getInitialTryCost", "()I", "setInitialTryCost", "(I)V", "initialTrySuccessIncrement", "getInitialTrySuccessIncrement", "setInitialTrySuccessIncrement", "maxCapacity", "getMaxCapacity", "setMaxCapacity", "value", "refillUnitsPerSecond", "getRefillUnitsPerSecond", "setRefillUnitsPerSecond", "retryCost", "getRetryCost", "setRetryCost", "timeoutRetryCost", "getTimeoutRetryCost", "setTimeoutRetryCost", "useCircuitBreakerMode", "", "getUseCircuitBreakerMode", "()Z", "setUseCircuitBreakerMode", "(Z)V", "runtime-core"})
        public static final class Builder
        implements RetryTokenBucket.Config.Builder {
            private boolean useCircuitBreakerMode = true;
            private int initialTryCost;
            private int initialTrySuccessIncrement = 1;
            private int maxCapacity = 500;
            private int refillUnitsPerSecond;
            private int retryCost = 5;
            private int timeoutRetryCost = 10;

            public final boolean getUseCircuitBreakerMode() {
                return this.useCircuitBreakerMode;
            }

            public final void setUseCircuitBreakerMode(boolean bl) {
                this.useCircuitBreakerMode = bl;
            }

            public final int getInitialTryCost() {
                return this.initialTryCost;
            }

            public final void setInitialTryCost(int n) {
                this.initialTryCost = n;
            }

            public final int getInitialTrySuccessIncrement() {
                return this.initialTrySuccessIncrement;
            }

            public final void setInitialTrySuccessIncrement(int n) {
                this.initialTrySuccessIncrement = n;
            }

            public final int getMaxCapacity() {
                return this.maxCapacity;
            }

            public final void setMaxCapacity(int n) {
                this.maxCapacity = n;
            }

            public final int getRefillUnitsPerSecond() {
                return this.refillUnitsPerSecond;
            }

            public final void setRefillUnitsPerSecond(int value) {
                if (value == 0) {
                    this.useCircuitBreakerMode = true;
                }
                this.refillUnitsPerSecond = value;
            }

            public final int getRetryCost() {
                return this.retryCost;
            }

            public final void setRetryCost(int n) {
                this.retryCost = n;
            }

            public final int getTimeoutRetryCost() {
                return this.timeoutRetryCost;
            }

            public final void setTimeoutRetryCost(int n) {
                this.timeoutRetryCost = n;
            }
        }

        @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\"\u0010\u0007\u001a\u00020\u00042\u0017\u0010\b\u001a\u0013\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\t\u00a2\u0006\u0002\b\fH\u0086\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\r"}, d2={"Laws/smithy/kotlin/runtime/retries/delay/StandardRetryTokenBucket$Config$Companion;", "", "()V", "Default", "Laws/smithy/kotlin/runtime/retries/delay/StandardRetryTokenBucket$Config;", "getDefault", "()Laws/smithy/kotlin/runtime/retries/delay/StandardRetryTokenBucket$Config;", "invoke", "block", "Lkotlin/Function1;", "Laws/smithy/kotlin/runtime/retries/delay/StandardRetryTokenBucket$Config$Builder;", "", "Lkotlin/ExtensionFunctionType;", "runtime-core"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final Config getDefault() {
                return Default;
            }

            @NotNull
            public final Config invoke(@NotNull Function1<? super Builder, Unit> block) {
                Intrinsics.checkNotNullParameter(block, (String)"block");
                Builder builder = new Builder();
                block.invoke((Object)builder);
                return new Config(builder);
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0080\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0011\u0010\u0005\u001a\u00020\u0006H\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0007J\u0011\u0010\b\u001a\u00020\u0006H\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0007J\u0019\u0010\t\u001a\u00020\u00012\u0006\u0010\n\u001a\u00020\u000bH\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\fR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006\r"}, d2={"Laws/smithy/kotlin/runtime/retries/delay/StandardRetryTokenBucket$StandardRetryToken;", "Laws/smithy/kotlin/runtime/retries/delay/RetryToken;", "returnSize", "", "(Laws/smithy/kotlin/runtime/retries/delay/StandardRetryTokenBucket;I)V", "notifyFailure", "", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "notifySuccess", "scheduleRetry", "reason", "Laws/smithy/kotlin/runtime/retries/policy/RetryErrorType;", "(Laws/smithy/kotlin/runtime/retries/policy/RetryErrorType;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "runtime-core"})
    public final class StandardRetryToken
    implements RetryToken {
        private final int returnSize;

        public StandardRetryToken(int returnSize) {
            this.returnSize = returnSize;
        }

        @Override
        @Nullable
        public Object notifyFailure(@NotNull Continuation<? super Unit> $completion) {
            return Unit.INSTANCE;
        }

        @Override
        @Nullable
        public Object notifySuccess(@NotNull Continuation<? super Unit> $completion) {
            Object object = StandardRetryTokenBucket.this.returnCapacity(this.returnSize, (Continuation<? super Unit>)$completion);
            if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
                return object;
            }
            return Unit.INSTANCE;
        }

        /*
         * Unable to fully structure code
         */
        @Override
        @Nullable
        public Object scheduleRetry(@NotNull RetryErrorType var1_1, @NotNull Continuation<? super RetryToken> var2_2) {
            if (!(var2_2 instanceof scheduleRetry.1)) ** GOTO lbl-1000
            var6_3 = var2_2;
            if ((var6_3.label & -2147483648) != 0) {
                var6_3.label -= -2147483648;
            } else lbl-1000:
            // 2 sources

            {
                $continuation = new ContinuationImpl(this, var2_2){
                    Object L$0;
                    int I$0;
                    /* synthetic */ Object result;
                    final /* synthetic */ StandardRetryToken this$0;
                    int label;
                    {
                        this.this$0 = this$0;
                        super($completion);
                    }

                    @Nullable
                    public final Object invokeSuspend(@NotNull Object $result) {
                        this.result = $result;
                        this.label |= Integer.MIN_VALUE;
                        return this.this$0.scheduleRetry(null, (Continuation<? super RetryToken>)((Continuation)this));
                    }
                };
            }
            $result = $continuation.result;
            var7_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
            switch ($continuation.label) {
                case 0: {
                    ResultKt.throwOnFailure((Object)$result);
                    var4_6 = reason;
                    switch (WhenMappings.$EnumSwitchMapping$0[var4_6.ordinal()]) {
                        case 1: 
                        case 2: {
                            v0 = StandardRetryTokenBucket.this.getConfig().getTimeoutRetryCost();
                            break;
                        }
                        default: {
                            v0 = StandardRetryTokenBucket.this.getConfig().getRetryCost();
                        }
                    }
                    size = v0;
                    $continuation.L$0 = this;
                    $continuation.I$0 = size;
                    $continuation.label = 1;
                    v1 = StandardRetryTokenBucket.access$checkoutCapacity(StandardRetryTokenBucket.this, size, (Continuation)$continuation);
                    if (v1 == var7_5) {
                        return var7_5;
                    }
                    ** GOTO lbl32
                }
                case 1: {
                    size = $continuation.I$0;
                    this = (StandardRetryToken)$continuation.L$0;
                    ResultKt.throwOnFailure((Object)$result);
                    v1 = $result;
lbl32:
                    // 2 sources

                    return new StandardRetryToken(size);
                }
            }
            throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
        }

        @Metadata(mv={1, 8, 0}, k=3, xi=48)
        public final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;

            static {
                int[] nArray = new int[RetryErrorType.values().length];
                try {
                    nArray[RetryErrorType.Transient.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[RetryErrorType.Throttling.ordinal()] = 2;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                $EnumSwitchMapping$0 = nArray;
            }
        }
    }
}

