/*
 * Decompiled with CFR 0.152.
 */
package aws.smithy.kotlin.runtime.retries.delay;

import aws.smithy.kotlin.runtime.retries.delay.AdaptiveRateLimiter;
import aws.smithy.kotlin.runtime.retries.policy.RetryErrorType;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.time.Duration;
import kotlin.time.DurationUnit;
import kotlin.time.TimeMark;
import kotlin.time.TimeSource;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\n\b\u0000\u0018\u00002\u00020\u0001B+\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ \u0010\u001b\u001a\u00020\u00072\b\u0010\u001c\u001a\u0004\u0018\u00010\u001d2\u0006\u0010\u001e\u001a\u00020\u00072\u0006\u0010\u001f\u001a\u00020\u0007J\r\u0010 \u001a\u00020\u0007H\u0000\u00a2\u0006\u0002\b!J\r\u0010\"\u001a\u00020\u0007H\u0000\u00a2\u0006\u0002\b#J\u0015\u0010$\u001a\u00020\u00072\u0006\u0010%\u001a\u00020\u0007H\u0000\u00a2\u0006\u0002\b&R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0006\u001a\u00020\u0007X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\u001a\u0010\b\u001a\u00020\tX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012R\u001e\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u0013\u001a\u00020\u0014@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0018\u001a\u00020\u0007X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0019\u0010\f\"\u0004\b\u001a\u0010\u000e\u00a8\u0006'"}, d2={"Laws/smithy/kotlin/runtime/retries/delay/CubicRateCalculator;", "", "config", "Laws/smithy/kotlin/runtime/retries/delay/AdaptiveRateLimiter$Config;", "timeSource", "Lkotlin/time/TimeSource;", "lastMaxRate", "", "lastThrottleTime", "Lkotlin/time/TimeMark;", "(Laws/smithy/kotlin/runtime/retries/delay/AdaptiveRateLimiter$Config;Lkotlin/time/TimeSource;DLkotlin/time/TimeMark;)V", "getLastMaxRate$runtime_core", "()D", "setLastMaxRate$runtime_core", "(D)V", "getLastThrottleTime$runtime_core", "()Lkotlin/time/TimeMark;", "setLastThrottleTime$runtime_core", "(Lkotlin/time/TimeMark;)V", "<set-?>", "", "throttlingEnabled", "getThrottlingEnabled", "()Z", "timeWindow", "getTimeWindow$runtime_core", "setTimeWindow$runtime_core", "calculate", "errorType", "Laws/smithy/kotlin/runtime/retries/policy/RetryErrorType;", "measuredTxRate", "refillUnitsPerSecond", "calculateTimeWindow", "calculateTimeWindow$runtime_core", "cubicSuccess", "cubicSuccess$runtime_core", "cubicThrottle", "rate", "cubicThrottle$runtime_core", "runtime-core"})
public final class CubicRateCalculator {
    @NotNull
    private final AdaptiveRateLimiter.Config config;
    @NotNull
    private final TimeSource timeSource;
    private double lastMaxRate;
    @NotNull
    private TimeMark lastThrottleTime;
    private boolean throttlingEnabled;
    private double timeWindow;

    public CubicRateCalculator(@NotNull AdaptiveRateLimiter.Config config2, @NotNull TimeSource timeSource, double lastMaxRate, @NotNull TimeMark lastThrottleTime) {
        Intrinsics.checkNotNullParameter((Object)config2, (String)"config");
        Intrinsics.checkNotNullParameter((Object)timeSource, (String)"timeSource");
        Intrinsics.checkNotNullParameter((Object)lastThrottleTime, (String)"lastThrottleTime");
        this.config = config2;
        this.timeSource = timeSource;
        this.lastMaxRate = lastMaxRate;
        this.lastThrottleTime = lastThrottleTime;
        this.timeWindow = this.calculateTimeWindow$runtime_core();
    }

    public /* synthetic */ CubicRateCalculator(AdaptiveRateLimiter.Config config2, TimeSource timeSource, double d, TimeMark timeMark, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            timeSource = (TimeSource)TimeSource.Monotonic.INSTANCE;
        }
        if ((n & 4) != 0) {
            d = 0.0;
        }
        if ((n & 8) != 0) {
            timeMark = timeSource.markNow();
        }
        this(config2, timeSource, d, timeMark);
    }

    public final double getLastMaxRate$runtime_core() {
        return this.lastMaxRate;
    }

    public final void setLastMaxRate$runtime_core(double d) {
        this.lastMaxRate = d;
    }

    @NotNull
    public final TimeMark getLastThrottleTime$runtime_core() {
        return this.lastThrottleTime;
    }

    public final void setLastThrottleTime$runtime_core(@NotNull TimeMark timeMark) {
        Intrinsics.checkNotNullParameter((Object)timeMark, (String)"<set-?>");
        this.lastThrottleTime = timeMark;
    }

    public final boolean getThrottlingEnabled() {
        return this.throttlingEnabled;
    }

    public final double getTimeWindow$runtime_core() {
        return this.timeWindow;
    }

    public final void setTimeWindow$runtime_core(double d) {
        this.timeWindow = d;
    }

    public final double calculate(@Nullable RetryErrorType errorType, double measuredTxRate, double refillUnitsPerSecond) {
        double d;
        if (errorType == RetryErrorType.Throttling) {
            this.lastMaxRate = this.throttlingEnabled ? Math.min(measuredTxRate, refillUnitsPerSecond) : measuredTxRate;
            this.timeWindow = this.calculateTimeWindow$runtime_core();
            this.lastThrottleTime = this.timeSource.markNow();
            this.throttlingEnabled = true;
            d = this.cubicThrottle$runtime_core(this.lastMaxRate);
        } else {
            d = this.cubicSuccess$runtime_core();
        }
        double calculatedRate = d;
        return calculatedRate;
    }

    public final double calculateTimeWindow$runtime_core() {
        return Math.cbrt(this.lastMaxRate * (1.0 - this.config.getBeta()) / this.config.getScaleConstant());
    }

    public final double cubicSuccess$runtime_core() {
        double deltaSeconds = Duration.toDouble-impl((long)this.lastThrottleTime.elapsedNow-UwyO8pc(), (DurationUnit)DurationUnit.SECONDS);
        return this.config.getScaleConstant() * Math.pow(deltaSeconds - this.timeWindow, 3) + this.lastMaxRate;
    }

    public final double cubicThrottle$runtime_core(double rate) {
        return rate * this.config.getBeta();
    }
}

