/*
 * Decompiled with CFR 0.152.
 */
package aws.smithy.kotlin.runtime.net;

import aws.smithy.kotlin.runtime.net.Host;
import aws.smithy.kotlin.runtime.net.QueryParametersBuilder;
import aws.smithy.kotlin.runtime.net.Scheme;
import aws.smithy.kotlin.runtime.net.TextKt;
import aws.smithy.kotlin.runtime.net.Url;
import aws.smithy.kotlin.runtime.net.UrlBuilder;
import aws.smithy.kotlin.runtime.net.UrlKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntRange;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u00008\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u001a\u0010\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003H\u0000\u001a(\u0010\u0004\u001a\u00020\u0003*\u00020\u00032\u0006\u0010\u0005\u001a\u00020\u00062\u0012\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\t0\bH\u0002\u001a(\u0010\n\u001a\u00020\u0003*\u00020\u00032\u0006\u0010\u000b\u001a\u00020\u00032\u0012\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\t0\bH\u0002\u001a%\u0010\f\u001a\u00020\r*\u00020\u00032\u0012\u0010\u000b\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00030\u000e\"\u00020\u0003H\u0002\u00a2\u0006\u0002\u0010\u000f\u001a\u001a\u0010\u0010\u001a\u0010\u0012\u0004\u0012\u00020\u0012\u0012\u0006\u0012\u0004\u0018\u00010\r0\u0011*\u00020\u0003H\u0000\u00a8\u0006\u0013"}, d2={"urlParseImpl", "Laws/smithy/kotlin/runtime/net/Url;", "url", "", "capture", "range", "Lkotlin/ranges/IntRange;", "block", "Lkotlin/Function1;", "", "captureUntilAndSkip", "substring", "firstIndexOrEnd", "", "", "(Ljava/lang/String;[Ljava/lang/String;)I", "splitHostPort", "Lkotlin/Pair;", "Laws/smithy/kotlin/runtime/net/Host;", "runtime-core"})
@SourceDebugExtension(value={"SMAP\nUrlParser.kt\nKotlin\n*S Kotlin\n*F\n+ 1 UrlParser.kt\naws/smithy/kotlin/runtime/net/UrlParserKt\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,106:1\n11335#2:107\n11670#2,3:108\n766#3:111\n857#3,2:112\n1#4:114\n*S KotlinDebug\n*F\n+ 1 UrlParser.kt\naws/smithy/kotlin/runtime/net/UrlParserKt\n*L\n47#1:107\n47#1:108,3\n48#1:111\n48#1:112,2\n*E\n"})
public final class UrlParserKt {
    @NotNull
    public static final Url urlParseImpl(@NotNull String url) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        return UrlBuilder.Companion.invoke((Function1<? super UrlBuilder, Unit>)((Function1)new Function1<UrlBuilder, Unit>(url){
            final /* synthetic */ String $url;
            {
                this.$url = $url;
                super(1);
            }

            public final void invoke(@NotNull UrlBuilder $this$invoke) {
                Intrinsics.checkNotNullParameter((Object)$this$invoke, (String)"$this$invoke");
                String next2 = UrlParserKt.access$captureUntilAndSkip(UrlParserKt.access$captureUntilAndSkip(this.$url, "://", (Function1)new Function1<String, Unit>($this$invoke){
                    final /* synthetic */ UrlBuilder $this_invoke;
                    {
                        this.$this_invoke = $this_invoke;
                        super(1);
                    }

                    public final void invoke(@NotNull String it) {
                        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                        this.$this_invoke.setScheme(Scheme.Companion.parse(it));
                    }
                }), "@", (Function1)new Function1<String, Unit>($this$invoke){
                    final /* synthetic */ UrlBuilder $this_invoke;
                    {
                        this.$this_invoke = $this_invoke;
                        super(1);
                    }

                    public final void invoke(@NotNull String it) {
                        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                        this.$this_invoke.setUserInfo(UrlKt.UserInfo(it));
                    }
                });
                String[] stringArray = new String[]{"/", "?", "#"};
                next2 = UrlParserKt.access$capture(next2, RangesKt.until((int)0, (int)UrlParserKt.access$firstIndexOrEnd(next2, stringArray)), (Function1)new Function1<String, Unit>($this$invoke){
                    final /* synthetic */ UrlBuilder $this_invoke;
                    {
                        this.$this_invoke = $this_invoke;
                        super(1);
                    }

                    public final void invoke(@NotNull String it) {
                        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                        Pair<Host, Integer> pair = UrlParserKt.splitHostPort(it);
                        Host h = (Host)pair.component1();
                        Integer p = (Integer)pair.component2();
                        this.$this_invoke.setHost(h);
                        Integer n = p;
                        if (n == null) {
                            n = this.$this_invoke.getScheme().getDefaultPort();
                        }
                        this.$this_invoke.setPort(n);
                    }
                });
                if (StringsKt.startsWith$default((String)next2, (String)"/", (boolean)false, (int)2, null)) {
                    stringArray = new String[]{"?", "#"};
                    next2 = UrlParserKt.access$capture(next2, RangesKt.until((int)1, (int)UrlParserKt.access$firstIndexOrEnd(next2, stringArray)), (Function1)new Function1<String, Unit>($this$invoke){
                        final /* synthetic */ UrlBuilder $this_invoke;
                        {
                            this.$this_invoke = $this_invoke;
                            super(1);
                        }

                        public final void invoke(@NotNull String it) {
                            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                            this.$this_invoke.setPath('/' + aws.smithy.kotlin.runtime.util.text.TextKt.urlDecodeComponent$default(it, false, 1, null));
                        }
                    });
                }
                if (StringsKt.startsWith$default((String)next2, (String)"?", (boolean)false, (int)2, null)) {
                    stringArray = new String[]{"#"};
                    next2 = UrlParserKt.access$capture(next2, RangesKt.until((int)1, (int)UrlParserKt.access$firstIndexOrEnd(next2, stringArray)), (Function1)new Function1<String, Unit>($this$invoke){
                        final /* synthetic */ UrlBuilder $this_invoke;
                        {
                            this.$this_invoke = $this_invoke;
                            super(1);
                        }

                        /*
                         * WARNING - void declaration
                         */
                        public final void invoke(@NotNull String it) {
                            void $this$forEach$iv;
                            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                            Iterable iterable = aws.smithy.kotlin.runtime.util.text.TextKt.splitAsQueryString(it).entrySet();
                            UrlBuilder urlBuilder = this.$this_invoke;
                            boolean $i$f$forEach = false;
                            for (T element$iv : $this$forEach$iv) {
                                Collection<String> collection;
                                void $this$mapTo$iv$iv;
                                void $this$map$iv;
                                Map.Entry entry = (Map.Entry)element$iv;
                                boolean bl = false;
                                String k = (String)entry.getKey();
                                List v = (List)entry.getValue();
                                Iterable iterable2 = v;
                                String string = aws.smithy.kotlin.runtime.util.text.TextKt.urlDecodeComponent$default(k, false, 1, null);
                                QueryParametersBuilder queryParametersBuilder = urlBuilder.getParameters();
                                boolean $i$f$map = false;
                                void var15_15 = $this$map$iv;
                                Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                                boolean $i$f$mapTo = false;
                                for (T item$iv$iv : $this$mapTo$iv$iv) {
                                    void p0;
                                    String string2 = (String)item$iv$iv;
                                    collection = destination$iv$iv;
                                    boolean bl2 = false;
                                    collection.add(aws.smithy.kotlin.runtime.util.text.TextKt.urlDecodeComponent$default((String)p0, false, 1, null));
                                }
                                collection = (List)destination$iv$iv;
                                queryParametersBuilder.appendAll(string, (Iterable)collection);
                            }
                        }
                    });
                }
                if (StringsKt.startsWith$default((CharSequence)next2, (char)'#', (boolean)false, (int)2, null) && next2.length() > 1) {
                    String string = next2.substring(1);
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String).substring(startIndex)");
                    $this$invoke.setFragment(aws.smithy.kotlin.runtime.util.text.TextKt.urlDecodeComponent$default(string, false, 1, null));
                }
            }
        }));
    }

    /*
     * WARNING - void declaration
     */
    private static final int firstIndexOrEnd(String $this$firstIndexOrEnd, String ... substring) {
        void $this$filterTo$iv$iv;
        Iterable $this$mapTo$iv$iv;
        String[] $this$map$iv = substring;
        boolean $i$f$map = false;
        String[] stringArray = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.length);
        boolean $i$f$mapTo = false;
        int n = ((void)$this$mapTo$iv$iv).length;
        for (int i = 0; i < n; ++i) {
            void it;
            void item$iv$iv;
            void var11_13 = item$iv$iv = $this$mapTo$iv$iv[i];
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(StringsKt.indexOf$default((CharSequence)$this$firstIndexOrEnd, (String)it, (int)0, (boolean)false, (int)6, null));
        }
        Iterable $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$filter = false;
        $this$mapTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            int it = ((Number)element$iv$iv).intValue();
            boolean bl = false;
            if (!(it != -1)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List indices = (List)destination$iv$iv;
        if (indices.isEmpty()) {
            return $this$firstIndexOrEnd.length();
        }
        return Math.min(((Number)((Object)CollectionsKt.minOrThrow((Iterable)indices))).intValue(), $this$firstIndexOrEnd.length());
    }

    private static final String captureUntilAndSkip(String $this$captureUntilAndSkip, String substring, Function1<? super String, Unit> block) {
        int substringIndex = StringsKt.indexOf$default((CharSequence)$this$captureUntilAndSkip, (String)substring, (int)0, (boolean)false, (int)6, null);
        if (substringIndex == -1) {
            return $this$captureUntilAndSkip;
        }
        String slice = StringsKt.substring((String)$this$captureUntilAndSkip, (IntRange)RangesKt.until((int)0, (int)substringIndex));
        block.invoke((Object)slice);
        String string = $this$captureUntilAndSkip.substring(substringIndex + substring.length());
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String).substring(startIndex)");
        return string;
    }

    private static final String capture(String $this$capture, IntRange range, Function1<? super String, Unit> block) {
        String slice = StringsKt.substring((String)$this$capture, (IntRange)range);
        if (((CharSequence)slice).length() > 0) {
            block.invoke((Object)slice);
        }
        String string = $this$capture.substring(range.getLast() + 1);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String).substring(startIndex)");
        return string;
    }

    @NotNull
    public static final Pair<Host, Integer> splitHostPort(@NotNull String $this$splitHostPort) {
        Integer n;
        int hostEndIndex;
        Intrinsics.checkNotNullParameter((Object)$this$splitHostPort, (String)"<this>");
        int lBracketIndex = StringsKt.indexOf$default((CharSequence)$this$splitHostPort, (char)'[', (int)0, (boolean)false, (int)6, null);
        int rBracketIndex = StringsKt.indexOf$default((CharSequence)$this$splitHostPort, (char)']', (int)0, (boolean)false, (int)6, null);
        int lastColonIndex = StringsKt.lastIndexOf$default((CharSequence)$this$splitHostPort, (String)":", (int)0, (boolean)false, (int)6, null);
        int n2 = hostEndIndex = rBracketIndex != -1 ? rBracketIndex + 1 : (lastColonIndex != -1 ? lastColonIndex : $this$splitHostPort.length());
        if (!(lBracketIndex == -1 && rBracketIndex == -1 || lBracketIndex < rBracketIndex)) {
            boolean $i$a$-require-UrlParserKt$splitHostPort$42 = false;
            String $i$a$-require-UrlParserKt$splitHostPort$42 = "unmatched [ or ]";
            throw new IllegalArgumentException($i$a$-require-UrlParserKt$splitHostPort$42.toString());
        }
        if (!(lBracketIndex <= 0)) {
            boolean $i$a$-require-UrlParserKt$splitHostPort$52 = false;
            String $i$a$-require-UrlParserKt$splitHostPort$52 = "unexpected characters before [";
            throw new IllegalArgumentException($i$a$-require-UrlParserKt$splitHostPort$52.toString());
        }
        if (!(rBracketIndex == -1 || rBracketIndex == hostEndIndex - 1)) {
            boolean $i$a$-require-UrlParserKt$splitHostPort$62 = false;
            String $i$a$-require-UrlParserKt$splitHostPort$62 = "unexpected characters after ]";
            throw new IllegalArgumentException($i$a$-require-UrlParserKt$splitHostPort$62.toString());
        }
        String host = lBracketIndex != -1 ? StringsKt.substring((String)$this$splitHostPort, (IntRange)RangesKt.until((int)(lBracketIndex + 1), (int)rBracketIndex)) : StringsKt.substring((String)$this$splitHostPort, (IntRange)RangesKt.until((int)0, (int)hostEndIndex));
        String decodedHost = aws.smithy.kotlin.runtime.util.text.TextKt.urlDecodeComponent$default(host, false, 1, null);
        if (lBracketIndex != -1 && rBracketIndex != -1 && !TextKt.isIpv6(decodedHost)) {
            throw new IllegalArgumentException("non-ipv6 host was enclosed in []-brackets");
        }
        Host host2 = Host.Companion.parse(decodedHost);
        if (hostEndIndex != -1 && hostEndIndex != $this$splitHostPort.length()) {
            String string = $this$splitHostPort.substring(hostEndIndex + 1);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String).substring(startIndex)");
            n = Integer.parseInt(string);
        } else {
            n = null;
        }
        return new Pair((Object)host2, n);
    }

    public static final /* synthetic */ String access$captureUntilAndSkip(String $receiver, String substring, Function1 block) {
        return UrlParserKt.captureUntilAndSkip($receiver, substring, (Function1<? super String, Unit>)block);
    }

    public static final /* synthetic */ String access$capture(String $receiver, IntRange range, Function1 block) {
        return UrlParserKt.capture($receiver, range, (Function1<? super String, Unit>)block);
    }

    public static final /* synthetic */ int access$firstIndexOrEnd(String $receiver, String ... substring) {
        return UrlParserKt.firstIndexOrEnd($receiver, substring);
    }
}

