/*
 * Decompiled with CFR 0.152.
 */
package aws.smithy.kotlin.runtime.net;

import aws.smithy.kotlin.runtime.net.Host;
import aws.smithy.kotlin.runtime.net.HostKt;
import aws.smithy.kotlin.runtime.net.QueryParameters;
import aws.smithy.kotlin.runtime.net.Scheme;
import aws.smithy.kotlin.runtime.net.UrlKt;
import aws.smithy.kotlin.runtime.net.UrlParserKt;
import aws.smithy.kotlin.runtime.net.UserInfo;
import aws.smithy.kotlin.runtime.util.text.TextKt;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b$\b\u0086\b\u0018\u0000 32\u00020\u0001:\u00013B_\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\t\u0012\b\b\u0002\u0010\n\u001a\u00020\u000b\u0012\n\b\u0002\u0010\f\u001a\u0004\u0018\u00010\t\u0012\n\b\u0002\u0010\r\u001a\u0004\u0018\u00010\u000e\u0012\b\b\u0002\u0010\u000f\u001a\u00020\u0010\u0012\b\b\u0002\u0010\u0011\u001a\u00020\u0010\u00a2\u0006\u0002\u0010\u0012J\t\u0010%\u001a\u00020\u0003H\u00c6\u0003J\t\u0010&\u001a\u00020\u0005H\u00c6\u0003J\t\u0010'\u001a\u00020\u0007H\u00c6\u0003J\t\u0010(\u001a\u00020\tH\u00c6\u0003J\t\u0010)\u001a\u00020\u000bH\u00c6\u0003J\u000b\u0010*\u001a\u0004\u0018\u00010\tH\u00c6\u0003J\u000b\u0010+\u001a\u0004\u0018\u00010\u000eH\u00c6\u0003J\t\u0010,\u001a\u00020\u0010H\u00c6\u0003J\t\u0010-\u001a\u00020\u0010H\u00c6\u0003Jg\u0010.\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00072\b\b\u0002\u0010\b\u001a\u00020\t2\b\b\u0002\u0010\n\u001a\u00020\u000b2\n\b\u0002\u0010\f\u001a\u0004\u0018\u00010\t2\n\b\u0002\u0010\r\u001a\u0004\u0018\u00010\u000e2\b\b\u0002\u0010\u000f\u001a\u00020\u00102\b\b\u0002\u0010\u0011\u001a\u00020\u0010H\u00c6\u0001J\u0013\u0010/\u001a\u00020\u00102\b\u00100\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u00101\u001a\u00020\u0007H\u00d6\u0001J\b\u00102\u001a\u00020\tH\u0016R\u0011\u0010\u0011\u001a\u00020\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0011\u0010\u0015\u001a\u00020\t8F\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0017R\u0011\u0010\u000f\u001a\u00020\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0014R\u0013\u0010\f\u001a\u0004\u0018\u00010\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u0017R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001dR\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u0017R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010 R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\"R\u0013\u0010\r\u001a\u0004\u0018\u00010\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b#\u0010$\u00a8\u00064"}, d2={"Laws/smithy/kotlin/runtime/net/Url;", "", "scheme", "Laws/smithy/kotlin/runtime/net/Scheme;", "host", "Laws/smithy/kotlin/runtime/net/Host;", "port", "", "path", "", "parameters", "Laws/smithy/kotlin/runtime/net/QueryParameters;", "fragment", "userInfo", "Laws/smithy/kotlin/runtime/net/UserInfo;", "forceQuery", "", "encodeParameters", "(Laws/smithy/kotlin/runtime/net/Scheme;Laws/smithy/kotlin/runtime/net/Host;ILjava/lang/String;Laws/smithy/kotlin/runtime/net/QueryParameters;Ljava/lang/String;Laws/smithy/kotlin/runtime/net/UserInfo;ZZ)V", "getEncodeParameters", "()Z", "encodedPath", "getEncodedPath", "()Ljava/lang/String;", "getForceQuery", "getFragment", "getHost", "()Laws/smithy/kotlin/runtime/net/Host;", "getParameters", "()Laws/smithy/kotlin/runtime/net/QueryParameters;", "getPath", "getPort", "()I", "getScheme", "()Laws/smithy/kotlin/runtime/net/Scheme;", "getUserInfo", "()Laws/smithy/kotlin/runtime/net/UserInfo;", "component1", "component2", "component3", "component4", "component5", "component6", "component7", "component8", "component9", "copy", "equals", "other", "hashCode", "toString", "Companion", "runtime-core"})
@SourceDebugExtension(value={"SMAP\nUrl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Url.kt\naws/smithy/kotlin/runtime/net/Url\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,172:1\n1#2:173\n*E\n"})
public final class Url {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Scheme scheme;
    @NotNull
    private final Host host;
    private final int port;
    @NotNull
    private final String path;
    @NotNull
    private final QueryParameters parameters;
    @Nullable
    private final String fragment;
    @Nullable
    private final UserInfo userInfo;
    private final boolean forceQuery;
    private final boolean encodeParameters;

    public Url(@NotNull Scheme scheme, @NotNull Host host, int port, @NotNull String path, @NotNull QueryParameters parameters, @Nullable String fragment, @Nullable UserInfo userInfo, boolean forceQuery, boolean encodeParameters) {
        Intrinsics.checkNotNullParameter((Object)scheme, (String)"scheme");
        Intrinsics.checkNotNullParameter((Object)host, (String)"host");
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter((Object)parameters, (String)"parameters");
        this.scheme = scheme;
        this.host = host;
        this.port = port;
        this.path = path;
        this.parameters = parameters;
        this.fragment = fragment;
        this.userInfo = userInfo;
        this.forceQuery = forceQuery;
        this.encodeParameters = encodeParameters;
        int n = this.port;
        if (!(1 <= n ? n < 65536 : false)) {
            boolean bl = false;
            String string = "Given port " + this.port + " is not in required range [1, 65535]";
            throw new IllegalArgumentException(string.toString());
        }
    }

    public /* synthetic */ Url(Scheme scheme, Host host, int n, String string, QueryParameters queryParameters, String string2, UserInfo userInfo, boolean bl, boolean bl2, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 4) != 0) {
            n = scheme.getDefaultPort();
        }
        if ((n2 & 8) != 0) {
            string = "";
        }
        if ((n2 & 0x10) != 0) {
            queryParameters = QueryParameters.Companion.getEmpty();
        }
        if ((n2 & 0x20) != 0) {
            string2 = null;
        }
        if ((n2 & 0x40) != 0) {
            userInfo = null;
        }
        if ((n2 & 0x80) != 0) {
            bl = false;
        }
        if ((n2 & 0x100) != 0) {
            bl2 = true;
        }
        this(scheme, host, n, string, queryParameters, string2, userInfo, bl, bl2);
    }

    @NotNull
    public final Scheme getScheme() {
        return this.scheme;
    }

    @NotNull
    public final Host getHost() {
        return this.host;
    }

    public final int getPort() {
        return this.port;
    }

    @NotNull
    public final String getPath() {
        return this.path;
    }

    @NotNull
    public final QueryParameters getParameters() {
        return this.parameters;
    }

    @Nullable
    public final String getFragment() {
        return this.fragment;
    }

    @Nullable
    public final UserInfo getUserInfo() {
        return this.userInfo;
    }

    public final boolean getForceQuery() {
        return this.forceQuery;
    }

    public final boolean getEncodeParameters() {
        return this.encodeParameters;
    }

    @NotNull
    public String toString() {
        StringBuilder stringBuilder;
        StringBuilder $this$toString_u24lambda_u242 = stringBuilder = new StringBuilder();
        boolean bl = false;
        $this$toString_u24lambda_u242.append(this.scheme.getProtocolName());
        $this$toString_u24lambda_u242.append("://");
        UserInfo userInfo = this.userInfo;
        if (userInfo != null) {
            UserInfo userinfo = userInfo;
            boolean bl2 = false;
            if (!StringsKt.isBlank((CharSequence)userinfo.getUsername())) {
                $this$toString_u24lambda_u242.append(TextKt.urlEncodeComponent$default(userinfo.getUsername(), false, 1, null));
                if (!StringsKt.isBlank((CharSequence)userinfo.getPassword())) {
                    $this$toString_u24lambda_u242.append(':' + TextKt.urlEncodeComponent$default(userinfo.getPassword(), false, 1, null));
                }
                $this$toString_u24lambda_u242.append("@");
            }
        }
        $this$toString_u24lambda_u242.append(HostKt.toUrlString(this.host));
        if (this.port != this.scheme.getDefaultPort()) {
            $this$toString_u24lambda_u242.append("" + ':' + this.port);
        }
        $this$toString_u24lambda_u242.append(this.getEncodedPath());
        String string = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"StringBuilder().apply(builderAction).toString()");
        return string;
    }

    @NotNull
    public final String getEncodedPath() {
        return UrlKt.access$encodePath(this.path, this.parameters.entries(), this.fragment, this.forceQuery, this.encodeParameters);
    }

    @NotNull
    public final Scheme component1() {
        return this.scheme;
    }

    @NotNull
    public final Host component2() {
        return this.host;
    }

    public final int component3() {
        return this.port;
    }

    @NotNull
    public final String component4() {
        return this.path;
    }

    @NotNull
    public final QueryParameters component5() {
        return this.parameters;
    }

    @Nullable
    public final String component6() {
        return this.fragment;
    }

    @Nullable
    public final UserInfo component7() {
        return this.userInfo;
    }

    public final boolean component8() {
        return this.forceQuery;
    }

    public final boolean component9() {
        return this.encodeParameters;
    }

    @NotNull
    public final Url copy(@NotNull Scheme scheme, @NotNull Host host, int port, @NotNull String path, @NotNull QueryParameters parameters, @Nullable String fragment, @Nullable UserInfo userInfo, boolean forceQuery, boolean encodeParameters) {
        Intrinsics.checkNotNullParameter((Object)scheme, (String)"scheme");
        Intrinsics.checkNotNullParameter((Object)host, (String)"host");
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter((Object)parameters, (String)"parameters");
        return new Url(scheme, host, port, path, parameters, fragment, userInfo, forceQuery, encodeParameters);
    }

    public static /* synthetic */ Url copy$default(Url url, Scheme scheme, Host host, int n, String string, QueryParameters queryParameters, String string2, UserInfo userInfo, boolean bl, boolean bl2, int n2, Object object) {
        if ((n2 & 1) != 0) {
            scheme = url.scheme;
        }
        if ((n2 & 2) != 0) {
            host = url.host;
        }
        if ((n2 & 4) != 0) {
            n = url.port;
        }
        if ((n2 & 8) != 0) {
            string = url.path;
        }
        if ((n2 & 0x10) != 0) {
            queryParameters = url.parameters;
        }
        if ((n2 & 0x20) != 0) {
            string2 = url.fragment;
        }
        if ((n2 & 0x40) != 0) {
            userInfo = url.userInfo;
        }
        if ((n2 & 0x80) != 0) {
            bl = url.forceQuery;
        }
        if ((n2 & 0x100) != 0) {
            bl2 = url.encodeParameters;
        }
        return url.copy(scheme, host, n, string, queryParameters, string2, userInfo, bl, bl2);
    }

    public int hashCode() {
        int result = this.scheme.hashCode();
        result = result * 31 + this.host.hashCode();
        result = result * 31 + Integer.hashCode(this.port);
        result = result * 31 + this.path.hashCode();
        result = result * 31 + this.parameters.hashCode();
        result = result * 31 + (this.fragment == null ? 0 : this.fragment.hashCode());
        result = result * 31 + (this.userInfo == null ? 0 : this.userInfo.hashCode());
        int n = this.forceQuery ? 1 : 0;
        if (n != 0) {
            n = 1;
        }
        result = result * 31 + n;
        int n2 = this.encodeParameters ? 1 : 0;
        if (n2 != 0) {
            n2 = 1;
        }
        result = result * 31 + n2;
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Url)) {
            return false;
        }
        Url url = (Url)other;
        if (!Intrinsics.areEqual((Object)this.scheme, (Object)url.scheme)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.host, (Object)url.host)) {
            return false;
        }
        if (this.port != url.port) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.path, (Object)url.path)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.parameters, (Object)url.parameters)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.fragment, (Object)url.fragment)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.userInfo, (Object)url.userInfo)) {
            return false;
        }
        if (this.forceQuery != url.forceQuery) {
            return false;
        }
        return this.encodeParameters == url.encodeParameters;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\u0007"}, d2={"Laws/smithy/kotlin/runtime/net/Url$Companion;", "", "()V", "parse", "Laws/smithy/kotlin/runtime/net/Url;", "url", "", "runtime-core"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Url parse(@NotNull String url) {
            Intrinsics.checkNotNullParameter((Object)url, (String)"url");
            return UrlParserKt.urlParseImpl(url);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

