/*
 * Decompiled with CFR 0.152.
 */
package aws.smithy.kotlin.runtime.net;

import aws.smithy.kotlin.runtime.net.IpAddr;
import aws.smithy.kotlin.runtime.net.IpV4Addr;
import aws.smithy.kotlin.runtime.net.IpV6Addr;
import aws.smithy.kotlin.runtime.net.IpV6AddrKt;
import aws.smithy.kotlin.runtime.net.TextKt;
import java.util.Arrays;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.UShort;
import kotlin.UShortArray;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntRange;
import kotlin.ranges.RangesKt;
import kotlin.text.UStringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\b\u0018\u0000 22\u00020\u0001:\u00012BV\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u0012\u0006\u0010\u0007\u001a\u00020\u0003\u0012\u0006\u0010\b\u001a\u00020\u0003\u0012\u0006\u0010\t\u001a\u00020\u0003\u0012\u0006\u0010\n\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u000b\u001a\u0004\u0018\u00010\f\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\rB\u0019\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u0012\n\b\u0002\u0010\u000b\u001a\u0004\u0018\u00010\f\u00a2\u0006\u0002\u0010\u0010J\t\u0010\"\u001a\u00020\u000fH\u00c6\u0003J\u000b\u0010#\u001a\u0004\u0018\u00010\fH\u00c6\u0003J\u001f\u0010$\u001a\u00020\u00002\b\b\u0002\u0010\u000e\u001a\u00020\u000f2\n\b\u0002\u0010\u000b\u001a\u0004\u0018\u00010\fH\u00c6\u0001J\u0013\u0010%\u001a\u00020\u00172\b\u0010&\u001a\u0004\u0018\u00010'H\u0096\u0002J\b\u0010(\u001a\u00020)H\u0016J\b\u0010*\u001a\u0004\u0018\u00010+J\b\u0010,\u001a\u00020\fH\u0016J\u001c\u0010-\u001a\u00060.j\u0002`/*\u00060.j\u0002`/2\u0006\u00100\u001a\u000201H\u0002R\u001b\u0010\u0011\u001a\u00020\f8VX\u0096\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0014\u0010\u0015\u001a\u0004\b\u0012\u0010\u0013R\u0014\u0010\u0016\u001a\u00020\u00178VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0018R\u0014\u0010\u0019\u001a\u00020\u00178VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u0018R\u0014\u0010\u000e\u001a\u00020\u000fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR$\u0010\u001c\u001a\u00020\u001d8FX\u0086\u0084\u0002\u00f8\u0001\u0000\u00f8\u0001\u0001\u00f8\u0001\u0002\u00a2\u0006\f\n\u0004\b \u0010\u0015\u001a\u0004\b\u001e\u0010\u001fR\u0013\u0010\u000b\u001a\u0004\u0018\u00010\f\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\u0013\u0082\u0002\u000f\n\u0002\b\u0019\n\u0005\b\u00a1\u001e0\u0001\n\u0002\b!\u00a8\u00063"}, d2={"Laws/smithy/kotlin/runtime/net/IpV6Addr;", "Laws/smithy/kotlin/runtime/net/IpAddr;", "a", "Lkotlin/UShort;", "b", "c", "d", "e", "f", "g", "h", "zoneId", "", "(SSSSSSSSLjava/lang/String;Lkotlin/jvm/internal/DefaultConstructorMarker;)V", "octets", "", "([BLjava/lang/String;)V", "address", "getAddress", "()Ljava/lang/String;", "address$delegate", "Lkotlin/Lazy;", "isLoopBack", "", "()Z", "isUnspecified", "getOctets", "()[B", "segments", "Lkotlin/UShortArray;", "getSegments-amswpOA", "()[S", "segments$delegate", "getZoneId", "component1", "component2", "copy", "equals", "other", "", "hashCode", "", "toIpv4Mapped", "Laws/smithy/kotlin/runtime/net/IpV4Addr;", "toString", "formatSegments", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "range", "Lkotlin/ranges/IntRange;", "Companion", "runtime-core"})
@SourceDebugExtension(value={"SMAP\nIpV6Addr.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IpV6Addr.kt\naws/smithy/kotlin/runtime/net/IpV6Addr\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,238:1\n1#2:239\n13654#3,3:240\n*S KotlinDebug\n*F\n+ 1 IpV6Addr.kt\naws/smithy/kotlin/runtime/net/IpV6Addr\n*L\n194#1:240,3\n*E\n"})
public final class IpV6Addr
extends IpAddr {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final byte[] octets;
    @Nullable
    private final String zoneId;
    @NotNull
    private final Lazy segments$delegate;
    @NotNull
    private final Lazy address$delegate;
    @NotNull
    private static final IpV6Addr LOCALHOST;
    @NotNull
    private static final IpV6Addr UNSPECIFIED;
    @NotNull
    private static final byte[] IPV4_MAPPED_PREFIX_OCTETS;

    public IpV6Addr(@NotNull byte[] octets, @Nullable String zoneId) {
        Intrinsics.checkNotNullParameter((Object)octets, (String)"octets");
        super(null);
        this.octets = octets;
        this.zoneId = zoneId;
        if (!(this.getOctets().length == 16)) {
            boolean bl = false;
            String string = "Invalid IPv6 repr: " + this.getOctets() + "; expected 16 bytes";
            throw new IllegalArgumentException(string.toString());
        }
        this.segments$delegate = LazyKt.lazy((Function0)((Function0)new Function0<UShortArray>(this){
            final /* synthetic */ IpV6Addr this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final short[] invoke-amswpOA() {
                int n = this.this$0.getOctets().length / 2;
                IpV6Addr ipV6Addr = this.this$0;
                short[] sArray = new short[n];
                for (int i = 0; i < n; ++i) {
                    short s;
                    void $this$readUShort$iv;
                    void it;
                    int n2;
                    int n3 = n2 = i;
                    int n4 = n2;
                    short[] sArray2 = sArray;
                    boolean bl = false;
                    byte[] byArray = ipV6Addr.getOctets();
                    void idx$iv = it * 2;
                    boolean $i$f$readUShort = false;
                    void data$iv = $this$readUShort$iv;
                    if (!(idx$iv <= ((void)data$iv).length - 2)) {
                        String string = "Check failed.";
                        throw new IllegalStateException(string.toString());
                    }
                    int s$iv = (data$iv[idx$iv] & 0xFF) << 8 | data$iv[idx$iv + true] & 0xFF;
                    sArray2[n4] = s = UShort.constructor-impl((short)((short)s$iv));
                }
                return UShortArray.constructor-impl((short[])sArray);
            }
        }));
        this.address$delegate = LazyKt.lazy((Function0)((Function0)new Function0<String>(this){
            final /* synthetic */ IpV6Addr this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final String invoke() {
                String string;
                IpV4Addr ipv4Mapped = this.this$0.toIpv4Mapped();
                if (this.this$0.isLoopBack()) {
                    string = "::1";
                } else if (this.this$0.isUnspecified()) {
                    string = "::";
                } else if (ipv4Mapped != null) {
                    string = "::ffff:" + ipv4Mapped;
                } else {
                    StringBuilder stringBuilder;
                    IpV6Addr ipV6Addr = this.this$0;
                    StringBuilder $this$invoke_u24lambda_u242 = stringBuilder = new StringBuilder();
                    boolean bl = false;
                    StringBuilder $this$invoke_u24lambda_u242_u24lambda_u241 = $this$invoke_u24lambda_u242;
                    boolean bl2 = false;
                    Span curr = null;
                    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000!\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\r\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000*\u0001\u0000\b\u008a\b\u0018\u00002\u00020\u0001B\u0019\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\t\u0010\f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\r\u001a\u00020\u0003H\u00c6\u0003J\"\u0010\u000e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0003H\u00c6\u0001\u00a2\u0006\u0002\u0010\u000fJ\u0013\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0013\u001a\u00020\u0003H\u00d6\u0001J\t\u0010\u0014\u001a\u00020\u0015H\u00d6\u0001R\u001a\u0010\u0004\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u0007\"\u0004\b\u000b\u0010\t\u00a8\u0006\u0016"}, d2={"aws/smithy/kotlin/runtime/net/IpV6Addr$address$2$formatted$1$Span", "", "start", "", "len", "(II)V", "getLen", "()I", "setLen", "(I)V", "getStart", "setStart", "component1", "component2", "copy", "(II)Laws/smithy/kotlin/runtime/net/IpV6Addr$address$2$formatted$1$Span;", "equals", "", "other", "hashCode", "toString", "", "runtime-core"})
                    public final class Span {
                        private int start;
                        private int len;

                        public Span(int start, int len) {
                            this.start = start;
                            this.len = len;
                        }

                        public /* synthetic */ Span(int n, int n2, int n3, DefaultConstructorMarker defaultConstructorMarker) {
                            if ((n3 & 1) != 0) {
                                n = 0;
                            }
                            if ((n3 & 2) != 0) {
                                n2 = 0;
                            }
                            this(n, n2);
                        }

                        public final int getStart() {
                            return this.start;
                        }

                        public final void setStart(int n) {
                            this.start = n;
                        }

                        public final int getLen() {
                            return this.len;
                        }

                        public final void setLen(int n) {
                            this.len = n;
                        }

                        public final int component1() {
                            return this.start;
                        }

                        public final int component2() {
                            return this.len;
                        }

                        @NotNull
                        public final Span copy(int start, int len) {
                            return new Span(start, len);
                        }

                        public static /* synthetic */ Span copy$default(Span span, int n, int n2, int n3, Object object) {
                            if ((n3 & 1) != 0) {
                                n = span.start;
                            }
                            if ((n3 & 2) != 0) {
                                n2 = span.len;
                            }
                            return span.copy(n, n2);
                        }

                        @NotNull
                        public String toString() {
                            return "Span(start=" + this.start + ", len=" + this.len + ')';
                        }

                        public int hashCode() {
                            int result = Integer.hashCode(this.start);
                            result = result * 31 + Integer.hashCode(this.len);
                            return result;
                        }

                        public boolean equals(@Nullable Object other) {
                            if (this == other) {
                                return true;
                            }
                            if (!(other instanceof Span)) {
                                return false;
                            }
                            Span span = (Span)other;
                            if (this.start != span.start) {
                                return false;
                            }
                            return this.len == span.len;
                        }
                    }
                    curr = new Span(0, 0, 3, null);
                    Span longest = null;
                    longest = new Span(0, 0, 3, null);
                    short[] sArray = ipV6Addr.getSegments-amswpOA();
                    int n = 0;
                    int n2 = UShortArray.getSize-impl((short[])sArray);
                    for (int i = 0; i < n2; ++i) {
                        void segment;
                        short s = UShortArray.get-Mh2AYeg((short[])sArray, (int)i);
                        int n3 = n++;
                        short s2 = s;
                        int idx = n3;
                        boolean bl3 = false;
                        if (segment == UShort.constructor-impl((short)((short)0))) {
                            if (curr.getLen() == 0) {
                                curr.setStart(idx);
                            }
                            Span span = curr;
                            span.setLen(span.getLen() + 1);
                            if (curr.getLen() <= longest.getLen()) continue;
                            longest = curr;
                            continue;
                        }
                        curr = new Span(0, 0, 3, null);
                    }
                    Span zeroes = longest;
                    if (zeroes.getLen() > 1) {
                        IpV6Addr.access$formatSegments(ipV6Addr, $this$invoke_u24lambda_u242, RangesKt.until((int)0, (int)zeroes.getStart()));
                        $this$invoke_u24lambda_u242.append("::");
                        IpV6Addr.access$formatSegments(ipV6Addr, $this$invoke_u24lambda_u242, RangesKt.until((int)(zeroes.getStart() + zeroes.getLen()), (int)UShortArray.getSize-impl((short[])ipV6Addr.getSegments-amswpOA())));
                    } else {
                        short[] $this$indices$iv = ipV6Addr.getSegments-amswpOA();
                        boolean bl4 = false;
                        IpV6Addr.access$formatSegments(ipV6Addr, $this$invoke_u24lambda_u242, ArraysKt.getIndices((short[])$this$indices$iv));
                    }
                    String string2 = stringBuilder.toString();
                    string = string2;
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"StringBuilder().apply(builderAction).toString()");
                }
                String formatted2 = string;
                return this.this$0.getZoneId() != null ? formatted2 + '%' + this.this$0.getZoneId() : formatted2;
            }
        }));
    }

    public /* synthetic */ IpV6Addr(byte[] byArray, String string, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            string = null;
        }
        this(byArray, string);
    }

    @Override
    @NotNull
    public byte[] getOctets() {
        return this.octets;
    }

    @Nullable
    public final String getZoneId() {
        return this.zoneId;
    }

    private IpV6Addr(short a, short b, short c, short d, short e, short f, short g, short h, String zoneId) {
        this(IpV6AddrKt.access$ipv6SegmentsToOctets-BGmAo10(a, b, c, d, e, f, g, h), zoneId);
    }

    public /* synthetic */ IpV6Addr(short s, short s2, short s3, short s4, short s5, short s6, short s7, short s8, String string, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 0x100) != 0) {
            string = null;
        }
        this(s, s2, s3, s4, s5, s6, s7, s8, string, null);
    }

    @NotNull
    public final short[] getSegments-amswpOA() {
        Lazy lazy = this.segments$delegate;
        return ((UShortArray)lazy.getValue()).unbox-impl();
    }

    @Override
    @NotNull
    public String getAddress() {
        Lazy lazy = this.address$delegate;
        return (String)lazy.getValue();
    }

    private final StringBuilder formatSegments(StringBuilder $this$formatSegments, IntRange range) {
        return (StringBuilder)CollectionsKt.joinTo$default((Iterable)((Iterable)range), (Appendable)$this$formatSegments, (CharSequence)":", null, null, (int)0, null, (Function1)((Function1)new Function1<Integer, CharSequence>(this){
            final /* synthetic */ IpV6Addr this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            @NotNull
            public final CharSequence invoke(int it) {
                return UStringsKt.toString-olVBNx4((short)UShortArray.get-Mh2AYeg((short[])this.this$0.getSegments-amswpOA(), (int)it), (int)16);
            }
        }), (int)60, null);
    }

    @Override
    public boolean isLoopBack() {
        return Intrinsics.areEqual((Object)this, (Object)LOCALHOST);
    }

    @Override
    public boolean isUnspecified() {
        return Intrinsics.areEqual((Object)this, (Object)UNSPECIFIED);
    }

    @NotNull
    public String toString() {
        return this.getAddress();
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        IpV6Addr cfr_ignored_0 = (IpV6Addr)other;
        return Arrays.equals(this.getOctets(), ((IpV6Addr)other).getOctets());
    }

    public int hashCode() {
        return Arrays.hashCode(this.getOctets());
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final IpV4Addr toIpv4Mapped() {
        byte[] $this$forEachIndexed$iv = IPV4_MAPPED_PREFIX_OCTETS;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (byte item$iv : $this$forEachIndexed$iv) {
            void byteVal;
            int n = index$iv++;
            byte by = item$iv;
            int idx = n;
            boolean bl = false;
            if (this.getOctets()[idx] == byteVal) continue;
            return null;
        }
        return new IpV4Addr(ArraysKt.sliceArray((byte[])this.getOctets(), (IntRange)RangesKt.until((int)IPV4_MAPPED_PREFIX_OCTETS.length, (int)this.getOctets().length)));
    }

    @NotNull
    public final byte[] component1() {
        return this.getOctets();
    }

    @Nullable
    public final String component2() {
        return this.zoneId;
    }

    @NotNull
    public final IpV6Addr copy(@NotNull byte[] octets, @Nullable String zoneId) {
        Intrinsics.checkNotNullParameter((Object)octets, (String)"octets");
        return new IpV6Addr(octets, zoneId);
    }

    public static /* synthetic */ IpV6Addr copy$default(IpV6Addr ipV6Addr, byte[] byArray, String string, int n, Object object) {
        if ((n & 1) != 0) {
            byArray = ipV6Addr.getOctets();
        }
        if ((n & 2) != 0) {
            string = ipV6Addr.zoneId;
        }
        return ipV6Addr.copy(byArray, string);
    }

    public /* synthetic */ IpV6Addr(short a, short b, short c, short d, short e, short f, short g, short h, String zoneId, DefaultConstructorMarker $constructor_marker) {
        this(a, b, c, d, e, f, g, h, zoneId);
    }

    public static final /* synthetic */ StringBuilder access$formatSegments(IpV6Addr $this, StringBuilder $receiver, IntRange range) {
        return $this.formatSegments($receiver, range);
    }

    static {
        byte[] byArray = new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1};
        LOCALHOST = new IpV6Addr(byArray, null, 2, null);
        byArray = new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
        UNSPECIFIED = new IpV6Addr(byArray, null, 2, null);
        byArray = new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -1, -1};
        IPV4_MAPPED_PREFIX_OCTETS = byArray;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\r\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\u000fR\u0014\u0010\u0003\u001a\u00020\u0004X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u000b\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\n\u00a8\u0006\u0010"}, d2={"Laws/smithy/kotlin/runtime/net/IpV6Addr$Companion;", "", "()V", "IPV4_MAPPED_PREFIX_OCTETS", "", "getIPV4_MAPPED_PREFIX_OCTETS$runtime_core", "()[B", "LOCALHOST", "Laws/smithy/kotlin/runtime/net/IpV6Addr;", "getLOCALHOST", "()Laws/smithy/kotlin/runtime/net/IpV6Addr;", "UNSPECIFIED", "getUNSPECIFIED", "parse", "s", "", "runtime-core"})
    @SourceDebugExtension(value={"SMAP\nIpV6Addr.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IpV6Addr.kt\naws/smithy/kotlin/runtime/net/IpV6Addr$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,238:1\n1#2:239\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final IpV6Addr getLOCALHOST() {
            return LOCALHOST;
        }

        @NotNull
        public final IpV6Addr getUNSPECIFIED() {
            return UNSPECIFIED;
        }

        @NotNull
        public final byte[] getIPV4_MAPPED_PREFIX_OCTETS$runtime_core() {
            return IPV4_MAPPED_PREFIX_OCTETS;
        }

        @NotNull
        public final IpV6Addr parse(@NotNull String s) {
            Intrinsics.checkNotNullParameter((Object)s, (String)"s");
            IpV6Addr ipV6Addr = TextKt.parseIpv6OrNull(s);
            if (ipV6Addr == null) {
                boolean bl = false;
                String string = "Invalid Ipv6 address: " + s;
                throw new IllegalArgumentException(string.toString());
            }
            return ipV6Addr;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

