/*
 * Decompiled with CFR 0.152.
 */
package aws.smithy.kotlin.runtime.net;

import aws.smithy.kotlin.runtime.net.IpAddr;
import aws.smithy.kotlin.runtime.net.IpV4Addr;
import aws.smithy.kotlin.runtime.net.IpV6Addr;
import aws.smithy.kotlin.runtime.net.TextKt;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\b\u0018\u0000 \u001f2\u00020\u0001:\u0001\u001fB*\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0007B\r\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\t\u0010\u0015\u001a\u00020\tH\u00c6\u0003J\u0013\u0010\u0016\u001a\u00020\u00002\b\b\u0002\u0010\b\u001a\u00020\tH\u00c6\u0001J\u0013\u0010\u0017\u001a\u00020\u00102\b\u0010\u0018\u001a\u0004\u0018\u00010\u0019H\u0096\u0002J\b\u0010\u001a\u001a\u00020\u001bH\u0016J\u0006\u0010\u001c\u001a\u00020\u001dJ\b\u0010\u001e\u001a\u00020\fH\u0016R\u0014\u0010\u000b\u001a\u00020\f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\u000f\u001a\u00020\u00108VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0011R\u0014\u0010\u0012\u001a\u00020\u00108VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0011R\u0014\u0010\b\u001a\u00020\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006 "}, d2={"Laws/smithy/kotlin/runtime/net/IpV4Addr;", "Laws/smithy/kotlin/runtime/net/IpAddr;", "a", "Lkotlin/UByte;", "b", "c", "d", "(BBBBLkotlin/jvm/internal/DefaultConstructorMarker;)V", "octets", "", "([B)V", "address", "", "getAddress", "()Ljava/lang/String;", "isLoopBack", "", "()Z", "isUnspecified", "getOctets", "()[B", "component1", "copy", "equals", "other", "", "hashCode", "", "toMappedIpv6", "Laws/smithy/kotlin/runtime/net/IpV6Addr;", "toString", "Companion", "runtime-core"})
@SourceDebugExtension(value={"SMAP\nIpV4Addr.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IpV4Addr.kt\naws/smithy/kotlin/runtime/net/IpV4Addr\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,93:1\n1#2:94\n*E\n"})
public final class IpV4Addr
extends IpAddr {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final byte[] octets;
    @NotNull
    private static final IpV4Addr LOCALHOST = new IpV4Addr(127, 0, 0, 1, null);
    @NotNull
    private static final IpV4Addr UNSPECIFIED = new IpV4Addr(0, 0, 0, 0, null);

    public IpV4Addr(@NotNull byte[] octets) {
        Intrinsics.checkNotNullParameter((Object)octets, (String)"octets");
        super(null);
        this.octets = octets;
        if (!(this.getOctets().length == 4)) {
            boolean bl = false;
            String string = "Invalid IPv4 repr: " + this.getOctets() + "; expected 4 bytes";
            throw new IllegalArgumentException(string.toString());
        }
    }

    @Override
    @NotNull
    public byte[] getOctets() {
        return this.octets;
    }

    private IpV4Addr(byte a, byte b, byte c, byte d) {
        byte[] byArray = new byte[]{a, b, c, d};
        this(byArray);
    }

    @Override
    public boolean isLoopBack() {
        return this.getOctets()[0] == 127;
    }

    @Override
    public boolean isUnspecified() {
        return Intrinsics.areEqual((Object)this, (Object)UNSPECIFIED);
    }

    @Override
    @NotNull
    public String getAddress() {
        return ArraysKt.joinToString$default((byte[])this.getOctets(), (CharSequence)".", null, null, (int)0, null, (Function1)address.1.INSTANCE, (int)30, null);
    }

    @NotNull
    public String toString() {
        return this.getAddress();
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        IpV4Addr cfr_ignored_0 = (IpV4Addr)other;
        return Arrays.equals(this.getOctets(), ((IpV4Addr)other).getOctets());
    }

    public int hashCode() {
        return Arrays.hashCode(this.getOctets());
    }

    @NotNull
    public final IpV6Addr toMappedIpv6() {
        byte[] v6Octets = new byte[16];
        v6Octets[10] = -1;
        v6Octets[11] = -1;
        v6Octets[12] = this.getOctets()[0];
        v6Octets[13] = this.getOctets()[1];
        v6Octets[14] = this.getOctets()[2];
        v6Octets[15] = this.getOctets()[3];
        return new IpV6Addr(v6Octets, null, 2, null);
    }

    @NotNull
    public final byte[] component1() {
        return this.getOctets();
    }

    @NotNull
    public final IpV4Addr copy(@NotNull byte[] octets) {
        Intrinsics.checkNotNullParameter((Object)octets, (String)"octets");
        return new IpV4Addr(octets);
    }

    public static /* synthetic */ IpV4Addr copy$default(IpV4Addr ipV4Addr, byte[] byArray, int n, Object object) {
        if ((n & 1) != 0) {
            byArray = ipV4Addr.getOctets();
        }
        return ipV4Addr.copy(byArray);
    }

    public /* synthetic */ IpV4Addr(byte a, byte b, byte c, byte d, DefaultConstructorMarker $constructor_marker) {
        this(a, b, c, d);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\t\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u000bR\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0011\u0010\u0007\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0006\u00a8\u0006\f"}, d2={"Laws/smithy/kotlin/runtime/net/IpV4Addr$Companion;", "", "()V", "LOCALHOST", "Laws/smithy/kotlin/runtime/net/IpV4Addr;", "getLOCALHOST", "()Laws/smithy/kotlin/runtime/net/IpV4Addr;", "UNSPECIFIED", "getUNSPECIFIED", "parse", "s", "", "runtime-core"})
    @SourceDebugExtension(value={"SMAP\nIpV4Addr.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IpV4Addr.kt\naws/smithy/kotlin/runtime/net/IpV4Addr$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,93:1\n1#2:94\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final IpV4Addr getLOCALHOST() {
            return LOCALHOST;
        }

        @NotNull
        public final IpV4Addr getUNSPECIFIED() {
            return UNSPECIFIED;
        }

        @NotNull
        public final IpV4Addr parse(@NotNull String s) {
            Intrinsics.checkNotNullParameter((Object)s, (String)"s");
            IpV4Addr ipV4Addr = TextKt.parseIpv4OrNull(s);
            if (ipV4Addr == null) {
                boolean bl = false;
                String string = "Invalid Ipv4 address: " + s;
                throw new IllegalArgumentException(string.toString());
            }
            return ipV4Addr;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

