/*
 * Decompiled with CFR 0.152.
 */
package aws.smithy.kotlin.runtime.net;

import aws.smithy.kotlin.runtime.net.Host;
import aws.smithy.kotlin.runtime.net.IpAddr;
import aws.smithy.kotlin.runtime.net.IpV4Addr;
import aws.smithy.kotlin.runtime.net.IpV6Addr;
import aws.smithy.kotlin.runtime.net.TextKt;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u0000\u0010\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\u001a\u0010\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003H\u0002\u001a\n\u0010\u0004\u001a\u00020\u0003*\u00020\u0001\u00a8\u0006\u0005"}, d2={"hostParseImpl", "Laws/smithy/kotlin/runtime/net/Host;", "host", "", "toUrlString", "runtime-core"})
@SourceDebugExtension(value={"SMAP\nHost.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Host.kt\naws/smithy/kotlin/runtime/net/HostKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,54:1\n1726#2,3:55\n*S KotlinDebug\n*F\n+ 1 Host.kt\naws/smithy/kotlin/runtime/net/HostKt\n*L\n34#1:55,3\n*E\n"})
public final class HostKt {
    private static final Host hostParseImpl(String host) {
        Host host2;
        IpV4Addr ipV4Addr = TextKt.parseIpv4OrNull(host);
        IpAddr ip = ipV4Addr != null ? (IpAddr)ipV4Addr : (IpAddr)TextKt.parseIpv6OrNull(host);
        if (ip != null) {
            host2 = new Host.IpAddress(ip);
        } else {
            boolean bl;
            block7: {
                char[] cArray = new char[]{'.'};
                Iterable $this$all$iv = StringsKt.split$default((CharSequence)host, (char[])cArray, (boolean)false, (int)0, (int)6, null);
                boolean $i$f$all = false;
                if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                    bl = true;
                } else {
                    for (Object element$iv : $this$all$iv) {
                        String p0 = (String)element$iv;
                        boolean bl2 = false;
                        if (TextKt.isValidHostname(p0)) continue;
                        bl = false;
                        break block7;
                    }
                    bl = true;
                }
            }
            if (bl) {
                host2 = new Host.Domain(host);
            } else {
                throw new IllegalArgumentException(host + " is not a valid inet host");
            }
        }
        return host2;
    }

    @NotNull
    public static final String toUrlString(@NotNull Host $this$toUrlString) {
        String string;
        Intrinsics.checkNotNullParameter((Object)$this$toUrlString, (String)"<this>");
        Host host = $this$toUrlString;
        if (host instanceof Host.IpAddress) {
            if (((Host.IpAddress)$this$toUrlString).getAddress() instanceof IpV6Addr) {
                if (((IpV6Addr)((Host.IpAddress)$this$toUrlString).getAddress()).getZoneId() == null) {
                    string = "" + '[' + ((Host.IpAddress)$this$toUrlString).getAddress() + ']';
                } else {
                    IpV6Addr withoutZoneId = IpV6Addr.copy$default((IpV6Addr)((Host.IpAddress)$this$toUrlString).getAddress(), null, null, 1, null);
                    string = "" + '[' + withoutZoneId + "%25" + aws.smithy.kotlin.runtime.util.text.TextKt.urlEncodeComponent$default(((IpV6Addr)((Host.IpAddress)$this$toUrlString).getAddress()).getZoneId(), false, 1, null) + ']';
                }
            } else {
                string = ((Host.IpAddress)$this$toUrlString).getAddress().toString();
            }
        } else if (host instanceof Host.Domain) {
            string = ((Host.Domain)$this$toUrlString).getName();
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return string;
    }

    public static final /* synthetic */ Host access$hostParseImpl(String host) {
        return HostKt.hostParseImpl(host);
    }
}

