/*
 * Decompiled with CFR 0.152.
 */
package aws.smithy.kotlin.runtime.io.internal;

import aws.smithy.kotlin.runtime.InternalApi;
import aws.smithy.kotlin.runtime.io.SdkBuffer;
import aws.smithy.kotlin.runtime.io.SdkSource;
import aws.smithy.kotlin.runtime.io.internal.ConvertKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import okio.Buffer;
import org.jetbrains.annotations.NotNull;

@InternalApi
@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b'\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u00a2\u0006\u0002\u0010\u0003J\t\u0010\u0006\u001a\u00020\u0007H\u0096\u0001J \u0010\b\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\fH&J\u0018\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u000fH\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Laws/smithy/kotlin/runtime/io/internal/SdkSourceObserver;", "Laws/smithy/kotlin/runtime/io/SdkSource;", "delegate", "(Laws/smithy/kotlin/runtime/io/SdkSource;)V", "cursor", "Lokio/Buffer$UnsafeCursor;", "close", "", "observe", "data", "", "offset", "", "length", "read", "", "sink", "Laws/smithy/kotlin/runtime/io/SdkBuffer;", "limit", "runtime-core"})
public abstract class SdkSourceObserver
implements SdkSource {
    @NotNull
    private final SdkSource delegate;
    @NotNull
    private final Buffer.UnsafeCursor cursor;

    public SdkSourceObserver(@NotNull SdkSource delegate) {
        Intrinsics.checkNotNullParameter((Object)delegate, (String)"delegate");
        this.delegate = delegate;
        this.cursor = new Buffer.UnsafeCursor();
    }

    @Override
    public void close() {
        this.delegate.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long read(@NotNull SdkBuffer sink, long limit) {
        Intrinsics.checkNotNullParameter((Object)sink, (String)"sink");
        Buffer okioBuffer = ConvertKt.toOkio(sink);
        long rc = this.delegate.read(sink, limit);
        if (rc <= 0L) {
            return rc;
        }
        okioBuffer.readUnsafe(this.cursor);
        try {
            int toObserve;
            int length = this.cursor.seek(sink.getSize() - rc);
            for (long remaining = rc; remaining > 0L && length > 0; remaining -= (long)toObserve) {
                byte[] data;
                toObserve = Math.min(length, (int)remaining);
                if (this.cursor.data == null) {
                    byte[] cfr_ignored_0 = this.cursor.data;
                    String string = "Required value was null.";
                    throw new IllegalStateException(string.toString());
                }
                this.observe(data, this.cursor.start, toObserve);
                length = this.cursor.next();
            }
        }
        finally {
            this.cursor.close();
        }
        return rc;
    }

    public abstract void observe(@NotNull byte[] var1, int var2, int var3);
}

