/*
 * Decompiled with CFR 0.152.
 */
package aws.smithy.kotlin.runtime.io;

import aws.smithy.kotlin.runtime.io.SdkBuffer;
import aws.smithy.kotlin.runtime.io.SdkBufferedSink;
import aws.smithy.kotlin.runtime.io.SdkSource;
import aws.smithy.kotlin.runtime.io.internal.ConvertKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import okio.BufferedSink;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u0005\n\u0002\b\u0005\n\u0002\u0010\n\n\u0002\b\u0006\b \u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u000b\u001a\u00020\fH\u0016J\b\u0010\r\u001a\u00020\fH\u0016J\b\u0010\u000e\u001a\u00020\fH\u0016J\b\u0010\u000f\u001a\u00020\u0010H\u0016J\u0018\u0010\u0011\u001a\u00020\f2\u0006\u0010\u0012\u001a\u00020\u00062\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u0018\u0010\u0011\u001a\u00020\f2\u0006\u0010\u0012\u001a\u00020\u00152\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J \u0010\u0011\u001a\u00020\f2\u0006\u0010\u0012\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u0018H\u0016J\u0010\u0010\u001a\u001a\u00020\u00142\u0006\u0010\u0012\u001a\u00020\u0015H\u0016J\u0010\u0010\u001b\u001a\u00020\f2\u0006\u0010\u001c\u001a\u00020\u001dH\u0016J\u0010\u0010\u001e\u001a\u00020\f2\u0006\u0010\u001c\u001a\u00020\u0018H\u0016J\u0010\u0010\u001f\u001a\u00020\f2\u0006\u0010\u001c\u001a\u00020\u0018H\u0016J\u0010\u0010 \u001a\u00020\f2\u0006\u0010\u001c\u001a\u00020\u0014H\u0016J\u0010\u0010!\u001a\u00020\f2\u0006\u0010\u001c\u001a\u00020\u0014H\u0016J\u0010\u0010\"\u001a\u00020\f2\u0006\u0010\u001c\u001a\u00020#H\u0016J\u0010\u0010$\u001a\u00020\f2\u0006\u0010\u001c\u001a\u00020#H\u0016J \u0010%\u001a\u00020\f2\u0006\u0010&\u001a\u00020\u00102\u0006\u0010'\u001a\u00020\u00182\u0006\u0010(\u001a\u00020\u0018H\u0016R\u0014\u0010\u0005\u001a\u00020\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\u0002\u001a\u00020\u0003X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006)"}, d2={"Laws/smithy/kotlin/runtime/io/AbstractBufferedSinkAdapter;", "Laws/smithy/kotlin/runtime/io/SdkBufferedSink;", "delegate", "Lokio/BufferedSink;", "(Lokio/BufferedSink;)V", "buffer", "Laws/smithy/kotlin/runtime/io/SdkBuffer;", "getBuffer", "()Laws/smithy/kotlin/runtime/io/SdkBuffer;", "getDelegate", "()Lokio/BufferedSink;", "close", "", "emit", "flush", "toString", "", "write", "source", "byteCount", "", "Laws/smithy/kotlin/runtime/io/SdkSource;", "", "offset", "", "limit", "writeAll", "writeByte", "x", "", "writeInt", "writeIntLe", "writeLong", "writeLongLe", "writeShort", "", "writeShortLe", "writeUtf8", "string", "start", "endExclusive", "runtime-core"})
public abstract class AbstractBufferedSinkAdapter
implements SdkBufferedSink {
    @NotNull
    private final BufferedSink delegate;

    public AbstractBufferedSinkAdapter(@NotNull BufferedSink delegate) {
        Intrinsics.checkNotNullParameter((Object)delegate, (String)"delegate");
        this.delegate = delegate;
    }

    @NotNull
    protected final BufferedSink getDelegate() {
        return this.delegate;
    }

    @NotNull
    public String toString() {
        return this.delegate.toString();
    }

    @Override
    @NotNull
    public SdkBuffer getBuffer() {
        return ConvertKt.toSdk(this.delegate.getBuffer());
    }

    @Override
    public void write(@NotNull byte[] source, int offset, int limit) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        this.delegate.write(source, offset, limit);
    }

    @Override
    public void write(@NotNull SdkSource source, long byteCount) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        this.delegate.write(ConvertKt.toOkio(source), byteCount);
    }

    @Override
    public void write(@NotNull SdkBuffer source, long byteCount) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        this.delegate.write(ConvertKt.toOkio(source), byteCount);
    }

    @Override
    public long writeAll(@NotNull SdkSource source) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        return this.delegate.writeAll(ConvertKt.toOkio(source));
    }

    @Override
    public void writeUtf8(@NotNull String string, int start, int endExclusive) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"string");
        this.delegate.writeUtf8(string, start, endExclusive);
    }

    @Override
    public void writeByte(byte x) {
        this.delegate.writeByte((int)x);
    }

    @Override
    public void writeShort(short x) {
        this.delegate.writeShort((int)x);
    }

    @Override
    public void writeShortLe(short x) {
        this.delegate.writeShortLe((int)x);
    }

    @Override
    public void writeInt(int x) {
        this.delegate.writeInt(x);
    }

    @Override
    public void writeIntLe(int x) {
        this.delegate.writeIntLe(x);
    }

    @Override
    public void writeLong(long x) {
        this.delegate.writeLong(x);
    }

    @Override
    public void writeLongLe(long x) {
        this.delegate.writeLongLe(x);
    }

    @Override
    public void flush() {
        this.delegate.flush();
    }

    @Override
    public void emit() {
        this.delegate.emit();
    }

    @Override
    public void close() {
        this.delegate.close();
    }
}

