/*
 * Decompiled with CFR 0.152.
 */
package aws.smithy.kotlin.runtime.time;

import aws.smithy.kotlin.runtime.time.Instant;
import aws.smithy.kotlin.runtime.time.ParseResult;
import aws.smithy.kotlin.runtime.time.ParsedDate;
import aws.smithy.kotlin.runtime.time.ParsedDatetime;
import aws.smithy.kotlin.runtime.time.ParsedTime;
import aws.smithy.kotlin.runtime.time.ParserCombinatorsKt;
import aws.smithy.kotlin.runtime.time.ParsersKt;
import kotlin.Metadata;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=2, xi=48, d1={"\u0000F\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\f\n\u0002\b\t\u001aH\u0010\u0000\u001aB\u0012\u0013\u0012\u00110\u0002\u00a2\u0006\f\b\u0003\u0012\b\b\u0004\u0012\u0004\b\b(\u0005\u0012\u0013\u0012\u00110\u0006\u00a2\u0006\f\b\u0003\u0012\b\b\u0004\u0012\u0004\b\b(\u0007\u0012\n\u0012\b\u0012\u0004\u0012\u00020\t0\b0\u0001j\b\u0012\u0004\u0012\u00020\t`\nH\u0002\u001aR\u0010\u000b\u001aB\u0012\u0013\u0012\u00110\u0002\u00a2\u0006\f\b\u0003\u0012\b\b\u0004\u0012\u0004\b\b(\u0005\u0012\u0013\u0012\u00110\u0006\u00a2\u0006\f\b\u0003\u0012\b\b\u0004\u0012\u0004\b\b(\u0007\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\b0\u0001j\b\u0012\u0004\u0012\u00020\u0006`\n2\b\b\u0002\u0010\f\u001a\u00020\u0006H\u0002\u001aH\u0010\r\u001aB\u0012\u0013\u0012\u00110\u0002\u00a2\u0006\f\b\u0003\u0012\b\b\u0004\u0012\u0004\b\b(\u0005\u0012\u0013\u0012\u00110\u0006\u00a2\u0006\f\b\u0003\u0012\b\b\u0004\u0012\u0004\b\b(\u0007\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\b0\u0001j\b\u0012\u0004\u0012\u00020\u0006`\nH\u0002\u001aH\u0010\u000e\u001aB\u0012\u0013\u0012\u00110\u0002\u00a2\u0006\f\b\u0003\u0012\b\b\u0004\u0012\u0004\b\b(\u0005\u0012\u0013\u0012\u00110\u0006\u00a2\u0006\f\b\u0003\u0012\b\b\u0004\u0012\u0004\b\b(\u0007\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\b0\u0001j\b\u0012\u0004\u0012\u00020\u0006`\nH\u0002\u001aH\u0010\u000f\u001aB\u0012\u0013\u0012\u00110\u0002\u00a2\u0006\f\b\u0003\u0012\b\b\u0004\u0012\u0004\b\b(\u0005\u0012\u0013\u0012\u00110\u0006\u00a2\u0006\f\b\u0003\u0012\b\b\u0004\u0012\u0004\b\b(\u0007\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\b0\u0001j\b\u0012\u0004\u0012\u00020\u0006`\nH\u0002\u001aH\u0010\u0010\u001aB\u0012\u0013\u0012\u00110\u0002\u00a2\u0006\f\b\u0003\u0012\b\b\u0004\u0012\u0004\b\b(\u0005\u0012\u0013\u0012\u00110\u0006\u00a2\u0006\f\b\u0003\u0012\b\b\u0004\u0012\u0004\b\b(\u0007\u0012\n\u0012\b\u0012\u0004\u0012\u00020\t0\b0\u0001j\b\u0012\u0004\u0012\u00020\t`\nH\u0002\u001aH\u0010\u0011\u001aB\u0012\u0013\u0012\u00110\u0002\u00a2\u0006\f\b\u0003\u0012\b\b\u0004\u0012\u0004\b\b(\u0005\u0012\u0013\u0012\u00110\u0006\u00a2\u0006\f\b\u0003\u0012\b\b\u0004\u0012\u0004\b\b(\u0007\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00020\b0\u0001j\b\u0012\u0004\u0012\u00020\u0002`\nH\u0002\u001aH\u0010\u0012\u001aB\u0012\u0013\u0012\u00110\u0002\u00a2\u0006\f\b\u0003\u0012\b\b\u0004\u0012\u0004\b\b(\u0005\u0012\u0013\u0012\u00110\u0006\u00a2\u0006\f\b\u0003\u0012\b\b\u0004\u0012\u0004\b\b(\u0007\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00130\b0\u0001j\b\u0012\u0004\u0012\u00020\u0013`\nH\u0002\u001a\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0002H\u0000\u001a\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0016\u001a\u00020\u0002H\u0000\u001a\u0010\u0010\u0019\u001a\u00020\u00182\u0006\u0010\u0016\u001a\u00020\u0002H\u0000\u001aH\u0010\u001a\u001aB\u0012\u0013\u0012\u00110\u0002\u00a2\u0006\f\b\u0003\u0012\b\b\u0004\u0012\u0004\b\b(\u0005\u0012\u0013\u0012\u00110\u0006\u00a2\u0006\f\b\u0003\u0012\b\b\u0004\u0012\u0004\b\b(\u0007\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00130\b0\u0001j\b\u0012\u0004\u0012\u00020\u0013`\nH\u0002\u001aH\u0010\u001b\u001aB\u0012\u0013\u0012\u00110\u0002\u00a2\u0006\f\b\u0003\u0012\b\b\u0004\u0012\u0004\b\b(\u0005\u0012\u0013\u0012\u00110\u0006\u00a2\u0006\f\b\u0003\u0012\b\b\u0004\u0012\u0004\b\b(\u0007\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\b0\u0001j\b\u0012\u0004\u0012\u00020\u0006`\nH\u0002\u001a\u001e\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001d0\b2\u0006\u0010\u0016\u001a\u00020\u00022\u0006\u0010\u0007\u001a\u00020\u0006H\u0002\u001aH\u0010\u001e\u001aB\u0012\u0013\u0012\u00110\u0002\u00a2\u0006\f\b\u0003\u0012\b\b\u0004\u0012\u0004\b\b(\u0005\u0012\u0013\u0012\u00110\u0006\u00a2\u0006\f\b\u0003\u0012\b\b\u0004\u0012\u0004\b\b(\u0007\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\b0\u0001j\b\u0012\u0004\u0012\u00020\u0006`\nH\u0002\u001aH\u0010\u001f\u001aB\u0012\u0013\u0012\u00110\u0002\u00a2\u0006\f\b\u0003\u0012\b\b\u0004\u0012\u0004\b\b(\u0005\u0012\u0013\u0012\u00110\u0006\u00a2\u0006\f\b\u0003\u0012\b\b\u0004\u0012\u0004\b\b(\u0007\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\b0\u0001j\b\u0012\u0004\u0012\u00020\u0006`\nH\u0002\u001aH\u0010 \u001aB\u0012\u0013\u0012\u00110\u0002\u00a2\u0006\f\b\u0003\u0012\b\b\u0004\u0012\u0004\b\b(\u0005\u0012\u0013\u0012\u00110\u0006\u00a2\u0006\f\b\u0003\u0012\b\b\u0004\u0012\u0004\b\b(\u0007\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\b0\u0001j\b\u0012\u0004\u0012\u00020\u0006`\nH\u0002\u001aH\u0010!\u001aB\u0012\u0013\u0012\u00110\u0002\u00a2\u0006\f\b\u0003\u0012\b\b\u0004\u0012\u0004\b\b(\u0005\u0012\u0013\u0012\u00110\u0006\u00a2\u0006\f\b\u0003\u0012\b\b\u0004\u0012\u0004\b\b(\u0007\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\b0\u0001j\b\u0012\u0004\u0012\u00020\u0006`\nH\u0002\u001aH\u0010\"\u001aB\u0012\u0013\u0012\u00110\u0002\u00a2\u0006\f\b\u0003\u0012\b\b\u0004\u0012\u0004\b\b(\u0005\u0012\u0013\u0012\u00110\u0006\u00a2\u0006\f\b\u0003\u0012\b\b\u0004\u0012\u0004\b\b(\u0007\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\b0\u0001j\b\u0012\u0004\u0012\u00020\u0006`\nH\u0002\u001aH\u0010#\u001aB\u0012\u0013\u0012\u00110\u0002\u00a2\u0006\f\b\u0003\u0012\b\b\u0004\u0012\u0004\b\b(\u0005\u0012\u0013\u0012\u00110\u0006\u00a2\u0006\f\b\u0003\u0012\b\b\u0004\u0012\u0004\b\b(\u0007\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\b0\u0001j\b\u0012\u0004\u0012\u00020\u0006`\nH\u0002\u001aH\u0010$\u001aB\u0012\u0013\u0012\u00110\u0002\u00a2\u0006\f\b\u0003\u0012\b\b\u0004\u0012\u0004\b\b(\u0005\u0012\u0013\u0012\u00110\u0006\u00a2\u0006\f\b\u0003\u0012\b\b\u0004\u0012\u0004\b\b(\u0007\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\b0\u0001j\b\u0012\u0004\u0012\u00020\u0006`\nH\u0002\u001aH\u0010%\u001aB\u0012\u0013\u0012\u00110\u0002\u00a2\u0006\f\b\u0003\u0012\b\b\u0004\u0012\u0004\b\b(\u0005\u0012\u0013\u0012\u00110\u0006\u00a2\u0006\f\b\u0003\u0012\b\b\u0004\u0012\u0004\b\b(\u0007\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\b0\u0001j\b\u0012\u0004\u0012\u00020\u0006`\nH\u0002\u00a8\u0006&"}, d2={"date", "Lkotlin/Function2;", "", "Lkotlin/ParameterName;", "name", "str", "", "pos", "Laws/smithy/kotlin/runtime/time/ParseResult;", "Laws/smithy/kotlin/runtime/time/ParsedDate;", "Laws/smithy/kotlin/runtime/time/Parser;", "dateDay", "minDigits", "dateMonth", "dateMonthName", "dateYear", "dateYmd", "dayName", "iso8601Time", "Laws/smithy/kotlin/runtime/time/ParsedTime;", "parseEpoch", "Laws/smithy/kotlin/runtime/time/Instant;", "input", "parseIso8601", "Laws/smithy/kotlin/runtime/time/ParsedDatetime;", "parseRfc5322", "rfc5322Time", "signValue", "sp", "", "timeHour", "timeMin", "timeNanos", "timeSec", "tzOffsetHoursMins", "tzOffsetSecIso8601", "tzOffsetSecRfc5322", "tzUtc", "runtime-core"})
public final class ParsersKt {
    private static final Function2<String, Integer, ParseResult<Integer>> dateYear() {
        return ParserCombinatorsKt.takeNDigits(4);
    }

    private static final Function2<String, Integer, ParseResult<Integer>> dateMonth() {
        return ParserCombinatorsKt.nDigitsInRange(2, new IntRange(1, 12));
    }

    private static final Function2<String, Integer, ParseResult<Integer>> dateDay(int minDigits) {
        return ParserCombinatorsKt.mnDigitsInRange(minDigits, 2, new IntRange(1, 31));
    }

    static /* synthetic */ Function2 dateDay$default(int n, int n2, Object object) {
        if ((n2 & 1) != 0) {
            n = 2;
        }
        return ParsersKt.dateDay(n);
    }

    private static final Function2<String, Integer, ParseResult<ParsedDate>> dateYmd() {
        return dateYmd.1.INSTANCE;
    }

    private static final Function2<String, Integer, ParseResult<ParsedDate>> date() {
        return ParsersKt.dateYmd();
    }

    private static final Function2<String, Integer, ParseResult<Integer>> timeHour() {
        return ParserCombinatorsKt.nDigitsInRange(2, new IntRange(0, 24));
    }

    private static final Function2<String, Integer, ParseResult<Integer>> timeMin() {
        return ParserCombinatorsKt.nDigitsInRange(2, new IntRange(0, 59));
    }

    private static final Function2<String, Integer, ParseResult<Integer>> timeSec() {
        return ParserCombinatorsKt.nDigitsInRange(2, new IntRange(0, 60));
    }

    private static final Function2<String, Integer, ParseResult<Integer>> timeNanos() {
        return ParserCombinatorsKt.fraction(1, 9, 9);
    }

    private static final Function2<String, Integer, ParseResult<Integer>> signValue() {
        return signValue.1.INSTANCE;
    }

    private static final Function2<String, Integer, ParseResult<Integer>> tzOffsetHoursMins() {
        return tzOffsetHoursMins.1.INSTANCE;
    }

    private static final Function2<String, Integer, ParseResult<Integer>> tzUtc() {
        return ParserCombinatorsKt.map(ParserCombinatorsKt.oneOf("Zz"), tzUtc.1.INSTANCE);
    }

    private static final Function2<String, Integer, ParseResult<Integer>> tzOffsetSecIso8601() {
        return tzOffsetSecIso8601.1.INSTANCE;
    }

    private static final Function2<String, Integer, ParseResult<ParsedTime>> iso8601Time() {
        return iso8601Time.1.INSTANCE;
    }

    @NotNull
    public static final ParsedDatetime parseIso8601(@NotNull String input) {
        ParsedTime time;
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        ParseResult parseResult = (ParseResult)ParsersKt.date().invoke((Object)input, (Object)0);
        int pos0 = parseResult.component1();
        ParsedDate date = (ParsedDate)parseResult.component2();
        ParsedTime ts = pos0 == input.length() ? new ParsedTime(0, 0, 0, 0, 0) : (time = (ParsedTime)((ParseResult)ParserCombinatorsKt.preceded(ParserCombinatorsKt.oneOf("Tt"), ParsersKt.iso8601Time()).invoke((Object)input, (Object)pos0)).component2());
        return new ParsedDatetime(date.getYear(), date.getMonth(), date.getDay(), ts.getHour(), ts.getMin(), ts.getSec(), ts.getNs(), ts.getOffsetSec());
    }

    @NotNull
    public static final Instant parseEpoch(@NotNull String input) {
        Instant instant;
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        ParseResult parseResult = (ParseResult)ParserCombinatorsKt.takeMNDigitsLong(1, 19).invoke((Object)input, (Object)0);
        int pos0 = parseResult.component1();
        long secs = ((Number)parseResult.component2()).longValue();
        if (pos0 == input.length()) {
            instant = Instant.Companion.fromEpochSeconds(secs, 0);
        } else {
            int ns = ((Number)((ParseResult)ParserCombinatorsKt.preceded(ParserCombinatorsKt.char('.'), ParserCombinatorsKt.fraction(1, 9, 9)).invoke((Object)input, (Object)pos0)).component2()).intValue();
            instant = Instant.Companion.fromEpochSeconds(secs, ns);
        }
        return instant;
    }

    private static final Function2<String, Integer, ParseResult<String>> dayName() {
        Function2[] function2Array = new Function2[]{ParserCombinatorsKt.tag("Mon"), ParserCombinatorsKt.tag("Tue"), ParserCombinatorsKt.tag("Wed"), ParserCombinatorsKt.tag("Thu"), ParserCombinatorsKt.tag("Fri"), ParserCombinatorsKt.tag("Sat"), ParserCombinatorsKt.tag("Sun")};
        return ParserCombinatorsKt.alt(function2Array);
    }

    private static final ParseResult<Character> sp(String input, int pos) {
        return (ParseResult)ParserCombinatorsKt.char(' ').invoke((Object)input, (Object)pos);
    }

    private static final Function2<String, Integer, ParseResult<Integer>> dateMonthName() {
        return dateMonthName.1.INSTANCE;
    }

    private static final Function2<String, Integer, ParseResult<Integer>> tzOffsetSecRfc5322() {
        return tzOffsetSecRfc5322.1.INSTANCE;
    }

    private static final Function2<String, Integer, ParseResult<ParsedTime>> rfc5322Time() {
        return rfc5322Time.1.INSTANCE;
    }

    @NotNull
    public static final ParsedDatetime parseRfc5322(@NotNull String input) {
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        int pos0 = (!StringsKt.isBlank((CharSequence)input) && !ParserCombinatorsKt.isDigit(input.charAt(0)) ? (ParseResult)ParserCombinatorsKt.map(ParserCombinatorsKt.then(ParserCombinatorsKt.then(ParsersKt.dayName(), ParserCombinatorsKt.char(',')), parseRfc5322.1.INSTANCE), parseRfc5322.2.INSTANCE).invoke((Object)input, (Object)0) : new ParseResult(0, null)).component1();
        ParseResult parseResult = (ParseResult)ParsersKt.dateDay(1).invoke((Object)input, (Object)pos0);
        int pos1 = parseResult.component1();
        int day = ((Number)parseResult.component2()).intValue();
        ParseResult parseResult2 = (ParseResult)ParserCombinatorsKt.preceded(parseRfc5322.3.INSTANCE, ParsersKt.dateMonthName()).invoke((Object)input, (Object)pos1);
        int pos2 = parseResult2.component1();
        int month = ((Number)parseResult2.component2()).intValue();
        ParseResult parseResult3 = (ParseResult)ParserCombinatorsKt.preceded(parseRfc5322.4.INSTANCE, ParsersKt.dateYear()).invoke((Object)input, (Object)pos2);
        int pos3 = parseResult3.component1();
        int year = ((Number)parseResult3.component2()).intValue();
        ParsedTime ts = (ParsedTime)((ParseResult)ParserCombinatorsKt.preceded(parseRfc5322.5.INSTANCE, ParsersKt.rfc5322Time()).invoke((Object)input, (Object)pos3)).component2();
        return new ParsedDatetime(year, month, day, ts.getHour(), ts.getMin(), ts.getSec(), ts.getNs(), ts.getOffsetSec());
    }

    public static final /* synthetic */ Function2 access$dateYear() {
        return ParsersKt.dateYear();
    }

    public static final /* synthetic */ Function2 access$dateMonth() {
        return ParsersKt.dateMonth();
    }

    public static final /* synthetic */ Function2 access$signValue() {
        return ParsersKt.signValue();
    }

    public static final /* synthetic */ Function2 access$timeHour() {
        return ParsersKt.timeHour();
    }

    public static final /* synthetic */ Function2 access$timeMin() {
        return ParsersKt.timeMin();
    }

    public static final /* synthetic */ Function2 access$tzUtc() {
        return ParsersKt.tzUtc();
    }

    public static final /* synthetic */ Function2 access$tzOffsetHoursMins() {
        return ParsersKt.tzOffsetHoursMins();
    }

    public static final /* synthetic */ Function2 access$timeSec() {
        return ParsersKt.timeSec();
    }

    public static final /* synthetic */ Function2 access$timeNanos() {
        return ParsersKt.timeNanos();
    }

    public static final /* synthetic */ Function2 access$tzOffsetSecIso8601() {
        return ParsersKt.tzOffsetSecIso8601();
    }

    public static final /* synthetic */ ParseResult access$sp(String input, int pos) {
        return ParsersKt.sp(input, pos);
    }

    public static final /* synthetic */ Function2 access$tzOffsetSecRfc5322() {
        return ParsersKt.tzOffsetSecRfc5322();
    }
}

