/*
 * Decompiled with CFR 0.152.
 */
package aws.smithy.kotlin.runtime.retries.delay;

import aws.smithy.kotlin.runtime.retries.delay.DelayProvider;
import aws.smithy.kotlin.runtime.retries.delay.ExponentialBackoffWithJitterOptions;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.random.Random;
import kotlin.time.Duration;
import kotlin.time.DurationUnit;
import kotlinx.coroutines.DelayKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0019\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\rR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006\u000e"}, d2={"Laws/smithy/kotlin/runtime/retries/delay/ExponentialBackoffWithJitter;", "Laws/smithy/kotlin/runtime/retries/delay/DelayProvider;", "options", "Laws/smithy/kotlin/runtime/retries/delay/ExponentialBackoffWithJitterOptions;", "(Laws/smithy/kotlin/runtime/retries/delay/ExponentialBackoffWithJitterOptions;)V", "getOptions", "()Laws/smithy/kotlin/runtime/retries/delay/ExponentialBackoffWithJitterOptions;", "random", "Lkotlin/random/Random$Default;", "backoff", "", "attempt", "", "(ILkotlin/coroutines/Continuation;)Ljava/lang/Object;", "runtime-core"})
public final class ExponentialBackoffWithJitter
implements DelayProvider {
    @NotNull
    private final ExponentialBackoffWithJitterOptions options;
    @NotNull
    private final Random.Default random;

    public ExponentialBackoffWithJitter(@NotNull ExponentialBackoffWithJitterOptions options) {
        Intrinsics.checkNotNullParameter((Object)options, (String)"options");
        this.options = options;
        this.random = Random.Default;
    }

    public /* synthetic */ ExponentialBackoffWithJitter(ExponentialBackoffWithJitterOptions exponentialBackoffWithJitterOptions, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            exponentialBackoffWithJitterOptions = ExponentialBackoffWithJitterOptions.Companion.getDefault();
        }
        this(exponentialBackoffWithJitterOptions);
    }

    @NotNull
    public final ExponentialBackoffWithJitterOptions getOptions() {
        return this.options;
    }

    @Override
    @Nullable
    public Object backoff(int attempt, @NotNull Continuation<? super Unit> $completion) {
        if (!(attempt > 0)) {
            boolean bl = false;
            String string = "attempt was " + attempt + " but must be greater than 0";
            throw new IllegalArgumentException(string.toString());
        }
        double calculatedDelayMs = (double)Duration.getInWholeMilliseconds-impl((long)this.options.getInitialDelay-UwyO8pc()) * Math.pow(this.options.getScaleFactor(), attempt - 1);
        double maxDelayMs = Math.min(calculatedDelayMs, Duration.toDouble-impl((long)this.options.getMaxBackoff-UwyO8pc(), (DurationUnit)DurationUnit.MILLISECONDS));
        double jitterProportion = this.options.getJitter() > 0.0 ? this.random.nextDouble(this.options.getJitter()) : 0.0;
        double delayMs = maxDelayMs * (1.0 - jitterProportion);
        Object object = DelayKt.delay((long)((long)delayMs), $completion);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    public ExponentialBackoffWithJitter() {
        this(null, 1, null);
    }
}

