/*
 * Decompiled with CFR 0.152.
 */
package aws.smithy.kotlin.runtime.telemetry.logging.slf4j;

import aws.smithy.kotlin.runtime.telemetry.logging.Logger;
import aws.smithy.kotlin.runtime.telemetry.logging.LoggerProvider;
import aws.smithy.kotlin.runtime.telemetry.logging.slf4j.Slf4j1xLoggerAdapter;
import aws.smithy.kotlin.runtime.telemetry.logging.slf4j.Slf4j2xLoggerAdapter;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.slf4j.LoggerFactory;
import org.slf4j.event.Level;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Laws/smithy/kotlin/runtime/telemetry/logging/slf4j/Slf4jLoggerProvider;", "Laws/smithy/kotlin/runtime/telemetry/logging/LoggerProvider;", "<init>", "()V", "useSlf4j2x", "", "getOrCreateLogger", "Laws/smithy/kotlin/runtime/telemetry/logging/Logger;", "name", "", "logging-slf4j2"})
public final class Slf4jLoggerProvider
implements LoggerProvider {
    @NotNull
    public static final Slf4jLoggerProvider INSTANCE;
    private static final boolean useSlf4j2x;

    private Slf4jLoggerProvider() {
    }

    @NotNull
    public Logger getOrCreateLogger(@NotNull String name) {
        Logger logger;
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        org.slf4j.Logger sl4fjLogger = LoggerFactory.getLogger((String)name);
        if (useSlf4j2x) {
            Intrinsics.checkNotNull((Object)sl4fjLogger);
            logger = new Slf4j2xLoggerAdapter(sl4fjLogger);
        } else {
            Intrinsics.checkNotNull((Object)sl4fjLogger);
            logger = new Slf4j1xLoggerAdapter(sl4fjLogger);
        }
        return logger;
    }

    static {
        boolean bl;
        INSTANCE = new Slf4jLoggerProvider();
        try {
            org.slf4j.Logger logger = LoggerFactory.getLogger((String)"version_check");
            logger.atLevel(Level.DEBUG);
            bl = true;
        }
        catch (NoSuchMethodError e) {
            LoggerFactory.getLogger(Slf4jLoggerProvider.class).warn("falling back to SLF4J 1.x compatible binding");
            bl = false;
        }
        useSlf4j2x = bl;
    }
}

