/*
 * Decompiled with CFR 0.152.
 */
package aws.smithy.kotlin.runtime.telemetry.logging.slf4j;

import aws.smithy.kotlin.runtime.telemetry.logging.LogLevel;
import aws.smithy.kotlin.runtime.telemetry.logging.Logger;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0003\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b \u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J \u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\n2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fH\u0016J \u0010\u000e\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\n2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fH\u0016J \u0010\u000f\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\n2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fH\u0016J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J \u0010\u0014\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\n2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fH\u0016J \u0010\u0015\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\n2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fH\u0016R\u0014\u0010\u0002\u001a\u00020\u0003X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0016"}, d2={"Laws/smithy/kotlin/runtime/telemetry/logging/slf4j/AbstractSlf4jLoggerAdapter;", "Laws/smithy/kotlin/runtime/telemetry/logging/Logger;", "delegate", "Lorg/slf4j/Logger;", "(Lorg/slf4j/Logger;)V", "getDelegate", "()Lorg/slf4j/Logger;", "debug", "", "t", "", "msg", "Lkotlin/Function0;", "", "error", "info", "isEnabledFor", "", "level", "Laws/smithy/kotlin/runtime/telemetry/logging/LogLevel;", "trace", "warn", "logging-slf4j2"})
public abstract class AbstractSlf4jLoggerAdapter
implements Logger {
    @NotNull
    private final org.slf4j.Logger delegate;

    public AbstractSlf4jLoggerAdapter(@NotNull org.slf4j.Logger delegate) {
        Intrinsics.checkNotNullParameter((Object)delegate, (String)"delegate");
        this.delegate = delegate;
    }

    @NotNull
    protected final org.slf4j.Logger getDelegate() {
        return this.delegate;
    }

    public void trace(@Nullable Throwable t, @NotNull Function0<String> msg) {
        Intrinsics.checkNotNullParameter(msg, (String)"msg");
        if (!this.isEnabledFor(LogLevel.Trace)) {
            return;
        }
        if (t != null) {
            this.delegate.trace((String)msg.invoke(), t);
        } else {
            this.delegate.trace((String)msg.invoke());
        }
    }

    public void debug(@Nullable Throwable t, @NotNull Function0<String> msg) {
        Intrinsics.checkNotNullParameter(msg, (String)"msg");
        if (!this.isEnabledFor(LogLevel.Debug)) {
            return;
        }
        if (t != null) {
            this.delegate.debug((String)msg.invoke(), t);
        } else {
            this.delegate.debug((String)msg.invoke());
        }
    }

    public void info(@Nullable Throwable t, @NotNull Function0<String> msg) {
        Intrinsics.checkNotNullParameter(msg, (String)"msg");
        if (!this.isEnabledFor(LogLevel.Info)) {
            return;
        }
        if (t != null) {
            this.delegate.info((String)msg.invoke(), t);
        } else {
            this.delegate.info((String)msg.invoke());
        }
    }

    public void warn(@Nullable Throwable t, @NotNull Function0<String> msg) {
        Intrinsics.checkNotNullParameter(msg, (String)"msg");
        if (!this.isEnabledFor(LogLevel.Warning)) {
            return;
        }
        if (t != null) {
            this.delegate.warn((String)msg.invoke(), t);
        } else {
            this.delegate.warn((String)msg.invoke());
        }
    }

    public void error(@Nullable Throwable t, @NotNull Function0<String> msg) {
        Intrinsics.checkNotNullParameter(msg, (String)"msg");
        if (!this.isEnabledFor(LogLevel.Error)) {
            return;
        }
        if (t != null) {
            this.delegate.error((String)msg.invoke(), t);
        } else {
            this.delegate.error((String)msg.invoke());
        }
    }

    public boolean isEnabledFor(@NotNull LogLevel level) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        switch (WhenMappings.$EnumSwitchMapping$0[level.ordinal()]) {
            case 1: {
                bl = this.delegate.isTraceEnabled();
                break;
            }
            case 2: {
                bl = this.delegate.isDebugEnabled();
                break;
            }
            case 3: {
                bl = this.delegate.isInfoEnabled();
                break;
            }
            case 4: {
                bl = this.delegate.isWarnEnabled();
                break;
            }
            case 5: {
                bl = this.delegate.isErrorEnabled();
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return bl;
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[LogLevel.values().length];
            try {
                nArray[LogLevel.Trace.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[LogLevel.Debug.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[LogLevel.Info.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[LogLevel.Warning.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[LogLevel.Error.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

