/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

package aws.smithy.kotlin.runtime.io

/**
 * Exception thrown when a content-mutation method such as `write` is invoked upon a read-only buffer.
 */
class ReadOnlyBufferException : UnsupportedOperationException {
    constructor() : super()

    constructor(message: String?) : super(message)

    constructor(message: String?, cause: Throwable?) : super(message, cause)

    constructor(cause: Throwable?) : super(cause)
}

/**
 * Exception thrown when a content-mutation method such as `write` is invoked upon a buffer that cannot grow
 */
class FixedBufferSizeException : UnsupportedOperationException {
    constructor() : super()

    constructor(message: String?) : super(message)

    constructor(message: String?, cause: Throwable?) : super(message, cause)

    constructor(cause: Throwable?) : super(cause)
}
