/*
 * Decompiled with CFR 0.152.
 */
package aws.smithy.kotlin.runtime.http.interceptors;

import aws.smithy.kotlin.runtime.InternalApi;
import aws.smithy.kotlin.runtime.http.HttpBody;
import aws.smithy.kotlin.runtime.http.HttpBodyKt;
import aws.smithy.kotlin.runtime.http.interceptors.LengthValidatingByteReadChannel;
import aws.smithy.kotlin.runtime.http.interceptors.LengthValidatingSource;
import aws.smithy.kotlin.runtime.io.SdkByteReadChannel;
import aws.smithy.kotlin.runtime.io.SdkSource;
import java.io.EOFException;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u0000\u0018\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u001f\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\b\u0010\u0004\u001a\u0004\u0018\u00010\u0003H\u0002\u00a2\u0006\u0002\u0010\u0005\u001a\u0014\u0010\u0006\u001a\u00020\u0007*\u00020\u00072\u0006\u0010\b\u001a\u00020\u0003H\u0003\u00a8\u0006\t"}, d2={"validateContentLength", "", "expected", "", "actual", "(JLjava/lang/Long;)V", "toLengthValidatingBody", "Laws/smithy/kotlin/runtime/http/HttpBody;", "expectedContentLength", "http-client"})
@SourceDebugExtension(value={"SMAP\nResponseLengthValidationInterceptor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ResponseLengthValidationInterceptor.kt\naws/smithy/kotlin/runtime/http/interceptors/ResponseLengthValidationInterceptorKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,92:1\n1#2:93\n*E\n"})
public final class ResponseLengthValidationInterceptorKt {
    @InternalApi
    private static final HttpBody toLengthValidatingBody(HttpBody $this$toLengthValidatingBody, long expectedContentLength) {
        HttpBody httpBody;
        HttpBody httpBody2 = $this$toLengthValidatingBody;
        if (httpBody2 instanceof HttpBody.SourceContent) {
            httpBody = HttpBodyKt.toHttpBody((SdkSource)new LengthValidatingSource(((HttpBody.SourceContent)$this$toLengthValidatingBody).readFrom(), expectedContentLength), (Long)$this$toLengthValidatingBody.getContentLength());
        } else if (httpBody2 instanceof HttpBody.ChannelContent) {
            httpBody = HttpBodyKt.toHttpBody((SdkByteReadChannel)new LengthValidatingByteReadChannel(((HttpBody.ChannelContent)$this$toLengthValidatingBody).readFrom(), expectedContentLength), (Long)$this$toLengthValidatingBody.getContentLength());
        } else if (httpBody2 instanceof HttpBody.Bytes) {
            HttpBody httpBody3 = $this$toLengthValidatingBody;
            HttpBody.Bytes it = (HttpBody.Bytes)httpBody3;
            boolean bl = false;
            ResponseLengthValidationInterceptorKt.validateContentLength(expectedContentLength, $this$toLengthValidatingBody.getContentLength());
            httpBody = httpBody3;
        } else if (Intrinsics.areEqual((Object)httpBody2, (Object)HttpBody.Empty.INSTANCE)) {
            HttpBody httpBody4;
            HttpBody it = httpBody4 = $this$toLengthValidatingBody;
            boolean bl = false;
            ResponseLengthValidationInterceptorKt.validateContentLength(expectedContentLength, 0L);
            httpBody = httpBody4;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return httpBody;
    }

    private static final void validateContentLength(long expected, Long actual) {
        Long l = actual;
        if (l == null || expected != l) {
            if (actual != null && expected > actual) {
                throw new EOFException("Expected " + expected + " bytes but received " + actual + " bytes. The connection may have been closed prematurely.");
            }
            throw new EOFException("Expected " + expected + " bytes but received " + actual + " bytes.");
        }
    }

    public static final /* synthetic */ HttpBody access$toLengthValidatingBody(HttpBody $receiver, long expectedContentLength) {
        return ResponseLengthValidationInterceptorKt.toLengthValidatingBody($receiver, expectedContentLength);
    }

    public static final /* synthetic */ void access$validateContentLength(long expected, Long actual) {
        ResponseLengthValidationInterceptorKt.validateContentLength(expected, actual);
    }
}

