/*
 * Decompiled with CFR 0.152.
 */
package aws.smithy.kotlin.runtime.http.engine;

import aws.smithy.kotlin.runtime.client.config.ClientSettings;
import aws.smithy.kotlin.runtime.config.EnvironmentSetting;
import aws.smithy.kotlin.runtime.config.EnvironmentSettingKt;
import aws.smithy.kotlin.runtime.config.TlsVersion;
import aws.smithy.kotlin.runtime.http.config.HttpEngineConfigDsl;
import aws.smithy.kotlin.runtime.http.engine.AlpnId;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u0000 \u00112\u00020\u0001:\u0002\u0010\u0011B\u000f\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\r\u0010\u000e\u001a\u00020\u0003H\u0000\u00a2\u0006\u0002\b\u000fR\u0017\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0013\u0010\n\u001a\u0004\u0018\u00010\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u0012"}, d2={"Laws/smithy/kotlin/runtime/http/engine/TlsContext;", "", "builder", "Laws/smithy/kotlin/runtime/http/engine/TlsContext$Builder;", "(Laws/smithy/kotlin/runtime/http/engine/TlsContext$Builder;)V", "alpn", "", "Laws/smithy/kotlin/runtime/http/engine/AlpnId;", "getAlpn", "()Ljava/util/List;", "minVersion", "Laws/smithy/kotlin/runtime/config/TlsVersion;", "getMinVersion", "()Laws/smithy/kotlin/runtime/config/TlsVersion;", "toBuilder", "toBuilder$http_client", "Builder", "Companion", "http-client"})
public final class TlsContext {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final List<AlpnId> alpn;
    @Nullable
    private final TlsVersion minVersion;
    @NotNull
    private static final TlsContext Default = new TlsContext(new Builder());

    public TlsContext(@NotNull Builder builder) {
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        this.alpn = builder.getAlpn();
        TlsVersion tlsVersion = builder.getMinVersion();
        if (tlsVersion == null) {
            tlsVersion = (TlsVersion)EnvironmentSettingKt.resolve$default((EnvironmentSetting)ClientSettings.INSTANCE.getMinTlsVersion(), null, (int)1, null);
        }
        this.minVersion = tlsVersion;
    }

    @NotNull
    public final List<AlpnId> getAlpn() {
        return this.alpn;
    }

    @Nullable
    public final TlsVersion getMinVersion() {
        return this.minVersion;
    }

    @NotNull
    public final Builder toBuilder$http_client() {
        Builder builder;
        Builder $this$toBuilder_u24lambda_u240 = builder = new Builder();
        boolean bl = false;
        $this$toBuilder_u24lambda_u240.setAlpn(this.alpn);
        $this$toBuilder_u24lambda_u240.setMinVersion(this.minVersion);
        return builder;
    }

    @HttpEngineConfigDsl
    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0007\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002R \u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR\u001c\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0010"}, d2={"Laws/smithy/kotlin/runtime/http/engine/TlsContext$Builder;", "", "()V", "alpn", "", "Laws/smithy/kotlin/runtime/http/engine/AlpnId;", "getAlpn", "()Ljava/util/List;", "setAlpn", "(Ljava/util/List;)V", "minVersion", "Laws/smithy/kotlin/runtime/config/TlsVersion;", "getMinVersion", "()Laws/smithy/kotlin/runtime/config/TlsVersion;", "setMinVersion", "(Laws/smithy/kotlin/runtime/config/TlsVersion;)V", "http-client"})
    public static final class Builder {
        @NotNull
        private List<? extends AlpnId> alpn = CollectionsKt.emptyList();
        @Nullable
        private TlsVersion minVersion;

        @NotNull
        public final List<AlpnId> getAlpn() {
            return this.alpn;
        }

        public final void setAlpn(@NotNull List<? extends AlpnId> list) {
            Intrinsics.checkNotNullParameter(list, (String)"<set-?>");
            this.alpn = list;
        }

        @Nullable
        public final TlsVersion getMinVersion() {
            return this.minVersion;
        }

        public final void setMinVersion(@Nullable TlsVersion tlsVersion) {
            this.minVersion = tlsVersion;
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\"\u0010\u0007\u001a\u00020\u00042\u0017\u0010\b\u001a\u0013\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\t\u00a2\u0006\u0002\b\fH\u0086\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\r"}, d2={"Laws/smithy/kotlin/runtime/http/engine/TlsContext$Companion;", "", "()V", "Default", "Laws/smithy/kotlin/runtime/http/engine/TlsContext;", "getDefault", "()Laws/smithy/kotlin/runtime/http/engine/TlsContext;", "invoke", "block", "Lkotlin/Function1;", "Laws/smithy/kotlin/runtime/http/engine/TlsContext$Builder;", "", "Lkotlin/ExtensionFunctionType;", "http-client"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final TlsContext invoke(@NotNull Function1<? super Builder, Unit> block) {
            Intrinsics.checkNotNullParameter(block, (String)"block");
            Builder builder = new Builder();
            block.invoke((Object)builder);
            return new TlsContext(builder);
        }

        @NotNull
        public final TlsContext getDefault() {
            return Default;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

