/*
 * Decompiled with CFR 0.152.
 */
package aws.smithy.kotlin.runtime.hashing;

import aws.smithy.kotlin.runtime.hashing.HashFunction;
import aws.smithy.kotlin.runtime.hashing.HashFunctionKt;
import aws.smithy.kotlin.runtime.util.InternalApi;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=2, xi=48, d1={"\u0000\"\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0005\n\u0000\u001a \u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u00012\u0006\u0010\u0004\u001a\u00020\u0005H\u0007\u001a*\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u00012\u0010\u0010\u0006\u001a\f\u0012\u0004\u0012\u00020\u00050\u0007j\u0002`\bH\u0007\u001a\u0014\u0010\t\u001a\u00020\u0001*\u00020\u00012\u0006\u0010\u0004\u001a\u00020\u0005H\u0002\u001a\u0015\u0010\n\u001a\u00020\u0001*\u00020\u00012\u0006\u0010\u000b\u001a\u00020\fH\u0082\u0004\u00a8\u0006\r"}, d2={"hmac", "", "key", "message", "hashFunction", "Laws/smithy/kotlin/runtime/hashing/HashFunction;", "hashSupplier", "Lkotlin/Function0;", "Laws/smithy/kotlin/runtime/hashing/HashSupplier;", "resizeToBlock", "xor", "byte", "", "hashing"})
public final class HmacKt {
    @InternalApi
    @NotNull
    public static final byte[] hmac(@NotNull byte[] key, @NotNull byte[] message, @NotNull HashFunction hashFunction) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        Intrinsics.checkNotNullParameter((Object)hashFunction, (String)"hashFunction");
        byte[] blockSizedKey = HmacKt.resizeToBlock(key, hashFunction);
        byte[] innerKey = HmacKt.xor(blockSizedKey, (byte)54);
        byte[] outerKey = HmacKt.xor(blockSizedKey, (byte)92);
        HashFunction.DefaultImpls.update$default(hashFunction, innerKey, 0, 0, 6, null);
        HashFunction.DefaultImpls.update$default(hashFunction, message, 0, 0, 6, null);
        byte[] innerHash = hashFunction.digest();
        HashFunction.DefaultImpls.update$default(hashFunction, outerKey, 0, 0, 6, null);
        HashFunction.DefaultImpls.update$default(hashFunction, innerHash, 0, 0, 6, null);
        return hashFunction.digest();
    }

    @InternalApi
    @NotNull
    public static final byte[] hmac(@NotNull byte[] key, @NotNull byte[] message, @NotNull Function0<? extends HashFunction> hashSupplier) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        Intrinsics.checkNotNullParameter(hashSupplier, (String)"hashSupplier");
        return HmacKt.hmac(key, message, (HashFunction)hashSupplier.invoke());
    }

    private static final byte[] resizeToBlock(byte[] $this$resizeToBlock, HashFunction hashFunction) {
        byte[] byArray;
        byte[] truncated;
        int blockSize = hashFunction.getBlockSizeBytes();
        byte[] byArray2 = truncated = $this$resizeToBlock.length > blockSize ? HashFunctionKt.hash($this$resizeToBlock, hashFunction) : $this$resizeToBlock;
        if (truncated.length < blockSize) {
            byte[] byArray3 = Arrays.copyOf(truncated, blockSize);
            byArray = byArray3;
            Intrinsics.checkNotNullExpressionValue((Object)byArray3, (String)"copyOf(this, newSize)");
        } else {
            byArray = truncated;
        }
        return byArray;
    }

    private static final byte[] xor(byte[] $this$xor, byte by) {
        int n = 0;
        int n2 = $this$xor.length;
        byte[] byArray = new byte[n2];
        while (n < n2) {
            int n3 = n++;
            byArray[n3] = (byte)($this$xor[n3] ^ by);
        }
        return byArray;
    }
}

