/*
 * Decompiled with CFR 0.152.
 */
package aws.smithy.kotlin.runtime.auth.awssigning.internal;

import aws.smithy.kotlin.runtime.ClientException;
import aws.smithy.kotlin.runtime.InternalApi;
import aws.smithy.kotlin.runtime.auth.awssigning.AwsChunkedByteReadChannel;
import aws.smithy.kotlin.runtime.auth.awssigning.AwsChunkedSource;
import aws.smithy.kotlin.runtime.auth.awssigning.AwsSigner;
import aws.smithy.kotlin.runtime.auth.awssigning.AwsSigningConfig;
import aws.smithy.kotlin.runtime.auth.awssigning.HashSpecification;
import aws.smithy.kotlin.runtime.http.DeferredHeaders;
import aws.smithy.kotlin.runtime.http.Headers;
import aws.smithy.kotlin.runtime.http.HeadersBuilder;
import aws.smithy.kotlin.runtime.http.HttpBody;
import aws.smithy.kotlin.runtime.http.HttpBodyKt;
import aws.smithy.kotlin.runtime.http.request.HttpRequestBuilder;
import aws.smithy.kotlin.runtime.io.SdkBuffer;
import aws.smithy.kotlin.runtime.io.SdkBufferedSink;
import aws.smithy.kotlin.runtime.io.SdkByteReadChannel;
import aws.smithy.kotlin.runtime.io.SdkSource;
import java.util.Comparator;
import java.util.Locale;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000P\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u0014\u0010\u0003\u001a\u00020\u0004*\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0000\u001a\u0014\u0010\b\u001a\u00020\u0004*\u00020\u00052\u0006\u0010\t\u001a\u00020\nH\u0000\u001a\f\u0010\u0017\u001a\u00020\u0004*\u00020\u0018H\u0007\u001a,\u0010\u0019\u001a\u00020\u0004*\u00020\u00182\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u00122\u0006\u0010\t\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001fH\u0007\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\"\u001e\u0010\u000b\u001a\u00020\f*\u00020\r8FX\u0087\u0004\u00a2\u0006\f\u0012\u0004\b\u000e\u0010\u000f\u001a\u0004\b\u000b\u0010\u0010\"\u001e\u0010\u0011\u001a\u00020\f*\u00020\u00128FX\u0087\u0004\u00a2\u0006\f\u0012\u0004\b\u0013\u0010\u0014\u001a\u0004\b\u0015\u0010\u0016\u00a8\u0006 "}, d2={"CHUNK_SIZE_BYTES", "", "AWS_CHUNKED_THRESHOLD", "writeTrailers", "", "Laws/smithy/kotlin/runtime/io/SdkBuffer;", "trailers", "Laws/smithy/kotlin/runtime/http/Headers;", "writeTrailerSignature", "signature", "", "isEligibleForAwsChunkedStreaming", "", "Laws/smithy/kotlin/runtime/http/HttpBody;", "isEligibleForAwsChunkedStreaming$annotations", "(Laws/smithy/kotlin/runtime/http/HttpBody;)V", "(Laws/smithy/kotlin/runtime/http/HttpBody;)Z", "useAwsChunkedEncoding", "Laws/smithy/kotlin/runtime/auth/awssigning/AwsSigningConfig;", "getUseAwsChunkedEncoding$annotations", "(Laws/smithy/kotlin/runtime/auth/awssigning/AwsSigningConfig;)V", "getUseAwsChunkedEncoding", "(Laws/smithy/kotlin/runtime/auth/awssigning/AwsSigningConfig;)Z", "setAwsChunkedHeaders", "Laws/smithy/kotlin/runtime/http/request/HttpRequestBuilder;", "setAwsChunkedBody", "signer", "Laws/smithy/kotlin/runtime/auth/awssigning/AwsSigner;", "signingConfig", "", "trailingHeaders", "Laws/smithy/kotlin/runtime/http/DeferredHeaders;", "aws-signing-common"})
@SourceDebugExtension(value={"SMAP\nAwsChunkedUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AwsChunkedUtil.kt\naws/smithy/kotlin/runtime/auth/awssigning/internal/AwsChunkedUtilKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,101:1\n1053#2:102\n1863#2,2:103\n*S KotlinDebug\n*F\n+ 1 AwsChunkedUtil.kt\naws/smithy/kotlin/runtime/auth/awssigning/internal/AwsChunkedUtilKt\n*L\n28#1:102\n29#1:103,2\n*E\n"})
public final class AwsChunkedUtilKt {
    public static final int CHUNK_SIZE_BYTES = 65536;
    public static final int AWS_CHUNKED_THRESHOLD = 0x100000;

    public static final void writeTrailers(@NotNull SdkBuffer $this$writeTrailers, @NotNull Headers trailers) {
        Intrinsics.checkNotNullParameter((Object)$this$writeTrailers, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)trailers, (String)"trailers");
        Iterable $this$sortedBy$iv = trailers.entries();
        boolean $i$f$sortedBy = false;
        Iterable $this$forEach$iv = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                Map.Entry entry = (Map.Entry)a;
                boolean bl = false;
                String string = ((String)entry.getKey()).toLowerCase(Locale.ROOT);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
                entry = (Map.Entry)b;
                Comparable comparable = (Comparable)((Object)string);
                bl = false;
                String string2 = ((String)entry.getKey()).toLowerCase(Locale.ROOT);
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toLowerCase(...)");
                return ComparisonsKt.compareValues((Comparable)comparable, (Comparable)((Comparable)((Object)string2)));
            }
        });
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Map.Entry entry = (Map.Entry)element$iv;
            boolean bl = false;
            SdkBufferedSink.DefaultImpls.writeUtf8$default((SdkBufferedSink)((SdkBufferedSink)$this$writeTrailers), (String)((String)entry.getKey()), (int)0, (int)0, (int)6, null);
            SdkBufferedSink.DefaultImpls.writeUtf8$default((SdkBufferedSink)((SdkBufferedSink)$this$writeTrailers), (String)":", (int)0, (int)0, (int)6, null);
            SdkBufferedSink.DefaultImpls.writeUtf8$default((SdkBufferedSink)((SdkBufferedSink)$this$writeTrailers), (String)CollectionsKt.joinToString$default((Iterable)((Iterable)entry.getValue()), (CharSequence)",", null, null, (int)0, null, AwsChunkedUtilKt::writeTrailers$lambda$2$lambda$1, (int)30, null), (int)0, (int)0, (int)6, null);
            SdkBufferedSink.DefaultImpls.writeUtf8$default((SdkBufferedSink)((SdkBufferedSink)$this$writeTrailers), (String)"\r\n", (int)0, (int)0, (int)6, null);
        }
    }

    public static final void writeTrailerSignature(@NotNull SdkBuffer $this$writeTrailerSignature, @NotNull String signature) {
        Intrinsics.checkNotNullParameter((Object)$this$writeTrailerSignature, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)signature, (String)"signature");
        SdkBufferedSink.DefaultImpls.writeUtf8$default((SdkBufferedSink)((SdkBufferedSink)$this$writeTrailerSignature), (String)("x-amz-trailer-signature:" + signature + "\r\n"), (int)0, (int)0, (int)6, null);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean isEligibleForAwsChunkedStreaming(@NotNull HttpBody $this$isEligibleForAwsChunkedStreaming) {
        Intrinsics.checkNotNullParameter((Object)$this$isEligibleForAwsChunkedStreaming, (String)"<this>");
        if (!($this$isEligibleForAwsChunkedStreaming instanceof HttpBody.SourceContent)) {
            if (!($this$isEligibleForAwsChunkedStreaming instanceof HttpBody.ChannelContent)) return false;
        }
        if ($this$isEligibleForAwsChunkedStreaming.getContentLength() == null) return false;
        if ($this$isEligibleForAwsChunkedStreaming.isOneShot()) return true;
        Long l = $this$isEligibleForAwsChunkedStreaming.getContentLength();
        Intrinsics.checkNotNull((Object)l);
        if (l <= 0x100000L) return false;
        return true;
    }

    @InternalApi
    public static /* synthetic */ void isEligibleForAwsChunkedStreaming$annotations(HttpBody httpBody) {
    }

    public static final boolean getUseAwsChunkedEncoding(@NotNull AwsSigningConfig $this$useAwsChunkedEncoding) {
        Intrinsics.checkNotNullParameter((Object)$this$useAwsChunkedEncoding, (String)"<this>");
        HashSpecification hashSpecification = $this$useAwsChunkedEncoding.getHashSpecification();
        return hashSpecification instanceof HashSpecification.StreamingAws4HmacSha256Payload || hashSpecification instanceof HashSpecification.StreamingAws4HmacSha256PayloadWithTrailers || hashSpecification instanceof HashSpecification.StreamingUnsignedPayloadWithTrailers;
    }

    @InternalApi
    public static /* synthetic */ void getUseAwsChunkedEncoding$annotations(AwsSigningConfig awsSigningConfig) {
    }

    @InternalApi
    public static final void setAwsChunkedHeaders(@NotNull HttpRequestBuilder $this$setAwsChunkedHeaders) {
        Intrinsics.checkNotNullParameter((Object)$this$setAwsChunkedHeaders, (String)"<this>");
        $this$setAwsChunkedHeaders.getHeaders().append("Content-Encoding", (Object)"aws-chunked");
        $this$setAwsChunkedHeaders.getHeaders().set("Transfer-Encoding", (Object)"chunked");
        HeadersBuilder headersBuilder = $this$setAwsChunkedHeaders.getHeaders();
        String string = (String)$this$setAwsChunkedHeaders.getHeaders().get("Content-Length");
        if (string == null) {
            Long l = $this$setAwsChunkedHeaders.getBody().getContentLength();
            string = l != null ? l.toString() : null;
            if (string == null) {
                throw new ClientException("Expected \"Content-Length\" header or `body.contentLength` to be set for aws-chunked");
            }
        }
        headersBuilder.set("X-Amz-Decoded-Content-Length", (Object)string);
        $this$setAwsChunkedHeaders.getHeaders().remove("Content-Length");
    }

    @InternalApi
    public static final void setAwsChunkedBody(@NotNull HttpRequestBuilder $this$setAwsChunkedBody, @NotNull AwsSigner signer, @NotNull AwsSigningConfig signingConfig, @NotNull byte[] signature, @NotNull DeferredHeaders trailingHeaders) {
        HttpBody httpBody;
        Intrinsics.checkNotNullParameter((Object)$this$setAwsChunkedBody, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)signer, (String)"signer");
        Intrinsics.checkNotNullParameter((Object)signingConfig, (String)"signingConfig");
        Intrinsics.checkNotNullParameter((Object)signature, (String)"signature");
        Intrinsics.checkNotNullParameter((Object)trailingHeaders, (String)"trailingHeaders");
        HttpBody httpBody2 = $this$setAwsChunkedBody.getBody();
        if (httpBody2 instanceof HttpBody.ChannelContent) {
            SdkByteReadChannel sdkByteReadChannel = HttpBodyKt.toSdkByteReadChannel$default((HttpBody)$this$setAwsChunkedBody.getBody(), null, (int)1, null);
            if (sdkByteReadChannel == null) {
                String string = "Required value was null.";
                throw new IllegalStateException(string.toString());
            }
            httpBody = HttpBodyKt.toHttpBody((SdkByteReadChannel)new AwsChunkedByteReadChannel(sdkByteReadChannel, signer, signingConfig, signature, trailingHeaders), (Long)-1L);
        } else if (httpBody2 instanceof HttpBody.SourceContent) {
            HttpBody httpBody3 = $this$setAwsChunkedBody.getBody();
            Intrinsics.checkNotNull((Object)httpBody3, (String)"null cannot be cast to non-null type aws.smithy.kotlin.runtime.http.HttpBody.SourceContent");
            httpBody = HttpBodyKt.toHttpBody((SdkSource)new AwsChunkedSource(((HttpBody.SourceContent)httpBody3).readFrom(), signer, signingConfig, signature, trailingHeaders), (Long)-1L);
        } else {
            throw new ClientException("HttpBody type is not supported");
        }
        $this$setAwsChunkedBody.setBody(httpBody);
    }

    private static final CharSequence writeTrailers$lambda$2$lambda$1(String v) {
        Intrinsics.checkNotNullParameter((Object)v, (String)"v");
        return ((Object)StringsKt.trim((CharSequence)v)).toString();
    }
}

