/*
 * Decompiled with CFR 0.152.
 */
package aws.smithy.kotlin.runtime.awsprotocol.eventstream;

import aws.smithy.kotlin.runtime.InternalApi;
import aws.smithy.kotlin.runtime.awsprotocol.eventstream.HeaderType;
import aws.smithy.kotlin.runtime.awsprotocol.eventstream.HeaderValueKt;
import aws.smithy.kotlin.runtime.io.SdkBufferedSink;
import aws.smithy.kotlin.runtime.io.SdkBufferedSource;
import aws.smithy.kotlin.runtime.time.Instant;
import aws.smithy.kotlin.runtime.time.InstantKt;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.UByte;
import kotlin.UShort;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@InternalApi
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b7\u0018\u0000 \n2\u00020\u0001:\n\u0007\b\t\n\u000b\f\r\u000e\u000f\u0010B\u0007\b\u0004\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u0082\u0001\t\u0011\u0012\u0013\u0014\u0015\u0016\u0017\u0018\u0019\u00a8\u0006\u001a"}, d2={"Laws/smithy/kotlin/runtime/awsprotocol/eventstream/HeaderValue;", "", "()V", "encode", "", "dest", "Laws/smithy/kotlin/runtime/io/SdkBufferedSink;", "Bool", "Byte", "ByteArray", "Companion", "Int16", "Int32", "Int64", "String", "Timestamp", "Uuid", "Laws/smithy/kotlin/runtime/awsprotocol/eventstream/HeaderValue$Bool;", "Laws/smithy/kotlin/runtime/awsprotocol/eventstream/HeaderValue$Byte;", "Laws/smithy/kotlin/runtime/awsprotocol/eventstream/HeaderValue$ByteArray;", "Laws/smithy/kotlin/runtime/awsprotocol/eventstream/HeaderValue$Int16;", "Laws/smithy/kotlin/runtime/awsprotocol/eventstream/HeaderValue$Int32;", "Laws/smithy/kotlin/runtime/awsprotocol/eventstream/HeaderValue$Int64;", "Laws/smithy/kotlin/runtime/awsprotocol/eventstream/HeaderValue$String;", "Laws/smithy/kotlin/runtime/awsprotocol/eventstream/HeaderValue$Timestamp;", "Laws/smithy/kotlin/runtime/awsprotocol/eventstream/HeaderValue$Uuid;", "aws-event-stream"})
@SourceDebugExtension(value={"SMAP\nHeaderValue.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HeaderValue.kt\naws/smithy/kotlin/runtime/awsprotocol/eventstream/HeaderValue\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,193:1\n1#2:194\n*E\n"})
public abstract class HeaderValue {
    @NotNull
    public static final Companion Companion = new Companion(null);

    private HeaderValue() {
    }

    public final void encode(@NotNull SdkBufferedSink dest) {
        Intrinsics.checkNotNullParameter((Object)dest, (java.lang.String)"dest");
        HeaderValue headerValue = this;
        if (headerValue instanceof Bool) {
            HeaderType type = ((Bool)this).getValue() ? HeaderType.TRUE : HeaderType.FALSE;
            HeaderValueKt.access$writeHeader(dest, type);
        } else if (headerValue instanceof Byte) {
            HeaderValueKt.access$writeHeader(dest, HeaderType.BYTE);
            dest.writeByte(((Byte)this).getValue-w2LRezQ());
        } else if (headerValue instanceof Int16) {
            HeaderValueKt.access$writeHeader(dest, HeaderType.INT16);
            dest.writeShort(((Int16)this).getValue());
        } else if (headerValue instanceof Int32) {
            HeaderValueKt.access$writeHeader(dest, HeaderType.INT32);
            dest.writeInt(((Int32)this).getValue());
        } else if (headerValue instanceof Int64) {
            HeaderValueKt.access$writeHeader(dest, HeaderType.INT64);
            dest.writeLong(((Int64)this).getValue());
        } else if (headerValue instanceof ByteArray) {
            HeaderValueKt.access$writeHeader(dest, HeaderType.BYTE_ARRAY);
            int type = 0xFFFFFFFF & 0xFFFF;
            int n = ((ByteArray)this).getValue().length;
            if (!(0 <= n ? n <= type : false)) {
                boolean bl = false;
                java.lang.String string = "HeaderValue ByteArray too long";
                throw new IllegalStateException(string.toString());
            }
            dest.writeShort((short)((ByteArray)this).getValue().length);
            SdkBufferedSink.DefaultImpls.write$default((SdkBufferedSink)dest, (byte[])((ByteArray)this).getValue(), (int)0, (int)0, (int)6, null);
        } else if (headerValue instanceof String) {
            byte[] bytes = StringsKt.encodeToByteArray((java.lang.String)((String)this).getValue());
            int n = 0xFFFFFFFF & 0xFFFF;
            int n2 = bytes.length;
            if (!(0 <= n2 ? n2 <= n : false)) {
                boolean bl = false;
                java.lang.String string = "HeaderValue String too long";
                throw new IllegalStateException(string.toString());
            }
            HeaderValueKt.access$writeHeader(dest, HeaderType.STRING);
            dest.writeShort((short)bytes.length);
            SdkBufferedSink.DefaultImpls.write$default((SdkBufferedSink)dest, (byte[])bytes, (int)0, (int)0, (int)6, null);
        } else if (headerValue instanceof Timestamp) {
            HeaderValueKt.access$writeHeader(dest, HeaderType.TIMESTAMP);
            dest.writeLong(InstantKt.getEpochMilliseconds((Instant)((Timestamp)this).getValue()));
        } else if (headerValue instanceof Uuid) {
            HeaderValueKt.access$writeHeader(dest, HeaderType.UUID);
            dest.writeLong(((Uuid)this).getValue().getHigh());
            dest.writeLong(((Uuid)this).getValue().getLow());
        } else {
            throw new NoWhenBranchMatchedException();
        }
    }

    public /* synthetic */ HeaderValue(DefaultConstructorMarker $constructor_marker) {
        this();
    }

    @InternalApi
    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0087\b\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\t\u0010\u0007\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\t\u001a\u00020\u00032\b\u0010\n\u001a\u0004\u0018\u00010\u000bH\u00d6\u0003J\t\u0010\f\u001a\u00020\rH\u00d6\u0001J\t\u0010\u000e\u001a\u00020\u000fH\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0010"}, d2={"Laws/smithy/kotlin/runtime/awsprotocol/eventstream/HeaderValue$Bool;", "Laws/smithy/kotlin/runtime/awsprotocol/eventstream/HeaderValue;", "value", "", "(Z)V", "getValue", "()Z", "component1", "copy", "equals", "other", "", "hashCode", "", "toString", "", "aws-event-stream"})
    public static final class Bool
    extends HeaderValue {
        private final boolean value;

        public Bool(boolean value) {
            super(null);
            this.value = value;
        }

        public final boolean getValue() {
            return this.value;
        }

        public final boolean component1() {
            return this.value;
        }

        @NotNull
        public final Bool copy(boolean value) {
            return new Bool(value);
        }

        public static /* synthetic */ Bool copy$default(Bool bool, boolean bl, int n, Object object) {
            if ((n & 1) != 0) {
                bl = bool.value;
            }
            return bool.copy(bl);
        }

        @NotNull
        public java.lang.String toString() {
            return "Bool(value=" + this.value + ')';
        }

        public int hashCode() {
            return Boolean.hashCode(this.value);
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Bool)) {
                return false;
            }
            Bool bool = (Bool)other;
            return this.value == bool.value;
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @InternalApi
    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0087\b\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0016\u0010\b\u001a\u00020\u0003H\u00c6\u0003\u00f8\u0001\u0001\u00f8\u0001\u0000\u00a2\u0006\u0004\b\t\u0010\u0006J\u001d\u0010\n\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001\u00f8\u0001\u0000\u00a2\u0006\u0004\b\u000b\u0010\fJ\u0013\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u00d6\u0003J\t\u0010\u0011\u001a\u00020\u0012H\u00d6\u0001J\t\u0010\u0013\u001a\u00020\u0014H\u00d6\u0001R\u0019\u0010\u0002\u001a\u00020\u0003\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\n\n\u0002\u0010\u0007\u001a\u0004\b\u0005\u0010\u0006\u0082\u0002\u000b\n\u0005\b\u00a1\u001e0\u0001\n\u0002\b!\u00a8\u0006\u0015"}, d2={"Laws/smithy/kotlin/runtime/awsprotocol/eventstream/HeaderValue$Byte;", "Laws/smithy/kotlin/runtime/awsprotocol/eventstream/HeaderValue;", "value", "Lkotlin/UByte;", "(BLkotlin/jvm/internal/DefaultConstructorMarker;)V", "getValue-w2LRezQ", "()B", "B", "component1", "component1-w2LRezQ", "copy", "copy-7apg3OU", "(B)Laws/smithy/kotlin/runtime/awsprotocol/eventstream/HeaderValue$Byte;", "equals", "", "other", "", "hashCode", "", "toString", "", "aws-event-stream"})
    public static final class Byte
    extends HeaderValue {
        private final byte value;

        private Byte(byte value) {
            super(null);
            this.value = value;
        }

        public final byte getValue-w2LRezQ() {
            return this.value;
        }

        public final byte component1-w2LRezQ() {
            return this.value;
        }

        @NotNull
        public final Byte copy-7apg3OU(byte value) {
            return new Byte(value, null);
        }

        public static /* synthetic */ Byte copy-7apg3OU$default(Byte byteVal, byte by, int n, Object object) {
            if ((n & 1) != 0) {
                by = byteVal.value;
            }
            return byteVal.copy-7apg3OU(by);
        }

        @NotNull
        public java.lang.String toString() {
            return "Byte(value=" + UByte.toString-impl((byte)this.value) + ')';
        }

        public int hashCode() {
            return UByte.hashCode-impl((byte)this.value);
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Byte)) {
                return false;
            }
            Byte byteVal = (Byte)other;
            return this.value == byteVal.value;
        }

        public /* synthetic */ Byte(byte value, DefaultConstructorMarker $constructor_marker) {
            this(value);
        }
    }

    @InternalApi
    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0087\b\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\t\u0010\u0007\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u0096\u0002J\b\u0010\r\u001a\u00020\u000eH\u0016J\t\u0010\u000f\u001a\u00020\u0010H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0011"}, d2={"Laws/smithy/kotlin/runtime/awsprotocol/eventstream/HeaderValue$ByteArray;", "Laws/smithy/kotlin/runtime/awsprotocol/eventstream/HeaderValue;", "value", "", "([B)V", "getValue", "()[B", "component1", "copy", "equals", "", "other", "", "hashCode", "", "toString", "", "aws-event-stream"})
    public static final class ByteArray
    extends HeaderValue {
        @NotNull
        private final byte[] value;

        public ByteArray(@NotNull byte[] value) {
            Intrinsics.checkNotNullParameter((Object)value, (java.lang.String)"value");
            super(null);
            this.value = value;
        }

        @NotNull
        public final byte[] getValue() {
            return this.value;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (other == null || this.getClass() != other.getClass()) {
                return false;
            }
            ByteArray cfr_ignored_0 = (ByteArray)other;
            return Arrays.equals(this.value, ((ByteArray)other).value);
        }

        public int hashCode() {
            return Arrays.hashCode(this.value);
        }

        @NotNull
        public final byte[] component1() {
            return this.value;
        }

        @NotNull
        public final ByteArray copy(@NotNull byte[] value) {
            Intrinsics.checkNotNullParameter((Object)value, (java.lang.String)"value");
            return new ByteArray(value);
        }

        public static /* synthetic */ ByteArray copy$default(ByteArray byteArray, byte[] byArray, int n, Object object) {
            if ((n & 1) != 0) {
                byArray = byteArray.value;
            }
            return byteArray.copy(byArray);
        }

        @NotNull
        public java.lang.String toString() {
            return "ByteArray(value=" + Arrays.toString(this.value) + ')';
        }
    }

    @InternalApi
    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0087\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\u0007"}, d2={"Laws/smithy/kotlin/runtime/awsprotocol/eventstream/HeaderValue$Companion;", "", "()V", "decode", "Laws/smithy/kotlin/runtime/awsprotocol/eventstream/HeaderValue;", "source", "Laws/smithy/kotlin/runtime/io/SdkBufferedSource;", "aws-event-stream"})
    @SourceDebugExtension(value={"SMAP\nHeaderValue.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HeaderValue.kt\naws/smithy/kotlin/runtime/awsprotocol/eventstream/HeaderValue$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,193:1\n1#2:194\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final HeaderValue decode(@NotNull SdkBufferedSource source) {
            HeaderValue headerValue;
            Intrinsics.checkNotNullParameter((Object)source, (java.lang.String)"source");
            byte it = source.readByte();
            boolean bl = false;
            HeaderType type = HeaderType.Companion.fromTypeId(it);
            block0 : switch (WhenMappings.$EnumSwitchMapping$0[type.ordinal()]) {
                case 3: {
                    headerValue = new Bool(true);
                    break;
                }
                case 4: {
                    headerValue = new Bool(false);
                    break;
                }
                case 5: {
                    headerValue = new Byte(UByte.constructor-impl((byte)source.readByte()), null);
                    break;
                }
                case 6: {
                    headerValue = new Int16(source.readShort());
                    break;
                }
                case 7: {
                    headerValue = new Int32(source.readInt());
                    break;
                }
                case 8: {
                    headerValue = new Int64(source.readLong());
                    break;
                }
                case 1: 
                case 2: {
                    short len = UShort.constructor-impl((short)source.readShort());
                    if (!source.request((long)len & 0xFFFFL)) {
                        boolean $i$a$-check-HeaderValue$Companion$decode$22 = false;
                        java.lang.String $i$a$-check-HeaderValue$Companion$decode$22 = "Invalid HeaderValue; type=" + (Object)((Object)type) + ", len=" + UShort.toString-impl((short)len) + "; readRemaining: " + source.getBuffer().getSize();
                        throw new IllegalStateException($i$a$-check-HeaderValue$Companion$decode$22.toString());
                    }
                    byte[] bytes = source.readByteArray((long)len & 0xFFFFL);
                    switch (WhenMappings.$EnumSwitchMapping$0[type.ordinal()]) {
                        case 1: {
                            headerValue = new String(StringsKt.decodeToString((byte[])bytes));
                            break block0;
                        }
                        case 2: {
                            headerValue = new ByteArray(bytes);
                            break block0;
                        }
                    }
                    throw new IllegalStateException("Invalid HeaderValue");
                }
                case 9: {
                    long epochMilli = source.readLong();
                    headerValue = new Timestamp(InstantKt.fromEpochMilliseconds((Instant.Companion)Instant.Companion, (long)epochMilli));
                    break;
                }
                case 10: {
                    long high = source.readLong();
                    long low = source.readLong();
                    headerValue = new Uuid(new aws.smithy.kotlin.runtime.util.Uuid(high, low));
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            return headerValue;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={1, 9, 0}, k=3, xi=48)
        public final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;

            static {
                int[] nArray = new int[HeaderType.values().length];
                try {
                    nArray[HeaderType.STRING.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[HeaderType.BYTE_ARRAY.ordinal()] = 2;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[HeaderType.TRUE.ordinal()] = 3;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[HeaderType.FALSE.ordinal()] = 4;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[HeaderType.BYTE.ordinal()] = 5;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[HeaderType.INT16.ordinal()] = 6;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[HeaderType.INT32.ordinal()] = 7;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[HeaderType.INT64.ordinal()] = 8;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[HeaderType.TIMESTAMP.ordinal()] = 9;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[HeaderType.UUID.ordinal()] = 10;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                $EnumSwitchMapping$0 = nArray;
            }
        }
    }

    @InternalApi
    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\n\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0087\b\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\t\u0010\u0007\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u00d6\u0003J\t\u0010\r\u001a\u00020\u000eH\u00d6\u0001J\t\u0010\u000f\u001a\u00020\u0010H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0011"}, d2={"Laws/smithy/kotlin/runtime/awsprotocol/eventstream/HeaderValue$Int16;", "Laws/smithy/kotlin/runtime/awsprotocol/eventstream/HeaderValue;", "value", "", "(S)V", "getValue", "()S", "component1", "copy", "equals", "", "other", "", "hashCode", "", "toString", "", "aws-event-stream"})
    public static final class Int16
    extends HeaderValue {
        private final short value;

        public Int16(short value) {
            super(null);
            this.value = value;
        }

        public final short getValue() {
            return this.value;
        }

        public final short component1() {
            return this.value;
        }

        @NotNull
        public final Int16 copy(short value) {
            return new Int16(value);
        }

        public static /* synthetic */ Int16 copy$default(Int16 int16, short s, int n, Object object) {
            if ((n & 1) != 0) {
                s = int16.value;
            }
            return int16.copy(s);
        }

        @NotNull
        public java.lang.String toString() {
            return "Int16(value=" + this.value + ')';
        }

        public int hashCode() {
            return Short.hashCode(this.value);
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Int16)) {
                return false;
            }
            Int16 int16 = (Int16)other;
            return this.value == int16.value;
        }
    }

    @InternalApi
    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0087\b\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\t\u0010\u0007\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u00d6\u0003J\t\u0010\r\u001a\u00020\u0003H\u00d6\u0001J\t\u0010\u000e\u001a\u00020\u000fH\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0010"}, d2={"Laws/smithy/kotlin/runtime/awsprotocol/eventstream/HeaderValue$Int32;", "Laws/smithy/kotlin/runtime/awsprotocol/eventstream/HeaderValue;", "value", "", "(I)V", "getValue", "()I", "component1", "copy", "equals", "", "other", "", "hashCode", "toString", "", "aws-event-stream"})
    public static final class Int32
    extends HeaderValue {
        private final int value;

        public Int32(int value) {
            super(null);
            this.value = value;
        }

        public final int getValue() {
            return this.value;
        }

        public final int component1() {
            return this.value;
        }

        @NotNull
        public final Int32 copy(int value) {
            return new Int32(value);
        }

        public static /* synthetic */ Int32 copy$default(Int32 int32, int n, int n2, Object object) {
            if ((n2 & 1) != 0) {
                n = int32.value;
            }
            return int32.copy(n);
        }

        @NotNull
        public java.lang.String toString() {
            return "Int32(value=" + this.value + ')';
        }

        public int hashCode() {
            return Integer.hashCode(this.value);
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Int32)) {
                return false;
            }
            Int32 int32 = (Int32)other;
            return this.value == int32.value;
        }
    }

    @InternalApi
    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0087\b\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\t\u0010\u0007\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u00d6\u0003J\t\u0010\r\u001a\u00020\u000eH\u00d6\u0001J\t\u0010\u000f\u001a\u00020\u0010H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0011"}, d2={"Laws/smithy/kotlin/runtime/awsprotocol/eventstream/HeaderValue$Int64;", "Laws/smithy/kotlin/runtime/awsprotocol/eventstream/HeaderValue;", "value", "", "(J)V", "getValue", "()J", "component1", "copy", "equals", "", "other", "", "hashCode", "", "toString", "", "aws-event-stream"})
    public static final class Int64
    extends HeaderValue {
        private final long value;

        public Int64(long value) {
            super(null);
            this.value = value;
        }

        public final long getValue() {
            return this.value;
        }

        public final long component1() {
            return this.value;
        }

        @NotNull
        public final Int64 copy(long value) {
            return new Int64(value);
        }

        public static /* synthetic */ Int64 copy$default(Int64 int64, long l, int n, Object object) {
            if ((n & 1) != 0) {
                l = int64.value;
            }
            return int64.copy(l);
        }

        @NotNull
        public java.lang.String toString() {
            return "Int64(value=" + this.value + ')';
        }

        public int hashCode() {
            return Long.hashCode(this.value);
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Int64)) {
                return false;
            }
            Int64 int64 = (Int64)other;
            return this.value == int64.value;
        }
    }

    @InternalApi
    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0087\b\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\t\u0010\u0007\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u00d6\u0003J\t\u0010\r\u001a\u00020\u000eH\u00d6\u0001J\t\u0010\u000f\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0010"}, d2={"Laws/smithy/kotlin/runtime/awsprotocol/eventstream/HeaderValue$String;", "Laws/smithy/kotlin/runtime/awsprotocol/eventstream/HeaderValue;", "value", "", "(Ljava/lang/String;)V", "getValue", "()Ljava/lang/String;", "component1", "copy", "equals", "", "other", "", "hashCode", "", "toString", "aws-event-stream"})
    public static final class String
    extends HeaderValue {
        @NotNull
        private final java.lang.String value;

        public String(@NotNull java.lang.String value) {
            Intrinsics.checkNotNullParameter((Object)value, (java.lang.String)"value");
            super(null);
            this.value = value;
        }

        @NotNull
        public final java.lang.String getValue() {
            return this.value;
        }

        @NotNull
        public final java.lang.String component1() {
            return this.value;
        }

        @NotNull
        public final String copy(@NotNull java.lang.String value) {
            Intrinsics.checkNotNullParameter((Object)value, (java.lang.String)"value");
            return new String(value);
        }

        public static /* synthetic */ String copy$default(String string, java.lang.String string2, int n, Object object) {
            if ((n & 1) != 0) {
                string2 = string.value;
            }
            return string.copy(string2);
        }

        @NotNull
        public java.lang.String toString() {
            return "String(value=" + this.value + ')';
        }

        public int hashCode() {
            return this.value.hashCode();
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof String)) {
                return false;
            }
            String string = (String)other;
            return Intrinsics.areEqual((Object)this.value, (Object)string.value);
        }
    }

    @InternalApi
    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0087\b\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\t\u0010\u0007\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u00d6\u0003J\t\u0010\r\u001a\u00020\u000eH\u00d6\u0001J\t\u0010\u000f\u001a\u00020\u0010H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0011"}, d2={"Laws/smithy/kotlin/runtime/awsprotocol/eventstream/HeaderValue$Timestamp;", "Laws/smithy/kotlin/runtime/awsprotocol/eventstream/HeaderValue;", "value", "Laws/smithy/kotlin/runtime/time/Instant;", "(Laws/smithy/kotlin/runtime/time/Instant;)V", "getValue", "()Laws/smithy/kotlin/runtime/time/Instant;", "component1", "copy", "equals", "", "other", "", "hashCode", "", "toString", "", "aws-event-stream"})
    public static final class Timestamp
    extends HeaderValue {
        @NotNull
        private final Instant value;

        public Timestamp(@NotNull Instant value) {
            Intrinsics.checkNotNullParameter((Object)value, (java.lang.String)"value");
            super(null);
            this.value = value;
        }

        @NotNull
        public final Instant getValue() {
            return this.value;
        }

        @NotNull
        public final Instant component1() {
            return this.value;
        }

        @NotNull
        public final Timestamp copy(@NotNull Instant value) {
            Intrinsics.checkNotNullParameter((Object)value, (java.lang.String)"value");
            return new Timestamp(value);
        }

        public static /* synthetic */ Timestamp copy$default(Timestamp timestamp, Instant instant, int n, Object object) {
            if ((n & 1) != 0) {
                instant = timestamp.value;
            }
            return timestamp.copy(instant);
        }

        @NotNull
        public java.lang.String toString() {
            return "Timestamp(value=" + this.value + ')';
        }

        public int hashCode() {
            return this.value.hashCode();
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Timestamp)) {
                return false;
            }
            Timestamp timestamp = (Timestamp)other;
            return Intrinsics.areEqual((Object)this.value, (Object)timestamp.value);
        }
    }

    @InternalApi
    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0087\b\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\t\u0010\u0007\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u00d6\u0003J\t\u0010\r\u001a\u00020\u000eH\u00d6\u0001J\t\u0010\u000f\u001a\u00020\u0010H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0011"}, d2={"Laws/smithy/kotlin/runtime/awsprotocol/eventstream/HeaderValue$Uuid;", "Laws/smithy/kotlin/runtime/awsprotocol/eventstream/HeaderValue;", "value", "Laws/smithy/kotlin/runtime/util/Uuid;", "(Laws/smithy/kotlin/runtime/util/Uuid;)V", "getValue", "()Laws/smithy/kotlin/runtime/util/Uuid;", "component1", "copy", "equals", "", "other", "", "hashCode", "", "toString", "", "aws-event-stream"})
    public static final class Uuid
    extends HeaderValue {
        @NotNull
        private final aws.smithy.kotlin.runtime.util.Uuid value;

        public Uuid(@NotNull aws.smithy.kotlin.runtime.util.Uuid value) {
            Intrinsics.checkNotNullParameter((Object)value, (java.lang.String)"value");
            super(null);
            this.value = value;
        }

        @NotNull
        public final aws.smithy.kotlin.runtime.util.Uuid getValue() {
            return this.value;
        }

        @NotNull
        public final aws.smithy.kotlin.runtime.util.Uuid component1() {
            return this.value;
        }

        @NotNull
        public final Uuid copy(@NotNull aws.smithy.kotlin.runtime.util.Uuid value) {
            Intrinsics.checkNotNullParameter((Object)value, (java.lang.String)"value");
            return new Uuid(value);
        }

        public static /* synthetic */ Uuid copy$default(Uuid uuid, aws.smithy.kotlin.runtime.util.Uuid uuid2, int n, Object object) {
            if ((n & 1) != 0) {
                uuid2 = uuid.value;
            }
            return uuid.copy(uuid2);
        }

        @NotNull
        public java.lang.String toString() {
            return "Uuid(value=" + this.value + ')';
        }

        public int hashCode() {
            return this.value.hashCode();
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Uuid)) {
                return false;
            }
            Uuid uuid = (Uuid)other;
            return Intrinsics.areEqual((Object)this.value, (Object)uuid.value);
        }
    }
}

