// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.xray.serde

import aws.sdk.kotlin.services.xray.model.GetTraceSummariesRequest
import aws.sdk.kotlin.services.xray.model.SamplingStrategy
import aws.sdk.kotlin.services.xray.model.TimeRangeType
import aws.smithy.kotlin.runtime.http.HttpBody
import aws.smithy.kotlin.runtime.http.HttpMethod
import aws.smithy.kotlin.runtime.http.operation.HttpSerializer
import aws.smithy.kotlin.runtime.http.request.HttpRequestBuilder
import aws.smithy.kotlin.runtime.http.request.url
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.json.JsonSerializer
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.time.Instant
import aws.smithy.kotlin.runtime.time.TimestampFormat


internal class GetTraceSummariesOperationSerializer: HttpSerializer.NonStreaming<GetTraceSummariesRequest> {
    override fun serialize(context: ExecutionContext, input: GetTraceSummariesRequest): HttpRequestBuilder {
        val builder = HttpRequestBuilder()
        builder.method = HttpMethod.POST

        builder.url {
            path.encoded = "/TraceSummaries"
        }

        val payload = serializeGetTraceSummariesOperationBody(context, input)
        builder.body = HttpBody.fromBytes(payload)
        if (builder.body !is HttpBody.Empty) {
            builder.headers.setMissing("Content-Type", "application/json")
        }
        return builder
    }
}

private fun serializeGetTraceSummariesOperationBody(context: ExecutionContext, input: GetTraceSummariesRequest): ByteArray {
    val serializer = JsonSerializer()
    val ENDTIME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("EndTime"))
    val FILTEREXPRESSION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("FilterExpression"))
    val NEXTTOKEN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("NextToken"))
    val SAMPLING_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Boolean, JsonSerialName("Sampling"))
    val SAMPLINGSTRATEGY_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("SamplingStrategy"))
    val STARTTIME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("StartTime"))
    val TIMERANGETYPE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("TimeRangeType"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(ENDTIME_DESCRIPTOR)
        field(FILTEREXPRESSION_DESCRIPTOR)
        field(NEXTTOKEN_DESCRIPTOR)
        field(SAMPLING_DESCRIPTOR)
        field(SAMPLINGSTRATEGY_DESCRIPTOR)
        field(STARTTIME_DESCRIPTOR)
        field(TIMERANGETYPE_DESCRIPTOR)
    }

    serializer.serializeStruct(OBJ_DESCRIPTOR) {
        input.endTime?.let { field(ENDTIME_DESCRIPTOR, it, TimestampFormat.EPOCH_SECONDS) }
        input.filterExpression?.let { field(FILTEREXPRESSION_DESCRIPTOR, it) }
        input.nextToken?.let { field(NEXTTOKEN_DESCRIPTOR, it) }
        input.sampling?.let { field(SAMPLING_DESCRIPTOR, it) }
        input.samplingStrategy?.let { field(SAMPLINGSTRATEGY_DESCRIPTOR, it, ::serializeSamplingStrategyDocument) }
        input.startTime?.let { field(STARTTIME_DESCRIPTOR, it, TimestampFormat.EPOCH_SECONDS) }
        input.timeRangeType?.let { field(TIMERANGETYPE_DESCRIPTOR, it.value) }
    }
    return serializer.toByteArray()
}
