// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.xray.serde

import aws.sdk.kotlin.services.xray.model.GetTraceSummariesResponse
import aws.sdk.kotlin.services.xray.model.TraceSummary
import aws.sdk.kotlin.services.xray.model.XRayException
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.time.Instant
import kotlin.collections.mutableListOf


internal class GetTraceSummariesOperationDeserializer: HttpDeserializer.NonStreaming<GetTraceSummariesResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): GetTraceSummariesResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwGetTraceSummariesError(context, call, payload)
        }
        val builder = GetTraceSummariesResponse.Builder()

        if (payload != null) {
            deserializeGetTraceSummariesOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private fun throwGetTraceSummariesError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw XRayException("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "InvalidRequestException" -> InvalidRequestExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ThrottledException" -> ThrottledExceptionDeserializer().deserialize(context, wrappedCall, payload)
        else -> XRayException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeGetTraceSummariesOperationBody(builder: GetTraceSummariesResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val APPROXIMATETIME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("ApproximateTime"))
    val NEXTTOKEN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("NextToken"))
    val TRACESUMMARIES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("TraceSummaries"))
    val TRACESPROCESSEDCOUNT_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Long, JsonSerialName("TracesProcessedCount"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(APPROXIMATETIME_DESCRIPTOR)
        field(NEXTTOKEN_DESCRIPTOR)
        field(TRACESUMMARIES_DESCRIPTOR)
        field(TRACESPROCESSEDCOUNT_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                APPROXIMATETIME_DESCRIPTOR.index -> builder.approximateTime = deserializeString().let { Instant.fromEpochSeconds(it) }
                NEXTTOKEN_DESCRIPTOR.index -> builder.nextToken = deserializeString()
                TRACESUMMARIES_DESCRIPTOR.index -> builder.traceSummaries =
                    deserializer.deserializeList(TRACESUMMARIES_DESCRIPTOR) {
                        val col0 = mutableListOf<TraceSummary>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeTraceSummaryDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                TRACESPROCESSEDCOUNT_DESCRIPTOR.index -> builder.tracesProcessedCount = deserializeLong()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
