// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.xray.serde

import aws.sdk.kotlin.services.xray.model.GetTimeSeriesServiceStatisticsResponse
import aws.sdk.kotlin.services.xray.model.TimeSeriesServiceStatistics
import aws.sdk.kotlin.services.xray.model.XRayException
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import kotlin.collections.mutableListOf


internal class GetTimeSeriesServiceStatisticsOperationDeserializer: HttpDeserializer.NonStreaming<GetTimeSeriesServiceStatisticsResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): GetTimeSeriesServiceStatisticsResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwGetTimeSeriesServiceStatisticsError(context, call, payload)
        }
        val builder = GetTimeSeriesServiceStatisticsResponse.Builder()

        if (payload != null) {
            deserializeGetTimeSeriesServiceStatisticsOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private fun throwGetTimeSeriesServiceStatisticsError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw XRayException("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "InvalidRequestException" -> InvalidRequestExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ThrottledException" -> ThrottledExceptionDeserializer().deserialize(context, wrappedCall, payload)
        else -> XRayException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeGetTimeSeriesServiceStatisticsOperationBody(builder: GetTimeSeriesServiceStatisticsResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val CONTAINSOLDGROUPVERSIONS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Boolean, JsonSerialName("ContainsOldGroupVersions"))
    val NEXTTOKEN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("NextToken"))
    val TIMESERIESSERVICESTATISTICS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("TimeSeriesServiceStatistics"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(CONTAINSOLDGROUPVERSIONS_DESCRIPTOR)
        field(NEXTTOKEN_DESCRIPTOR)
        field(TIMESERIESSERVICESTATISTICS_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                CONTAINSOLDGROUPVERSIONS_DESCRIPTOR.index -> builder.containsOldGroupVersions = deserializeBoolean()
                NEXTTOKEN_DESCRIPTOR.index -> builder.nextToken = deserializeString()
                TIMESERIESSERVICESTATISTICS_DESCRIPTOR.index -> builder.timeSeriesServiceStatistics =
                    deserializer.deserializeList(TIMESERIESSERVICESTATISTICS_DESCRIPTOR) {
                        val col0 = mutableListOf<TimeSeriesServiceStatistics>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeTimeSeriesServiceStatisticsDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
