// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.xray.serde

import aws.sdk.kotlin.services.xray.model.GetSamplingTargetsResponse
import aws.sdk.kotlin.services.xray.model.SamplingTargetDocument
import aws.sdk.kotlin.services.xray.model.UnprocessedStatistics
import aws.sdk.kotlin.services.xray.model.XRayException
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.time.Instant
import kotlin.collections.mutableListOf


internal class GetSamplingTargetsOperationDeserializer: HttpDeserializer.NonStreaming<GetSamplingTargetsResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): GetSamplingTargetsResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwGetSamplingTargetsError(context, call, payload)
        }
        val builder = GetSamplingTargetsResponse.Builder()

        if (payload != null) {
            deserializeGetSamplingTargetsOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private fun throwGetSamplingTargetsError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw XRayException("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "InvalidRequestException" -> InvalidRequestExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ThrottledException" -> ThrottledExceptionDeserializer().deserialize(context, wrappedCall, payload)
        else -> XRayException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeGetSamplingTargetsOperationBody(builder: GetSamplingTargetsResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val LASTRULEMODIFICATION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("LastRuleModification"))
    val SAMPLINGTARGETDOCUMENTS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("SamplingTargetDocuments"))
    val UNPROCESSEDSTATISTICS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("UnprocessedStatistics"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(LASTRULEMODIFICATION_DESCRIPTOR)
        field(SAMPLINGTARGETDOCUMENTS_DESCRIPTOR)
        field(UNPROCESSEDSTATISTICS_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                LASTRULEMODIFICATION_DESCRIPTOR.index -> builder.lastRuleModification = deserializeString().let { Instant.fromEpochSeconds(it) }
                SAMPLINGTARGETDOCUMENTS_DESCRIPTOR.index -> builder.samplingTargetDocuments =
                    deserializer.deserializeList(SAMPLINGTARGETDOCUMENTS_DESCRIPTOR) {
                        val col0 = mutableListOf<SamplingTargetDocument>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeSamplingTargetDocumentDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                UNPROCESSEDSTATISTICS_DESCRIPTOR.index -> builder.unprocessedStatistics =
                    deserializer.deserializeList(UNPROCESSEDSTATISTICS_DESCRIPTOR) {
                        val col0 = mutableListOf<UnprocessedStatistics>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeUnprocessedStatisticsDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
