// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.xray.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * A segment from a trace that has been ingested by the X-Ray service. The segment can be compiled from documents uploaded with [PutTraceSegments](https://docs.aws.amazon.com/xray/latest/api/API_PutTraceSegments.html), or an `inferred` segment for a downstream service, generated from a subsegment sent by the service that called it.
 *
 * For the full segment document schema, see [Amazon Web Services X-Ray Segment Documents](https://docs.aws.amazon.com/xray/latest/devguide/xray-api-segmentdocuments.html) in the *Amazon Web Services X-Ray Developer Guide*.
 */
public class Segment private constructor(builder: Builder) {
    /**
     * The segment document.
     */
    public val document: kotlin.String? = builder.document
    /**
     * The segment's ID.
     */
    public val id: kotlin.String? = builder.id

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.xray.model.Segment = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("Segment(")
        append("document=$document,")
        append("id=$id")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = document?.hashCode() ?: 0
        result = 31 * result + (id?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as Segment

        if (document != other.document) return false
        if (id != other.id) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.xray.model.Segment = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The segment document.
         */
        public var document: kotlin.String? = null
        /**
         * The segment's ID.
         */
        public var id: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.xray.model.Segment) : this() {
            this.document = x.document
            this.id = x.id
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.xray.model.Segment = Segment(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
