// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.xray.model

import aws.smithy.kotlin.runtime.SdkDsl
import aws.smithy.kotlin.runtime.time.Instant

/**
 * Request sampling results for a single rule from a service. Results are for the last 10 seconds unless the service has been assigned a longer reporting interval after a previous call to [GetSamplingTargets](https://docs.aws.amazon.com/xray/latest/api/API_GetSamplingTargets.html).
 */
public class SamplingStatisticsDocument private constructor(builder: Builder) {
    /**
     * The number of requests recorded with borrowed reservoir quota.
     */
    public val borrowCount: kotlin.Int = builder.borrowCount
    /**
     * A unique identifier for the service in hexadecimal.
     */
    public val clientId: kotlin.String = requireNotNull(builder.clientId) { "A non-null value must be provided for clientId" }
    /**
     * The number of requests that matched the rule.
     */
    public val requestCount: kotlin.Int = builder.requestCount
    /**
     * The name of the sampling rule.
     */
    public val ruleName: kotlin.String = requireNotNull(builder.ruleName) { "A non-null value must be provided for ruleName" }
    /**
     * The number of requests recorded.
     */
    public val sampledCount: kotlin.Int = builder.sampledCount
    /**
     * The current time.
     */
    public val timestamp: aws.smithy.kotlin.runtime.time.Instant = requireNotNull(builder.timestamp) { "A non-null value must be provided for timestamp" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.xray.model.SamplingStatisticsDocument = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("SamplingStatisticsDocument(")
        append("borrowCount=$borrowCount,")
        append("clientId=$clientId,")
        append("requestCount=$requestCount,")
        append("ruleName=$ruleName,")
        append("sampledCount=$sampledCount,")
        append("timestamp=$timestamp")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = borrowCount
        result = 31 * result + (clientId.hashCode())
        result = 31 * result + (requestCount)
        result = 31 * result + (ruleName.hashCode())
        result = 31 * result + (sampledCount)
        result = 31 * result + (timestamp.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as SamplingStatisticsDocument

        if (borrowCount != other.borrowCount) return false
        if (clientId != other.clientId) return false
        if (requestCount != other.requestCount) return false
        if (ruleName != other.ruleName) return false
        if (sampledCount != other.sampledCount) return false
        if (timestamp != other.timestamp) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.xray.model.SamplingStatisticsDocument = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The number of requests recorded with borrowed reservoir quota.
         */
        public var borrowCount: kotlin.Int = 0
        /**
         * A unique identifier for the service in hexadecimal.
         */
        public var clientId: kotlin.String? = null
        /**
         * The number of requests that matched the rule.
         */
        public var requestCount: kotlin.Int = 0
        /**
         * The name of the sampling rule.
         */
        public var ruleName: kotlin.String? = null
        /**
         * The number of requests recorded.
         */
        public var sampledCount: kotlin.Int = 0
        /**
         * The current time.
         */
        public var timestamp: aws.smithy.kotlin.runtime.time.Instant? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.xray.model.SamplingStatisticsDocument) : this() {
            this.borrowCount = x.borrowCount
            this.clientId = x.clientId
            this.requestCount = x.requestCount
            this.ruleName = x.ruleName
            this.sampledCount = x.sampledCount
            this.timestamp = x.timestamp
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.xray.model.SamplingStatisticsDocument = SamplingStatisticsDocument(this)

        internal fun correctErrors(): Builder {
            if (clientId == null) clientId = ""
            if (ruleName == null) ruleName = ""
            if (timestamp == null) timestamp = Instant.fromEpochSeconds(0)
            return this
        }
    }
}
