// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.xray.model

import aws.smithy.kotlin.runtime.SdkDsl
import aws.smithy.kotlin.runtime.time.Instant

/**
 * A resource policy grants one or more Amazon Web Services services and accounts permissions to access X-Ray. Each resource policy is associated with a specific Amazon Web Services account.
 */
public class ResourcePolicy private constructor(builder: Builder) {
    /**
     * When the policy was last updated, in Unix time seconds.
     */
    public val lastUpdatedTime: aws.smithy.kotlin.runtime.time.Instant? = builder.lastUpdatedTime
    /**
     * The resource policy document, which can be up to 5kb in size.
     */
    public val policyDocument: kotlin.String? = builder.policyDocument
    /**
     * The name of the resource policy. Must be unique within a specific Amazon Web Services account.
     */
    public val policyName: kotlin.String? = builder.policyName
    /**
     * Returns the current policy revision id for this policy name.
     */
    public val policyRevisionId: kotlin.String? = builder.policyRevisionId

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.xray.model.ResourcePolicy = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ResourcePolicy(")
        append("lastUpdatedTime=$lastUpdatedTime,")
        append("policyDocument=$policyDocument,")
        append("policyName=$policyName,")
        append("policyRevisionId=$policyRevisionId")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = lastUpdatedTime?.hashCode() ?: 0
        result = 31 * result + (policyDocument?.hashCode() ?: 0)
        result = 31 * result + (policyName?.hashCode() ?: 0)
        result = 31 * result + (policyRevisionId?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ResourcePolicy

        if (lastUpdatedTime != other.lastUpdatedTime) return false
        if (policyDocument != other.policyDocument) return false
        if (policyName != other.policyName) return false
        if (policyRevisionId != other.policyRevisionId) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.xray.model.ResourcePolicy = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * When the policy was last updated, in Unix time seconds.
         */
        public var lastUpdatedTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The resource policy document, which can be up to 5kb in size.
         */
        public var policyDocument: kotlin.String? = null
        /**
         * The name of the resource policy. Must be unique within a specific Amazon Web Services account.
         */
        public var policyName: kotlin.String? = null
        /**
         * Returns the current policy revision id for this policy name.
         */
        public var policyRevisionId: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.xray.model.ResourcePolicy) : this() {
            this.lastUpdatedTime = x.lastUpdatedTime
            this.policyDocument = x.policyDocument
            this.policyName = x.policyName
            this.policyRevisionId = x.policyRevisionId
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.xray.model.ResourcePolicy = ResourcePolicy(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
